/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.Activator;
import com.ez.analysis.mainframe.usage.ElementAction;
import com.ez.analysis.mainframe.usage.ElementActionWithJob;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.annotations.UsagesAnnotationPartStateManager;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.ChangeLevelsOrderDialog;
import com.ez.analysis.mainframe.usage.ui.FilterController;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultElementSelectionListener;
import com.ez.analysis.mainframe.usage.ui.ResultsContentProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.SpinnerController;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotatedResultsContentProvider;
import com.ez.mainframe.gui.annotatedresults.AnnotatedViewer;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.ExecExportStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageViewer
extends AnnotatedViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UsageViewer.class);
    private static final String NO_RESULTS_KEY = "No results";
    private static final String TO_SHOW_FILTERS_KEY = "Show filters";
    private static final String IS_CANCELED_KEY = "IS_CANCELED";
    private static final String HIDE_FILTERS_AREA_TOOLTIP = Messages.getString(UsageViewer.class, "hide.filters.area.tooltip");
    private static final String SHOW_FILTERS_AREA_TOOLTIP = Messages.getString(UsageViewer.class, "show.filters.area.tooltip");
    private final String SHOW_SOURCE = Messages.getString(UsageViewer.class, "goToSource.button");
    protected final String SHOW_REMOTE_SOURCE = Messages.getString(UsageViewer.class, "goToRemoteSource.button");
    private final String EXPAND_ACTION_TEXT = Messages.getString(UsageViewer.class, "expand.action.text");
    private ImageRegistry imgRegistry;
    private Label tabSummary;
    private FilterController filterCtrl;
    private ToolItem expandAllItem;
    private ToolItem exportResultsItem;
    private ToolItem orderItem;
    private ToolItem collapseAllItem;
    private UsageDescriptorAdapter descriptor;
    private ElementActionWithJob linkEditor = null;
    private ElementAction expandNodeAction = null;
    private ActionContributionItem expandNodeActionContributionItem = null;
    private SpinnerController spinnerController;
    private IActionManager manager;

    public UsageViewer(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
        descriptor.initialize();
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.manager = manager;
        this.initImageRegistry(manager);
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new FormLayout());
        final Button button = new Button(panel, 2);
        final Composite filtersArea = new Composite(panel, 0);
        final Composite resultsArea = new Composite(panel, 2048);
        Map<String, Object> data = this.descriptor.getState().getData();
        Boolean allowMultiple = (Boolean)data.get("allow multiple project selection in project list");
        Boolean showProjects = (Boolean)data.get("show project selection list");
        allowMultiple = allowMultiple == null ? true : allowMultiple;
        showProjects = showProjects == null ? true : showProjects;
        Boolean disableLimits = (Boolean)data.get("disable_limits");
        this.filterCtrl = new FilterController(this, filtersArea, allowMultiple, showProjects, disableLimits != null ? disableLimits : false);
        FormData buttonFd = new FormData();
        buttonFd.top = new FormAttachment(0);
        buttonFd.left = new FormAttachment(0);
        button.setLayoutData((Object)buttonFd);
        this.tabSummary = new Label(panel, 0x1000200);
        FormData summaryFd = new FormData();
        int buttonHeight = button.computeSize((int)-1, (int)-1).y;
        summaryFd.top = new FormAttachment(0, buttonHeight / 4);
        summaryFd.bottom = new FormAttachment(10, buttonHeight / 4);
        summaryFd.left = new FormAttachment((Control)button, 5);
        this.tabSummary.setLayoutData((Object)summaryFd);
        final FormData hSashData = new FormData();
        hSashData.right = new FormAttachment(100);
        hSashData.left = new FormAttachment(0);
        hSashData.bottom = new FormAttachment(50);
        final Sash hSash = new Sash(panel, 256);
        hSash.setLayoutData((Object)hSashData);
        hSash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (130 < e.y && e.y < 550) {
                    hSashData.top = new FormAttachment(0, e.y);
                    hSashData.bottom = new FormAttachment(0, e.y + 3);
                    hSash.getParent().layout();
                }
            }
        });
        final FormData filtersShown = new FormData();
        filtersShown.top = new FormAttachment((Control)button);
        filtersShown.left = new FormAttachment(0);
        filtersShown.right = new FormAttachment(100);
        filtersShown.bottom = new FormAttachment((Control)hSash);
        final FormData filtersHidden = new FormData();
        filtersHidden.top = new FormAttachment((Control)button);
        filtersHidden.left = new FormAttachment(0);
        filtersHidden.right = new FormAttachment(100);
        filtersHidden.bottom = new FormAttachment(0);
        final FormData resultsPartial = new FormData();
        resultsPartial.top = new FormAttachment((Control)hSash);
        resultsPartial.left = new FormAttachment(0);
        resultsPartial.right = new FormAttachment(100);
        resultsPartial.bottom = new FormAttachment(100);
        final FormData resultsFull = new FormData();
        resultsFull.top = new FormAttachment((Control)button);
        resultsFull.left = new FormAttachment(0);
        resultsFull.right = new FormAttachment(100);
        resultsFull.bottom = new FormAttachment(100);
        this.addBtnListeners(panel, button, filtersArea, resultsArea, filtersShown, filtersHidden, resultsPartial, resultsFull);
        this.buildResultsArea(resultsArea, manager);
        panel.setTabList(new Control[]{button, this.tabSummary, filtersArea, resultsArea});
        this.update(new Runnable(){

            @Override
            public void run() {
                Boolean filterButtonState = (Boolean)UsageViewer.this.descriptor.getState().getData().get("ApplyButtonState");
                boolean resultsNotComputed = UsageViewer.this.resultsTreeViewer.getTree().getItemCount() == 0;
                UsageViewer.this.descriptor.getState().getData().put("ResultsTree", resultsNotComputed);
                boolean applyFilterEnable = UsageViewer.this.descriptor.getState().getData().get(UsageViewer.TO_SHOW_FILTERS_KEY) != null ? (Boolean)UsageViewer.this.descriptor.getState().getData().get(UsageViewer.TO_SHOW_FILTERS_KEY) : (filterButtonState != null ? true : resultsNotComputed);
                UsageViewer.this.applyLayoutFiltersArea(button, filtersArea, resultsArea, filtersShown, filtersHidden, resultsPartial, resultsFull, applyFilterEnable);
                if (!applyFilterEnable) {
                    UsageStateAdapter state = UsageViewer.this.descriptor.getState();
                    FilterData filterData = (FilterData)state.getData().get("FilterData");
                    List prjList = (List)state.getData().get("PROJECT_LIST");
                    String summary = filterData.createFullSummary(UsageViewer.this.descriptor.isEnableLimits(), true, prjList);
                    state.getData().put("fullSummary", summary);
                }
                UsageViewer.this.filterCtrl.enableFilterAction();
            }
        });
        return panel;
    }

    private void addBtnListeners(final Composite panel, final Button button, final Composite filtersArea, final Composite resultsArea, final FormData filtersShown, final FormData filtersHidden, final FormData resultsPartial, final FormData resultsFull) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageViewer.this.applyLayoutFiltersArea(button, filtersArea, resultsArea, filtersShown, filtersHidden, resultsPartial, resultsFull, filtersArea.getLayoutData() != filtersShown);
                boolean showFilters = filtersArea.getLayoutData() != filtersShown;
                Map<String, Object> data = UsageViewer.this.descriptor.getState().getData();
                data.put(UsageViewer.TO_SHOW_FILTERS_KEY, !showFilters);
                panel.layout();
            }
        });
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(UsageViewer.class, "filters.button.name");
            }
        });
    }

    private void applyLayoutFiltersArea(Button button, Composite filtersArea, Composite resultsArea, FormData filtersShown, FormData filtersHidden, FormData resultsPartial, FormData resultsFull, boolean showFilterArea) {
        if (showFilterArea) {
            filtersArea.setLayoutData((Object)filtersShown);
            resultsArea.setLayoutData((Object)resultsPartial);
            button.setImage(this.imgRegistry.get("filtersExpanded"));
            button.setToolTipText(HIDE_FILTERS_AREA_TOOLTIP);
        } else {
            filtersArea.setLayoutData((Object)filtersHidden);
            resultsArea.setLayoutData((Object)resultsFull);
            button.setImage(this.imgRegistry.get("filtersCollapsed"));
            button.setToolTipText(SHOW_FILTERS_AREA_TOOLTIP);
        }
    }

    protected DelegatingStyledCellLabelProvider.IStyledLabelProvider getLabelProvider() {
        return (DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.descriptor.getResultsLabelProvider(this.imgRegistry);
    }

    protected AnnotatedResultsContentProvider getContentProvider() {
        return new ResultsContentProvider((UsagesAnnotationPartStateManager)this.annStateManager);
    }

    protected void instantiateAnnotStateManager() {
        this.annStateManager = new UsagesAnnotationPartStateManager(this);
    }

    private void buildResultsArea(Composite parent, IActionManager manager) {
        GridLayout gridLayout = new GridLayout(2, false);
        parent.setLayout((Layout)gridLayout);
        Composite filterComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 5;
        gl.horizontalSpacing = 1;
        gl.marginLeft = -5;
        gl.marginRight = -5;
        filterComp.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        filterComp.setLayoutData((Object)gd);
        this.spinnerController = new SpinnerController(filterComp, this.imgRegistry, this.descriptor.hasAnnotationsFilterAction());
        ToolBar resultTreeToolBar = new ToolBar(parent, 0x800000);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        resultTreeToolBar.setLayoutData((Object)gridData);
        resultTreeToolBar.getAccessible().addAccessibleListener((AccessibleListener)new ToolbarAccessibleAdapter());
        this.makeReorderingAction(parent, resultTreeToolBar);
        this.makeExpandAllAction(resultTreeToolBar);
        this.makeCollapseAllAction(resultTreeToolBar);
        this.makeExportCSVAction(parent, resultTreeToolBar);
        Group gp = new Group(parent, 0);
        gp.setText(Messages.getString(UsageViewer.class, "results.title"));
        gp.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gp.setLayoutData((Object)gridData);
        this.buildTreeViewer((Composite)gp);
        this.resultsTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                ResultElement resultElem = (ResultElement)((Object)thisSelection.getFirstElement());
                ResultsTreeProvider provider = UsageViewer.this.descriptor.getTreeProvider();
                ElementActionWithJob action = provider.contributeToDoubleClick(resultElem);
                if (action == null) {
                    action = UsageViewer.this.makeLinkEditorAction(resultElem);
                }
                if (action != null) {
                    action.run();
                }
            }
        });
        this.spinnerController.setTreeViewer(this.resultsTreeViewer);
        this.spinnerController.setAnnManager((UsagesAnnotationPartStateManager)this.annStateManager);
        this.handleContextMenu();
        ResultElementSelectionListener listener = new ResultElementSelectionListener((AbstractActionDescriptor)this.descriptor, manager);
        this.resultsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        parent.setTabList(new Control[]{filterComp, resultTreeToolBar, gp});
    }

    private void makeExportCSVAction(final Composite parent, ToolBar resultTreeToolBar) {
        this.exportResultsItem = new ToolItem(resultTreeToolBar, 8);
        Image exportImg = this.imgRegistry.get("exportImg");
        this.exportResultsItem.setImage(exportImg);
        this.exportResultsItem.setToolTipText(Messages.getString(UsageViewer.class, "results.export.tooltip"));
        Image disableExportImg = this.imgRegistry.get("disableExportImg");
        this.exportResultsItem.setDisabledImage(disableExportImg);
        this.exportResultsItem.setEnabled(false);
        this.exportResultsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog exportFileDialog = new FileDialog(parent.getShell(), 8192);
                exportFileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                exportFileDialog.setFilterNames(new String[]{Messages.getString(UsageViewer.class, "export.filterName.csv"), Messages.getString(UsageViewer.class, "export.filterName.all")});
                final String fileNamePath = exportFileDialog.open();
                final ArrayList files = new ArrayList();
                Job exportJob = new Job(Messages.getString(UsageViewer.class, "export.csv.job.name")){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (fileNamePath != null) {
                            monitor.beginTask(Messages.getString(UsageViewer.class, "export.csv.exportTask.name"), 100);
                            Utils.exportResultsCSV(UsageViewer.this.descriptor, fileNamePath, files, monitor);
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                exportJob.setUser(true);
                exportJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (!files.isEmpty()) {
                            ExecExportStatus ees = new ExecExportStatus();
                            ees.exportStatus = true;
                            ees.exportFileList = files;
                            Display.getDefault().syncExec((Runnable)ees);
                        }
                    }
                });
                exportJob.schedule();
            }
        });
    }

    private void makeCollapseAllAction(ToolBar resultTreeToolBar) {
        this.collapseAllItem = new ToolItem(resultTreeToolBar, 8);
        Image collapseImg = this.imgRegistry.get("collapseImg");
        this.collapseAllItem.setEnabled(false);
        this.collapseAllItem.setImage(collapseImg);
        this.collapseAllItem.setToolTipText(Messages.getString(UsageViewer.class, "results.collapseAll.tooltip"));
        this.collapseAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageViewer.this.resultsTreeViewer.collapseAll();
            }
        });
    }

    private void makeExpandAllAction(ToolBar resultTreeToolBar) {
        this.expandAllItem = new ToolItem(resultTreeToolBar, 8);
        Image expandImg = this.imgRegistry.get("expandImg");
        this.expandAllItem.setImage(expandImg);
        this.expandAllItem.setEnabled(false);
        int defaultExpandLevel = this.descriptor.getDefaultExpandLevel();
        String tooltip = defaultExpandLevel == -1 ? Messages.getString(UsageViewer.class, "results.expandAll.tooltip") : (defaultExpandLevel == 2 ? Messages.getString(UsageViewer.class, "results.expandTopOne.tooltip") : Messages.getString(UsageViewer.class, "results.expandTop.tooltip", new Object[]{defaultExpandLevel - 1}));
        this.expandAllItem.setToolTipText(tooltip);
        this.expandAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageViewer.this.resultsTreeViewer.expandToLevel(UsageViewer.this.descriptor.getDefaultExpandLevel());
            }
        });
    }

    private void makeReorderingAction(final Composite parent, ToolBar resultTreeToolBar) {
        if (this.descriptor.hasReorderResultsAction()) {
            this.orderItem = new ToolItem(resultTreeToolBar, 8);
            Image orderImg = this.imgRegistry.get("treeOrder");
            this.orderItem.setEnabled(false);
            this.orderItem.setImage(orderImg);
            this.orderItem.setToolTipText(Messages.getString(UsageViewer.class, "results.order.tooltip"));
            this.orderItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UsageStateAdapter state = UsageViewer.this.descriptor.getState();
                    FilterData filterData = (FilterData)state.getData().get("FilterData");
                    List<ResultElementType> initialLevelsOrder = UsageViewer.this.descriptor.getTreeProvider().getLevelsOrder();
                    List<FilterEntry> filterEntries = filterData.getEntries();
                    ArrayList<FilterEntry> initialFilterEntriesOrder = new ArrayList<FilterEntry>();
                    HashMap<FilterEntry, ResultElementType> map = new HashMap<FilterEntry, ResultElementType>();
                    for (ResultElementType level : initialLevelsOrder) {
                        for (FilterEntry filterEntry : filterEntries) {
                            if (filterEntry.get("filterEntryName") != level.name()) continue;
                            map.put(filterEntry, level);
                            initialFilterEntriesOrder.add(filterEntry);
                        }
                        UsageViewer.this.completeWithAditionalLevels(initialFilterEntriesOrder, map, level);
                    }
                    final ChangeLevelsOrderDialog orderDialog = new ChangeLevelsOrderDialog(parent.getShell(), initialFilterEntriesOrder, UsageViewer.this.imgRegistry);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            orderDialog.open();
                        }
                    });
                    if (orderDialog.getReturnCode() == 0) {
                        List<FilterEntry> order = orderDialog.getOrder();
                        ArrayList<ResultElementType> resultElementTypesOrderList = new ArrayList<ResultElementType>();
                        for (FilterEntry filterEntry : order) {
                            resultElementTypesOrderList.add((ResultElementType)map.get(filterEntry));
                        }
                        UsageViewer.this.descriptor.getTreeProvider().setLevelsOrder(resultElementTypesOrderList);
                        UsageViewer.this.update(null);
                    }
                }
            });
        }
    }

    private void completeWithAditionalLevels(List<FilterEntry> initialFilterEntriesOrder, Map<FilterEntry, ResultElementType> map, ResultElementType level) {
        if ((level.equals((Object)ResultElementType.PROJECT_INFO) || level.equals((Object)ResultElementType.IMSDB_DATABASE) || level.equals((Object)ResultElementType.IMSDB_SEGMENT) || level.equals((Object)ResultElementType.CATALOG_TARGET) || level.equals((Object)ResultElementType.STMT_SOURCE_INFO)) && !map.containsValue(level)) {
            FilterEntry fakeLvlFilterEntry = new FilterEntry(level, null, null);
            map.put(fakeLvlFilterEntry, level);
            initialFilterEntriesOrder.add(fakeLvlFilterEntry);
        }
    }

    private void handleContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UsageViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.resultsTreeViewer.getControl());
        this.resultsTreeViewer.getControl().setMenu(menu);
        this.resultsTreeViewer.getTree().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if ((event.stateMask & 0x40000) != 0 && event.keyCode == 99) {
                    UsageViewer.this.copyFromTreeToClipboard();
                    event.doit = false;
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection sel = this.resultsTreeViewer.getSelection();
        Object objSel = ((IStructuredSelection)sel).getFirstElement();
        if (objSel != null && objSel instanceof ResultElement && ((IStructuredSelection)sel).size() == 1) {
            ResultsTreeProvider provider;
            List<ElementActionWithJob> actions;
            ResultElement resultElem = (ResultElement)((Object)objSel);
            if (resultElem.getType().equals((Object)ResultElementType.LIMIT_REACHED)) {
                return;
            }
            ElementActionWithJob action = this.makeLinkEditorAction(resultElem);
            if (action != null) {
                manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)action));
                manager.add((IContributionItem)new Separator());
            }
            if ((actions = (provider = this.descriptor.getTreeProvider()).contributeToContextMenu(resultElem)) != null) {
                for (ElementActionWithJob ac : actions) {
                    manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)ac));
                }
                manager.add((IContributionItem)new Separator());
            }
            this.addCopyAction(manager);
            if (resultElem != null) {
                if (resultElem.hasChildren()) {
                    if (this.expandNodeAction == null) {
                        this.expandNodeAction = new ElementAction(){

                            public void run() {
                                ResultElement resultElem = this.getResultElem();
                                UsageViewer.this.resultsTreeViewer.expandToLevel((Object)resultElem, -1);
                            }
                        };
                        this.expandNodeAction.setText(this.EXPAND_ACTION_TEXT);
                    }
                    this.expandNodeAction.setResultElem(resultElem);
                    this.expandNodeActionContributionItem = new ActionContributionItem((org.eclipse.jface.action.IAction)this.expandNodeAction);
                    manager.add((IContributionItem)this.expandNodeActionContributionItem);
                    this.setExpandNodeActionEnableState(resultElem);
                } else if (this.expandNodeAction != null) {
                    manager.remove((IContributionItem)this.expandNodeActionContributionItem);
                }
                ResultElement parentElement = resultElem.getParent();
                while (parentElement != null) {
                    Integer level;
                    ElementAction collapseNodeAction = new ElementAction(){

                        public void run() {
                            ResultElement resultElem = this.getResultElem();
                            UsageViewer.this.resultsTreeViewer.collapseToLevel((Object)resultElem, 1);
                        }
                    };
                    String displayName = parentElement.getType().getDisplayName();
                    boolean isCategory = parentElement.getType().isCategory();
                    if (ResultElementType.VARIABLE.equals((Object)parentElement.getType()) && (level = (Integer)parentElement.getProperty(DatabaseMetadata.VAR_iLevel.getName())) != null) {
                        displayName = Messages.getString(UsageViewer.class, "display.name.level", new String[]{displayName, String.format("%02d", level)});
                    }
                    String collapseNodeText = isCategory ? Messages.getString(UsageViewer.class, "collapseToLevel.category.action.text", new String[]{displayName}) : Messages.getString(UsageViewer.class, "collapseToLevel.action.text", new String[]{displayName});
                    collapseNodeAction.setText(collapseNodeText);
                    collapseNodeAction.setResultElem(parentElement);
                    ActionContributionItem collapseNodeActionContributionItem = new ActionContributionItem((org.eclipse.jface.action.IAction)collapseNodeAction);
                    manager.add((IContributionItem)collapseNodeActionContributionItem);
                    parentElement = parentElement.getParent();
                }
            }
        }
    }

    private void setExpandNodeActionEnableState(ResultElement resultElem) {
        boolean state;
        boolean isExpanded = this.resultsTreeViewer.getExpandedState((Object)resultElem);
        boolean bl = state = !isExpanded;
        if (isExpanded) {
            state = this.getChildState(resultElem, state);
        }
        this.expandNodeAction.setEnabled(state);
    }

    private boolean getChildState(ResultElement resultElem, boolean state) {
        Map childrenMap = resultElem.getChildren();
        for (String childStr : childrenMap.keySet()) {
            AbstractResultElement child = (AbstractResultElement)childrenMap.get(childStr);
            if (!this.resultsTreeViewer.isExpandable((Object)child)) continue;
            boolean isChildExpanded = this.resultsTreeViewer.getExpandedState((Object)child);
            if (!isChildExpanded) {
                state = true;
                break;
            }
            if (state = this.getChildState((ResultElement)child, state)) break;
        }
        return state;
    }

    private void addCopyAction(IMenuManager manager) {
        manager.add((org.eclipse.jface.action.IAction)new Action(){
            {
                this.setText(Messages.getString(UsageViewer.class, "copy.action.text"));
                this.setAccelerator(262243);
            }

            public void run() {
                UsageViewer.this.copyFromTreeToClipboard();
            }
        });
        manager.add((IContributionItem)new Separator());
    }

    private ElementActionWithJob makeLinkEditorAction(ResultElement resultElem) {
        if (resultElem != null && resultElem.getProperty("GOTOSOURCE") != null && ((Boolean)resultElem.getProperty("GOTOSOURCE")).booleanValue()) {
            if (this.linkEditor == null) {
                this.linkEditor = new ElementActionWithJob(){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(UsageViewer.class, "goToSource.task.text"), -1);
                        ResultElement resultElem = this.getResultElem();
                        HashSet options = (HashSet)resultElem.getProperty("FILE");
                        ProjectInfo pi = (ProjectInfo)resultElem.getProperty("ProjectInfo");
                        if (pi == null) {
                            ArrayList piList = (ArrayList)resultElem.getProperty("ProjectInfo List");
                            for (ProjectInfo prjInfo : piList) {
                                if (piList.size() != 1) continue;
                                pi = prjInfo;
                                break;
                            }
                        }
                        String projectName = pi != null ? pi.getName() : null;
                        com.ez.cobol.callgraph.utils.Utils.openEditor((Set)options, (String)projectName);
                        monitor.done();
                    }
                };
                this.linkEditor.setText(this.SHOW_SOURCE);
            }
            this.linkEditor.setResultElem(resultElem);
            return this.linkEditor;
        }
        return null;
    }

    public void update(final Runnable onComputeResults) {
        if (this.resultsTreeViewer != null && !this.resultsTreeViewer.getControl().isDisposed()) {
            Job j = new Job(Messages.getString(UsageViewer.class, "job.name")){

                protected IStatus run(IProgressMonitor monitor) {
                    UsageViewer.this.doUpdate(monitor, onComputeResults);
                    return Status.OK_STATUS;
                }
            };
            j.setUser(false);
            j.schedule();
        }
    }

    private void doUpdate(IProgressMonitor pmonitor, final Runnable onComputeResults) {
        if (!pmonitor.isCanceled()) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(UsageViewer.class, "prepareResults.task"));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!UsageViewer.this.resultsTreeViewer.getControl().isDisposed()) {
                        UsageViewer.this.resultsTreeViewer.setInput(null);
                    }
                }
            });
            final ResultElement root = this.setInputForResultsTreeViewer((IProgressMonitor)monitor.newChild(95));
            monitor.setTaskName(Messages.getString(UsageViewer.class, "updateGUI.task"));
            monitor.worked(5);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!UsageViewer.this.resultsTreeViewer.getControl().isDisposed()) {
                        UsageViewer.this.manager.setCurrentContext((IActionContext)UsageViewer.this.descriptor.getState());
                        UsageViewer.this.buildTabSummary();
                        UsageViewer.this.resultsTreeViewer.setInput((Object)root.getChildren());
                        UsageViewer.this.spinnerController.filterItems();
                        if (onComputeResults != null) {
                            onComputeResults.run();
                        }
                        boolean enabled = root != null && root.getChildren() != null && !root.getChildren().containsKey(UsageViewer.NO_RESULTS_KEY);
                        UsageViewer.this.exportResultsItem.setEnabled(enabled);
                        if (UsageViewer.this.descriptor.hasReorderResultsAction()) {
                            UsageViewer.this.orderItem.setEnabled(enabled);
                        }
                        UsageViewer.this.expandAllItem.setEnabled(enabled);
                        UsageViewer.this.collapseAllItem.setEnabled(enabled);
                    }
                }
            });
        }
    }

    private ResultElement setInputForResultsTreeViewer(IProgressMonitor pmonitor) {
        Map<String, Object> data = this.descriptor.getState().getData();
        ResultElement root = new ResultElement("root", null, null);
        if (data.get(IS_CANCELED_KEY) != null && ((Boolean)data.get(IS_CANCELED_KEY)).booleanValue()) {
            L.debug("action canceled by user");
        } else {
            boolean addNoData = false;
            RecordsetProvider rsProvider = this.descriptor.getRecordsetProvider("RECORDSET");
            if (rsProvider != null) {
                ResultsTreeProvider provider = this.descriptor.getTreeProvider();
                provider.setLevelsOrder(this.descriptor.computeLevelsOrder());
                provider.buildResultsTree(root, rsProvider, pmonitor);
                if (!root.hasChildren()) {
                    addNoData = true;
                }
            } else if (data.get("apiResPart") != null && data.get("apiNodes") != null) {
                addNoData = true;
            }
            if (addNoData) {
                root.addChild(NO_RESULTS_KEY, new ResultElement(Messages.getString(UsageViewer.class, "noData.results.text"), null, null));
            }
        }
        return root;
    }

    private void initImageRegistry(IActionManager manager) {
        if (this.imgRegistry == null) {
            this.imgRegistry = ((BrowserManager)manager).getImageRegistry();
        }
        if (this.imgRegistry.get("arrowUp") == null) {
            this.imgRegistry.put("arrowUp", Activator.getImageDescriptor("icons/arrow_sans_up_16.png"));
        }
        if (this.imgRegistry.get("arrowDown") == null) {
            this.imgRegistry.put("arrowDown", Activator.getImageDescriptor("icons/arrow_sans_down_16.png"));
        }
        if (this.imgRegistry.get("filtersCollapsed") == null) {
            this.imgRegistry.put("filtersCollapsed", Activator.getImageDescriptor("icons/collapsed_16.png"));
        }
        if (this.imgRegistry.get("filtersExpanded") == null) {
            this.imgRegistry.put("filtersExpanded", Activator.getImageDescriptor("icons/expanded_16.png"));
        }
        if (this.imgRegistry.get("applyFilters") == null) {
            this.imgRegistry.put("applyFilters", Activator.getImageDescriptor("icons/filter_16.png"));
        }
        if (this.imgRegistry.get("orderImg") == null) {
            this.imgRegistry.put("orderImg", Activator.getImageDescriptor("icons/reorder_16.png"));
        }
        if (this.imgRegistry.get("collapseImg") == null) {
            this.imgRegistry.put("collapseImg", Activator.getImageDescriptor("icons/collapseall_16x16.gif"));
        }
        if (this.imgRegistry.get("expandImg") == null) {
            this.imgRegistry.put("expandImg", Activator.getImageDescriptor("icons/expandall_16x16.gif"));
        }
        if (this.imgRegistry.get("searchImg") == null) {
            this.imgRegistry.put("searchImg", Activator.getImageDescriptor("icons/search.png"));
        }
        if (this.imgRegistry.get("reloadImg") == null) {
            this.imgRegistry.put("reloadImg", Activator.getImageDescriptor("icons/refresh_16x16.png"));
        }
        if (this.imgRegistry.get("treeOrder") == null) {
            this.imgRegistry.put("treeOrder", Activator.getImageDescriptor("icons/reverse_order_16x16.png"));
        }
        if (this.imgRegistry.get("exportImg") == null) {
            this.imgRegistry.put("exportImg", Activator.getImageDescriptor("icons/Export_16x16.gif"));
        }
        if (this.imgRegistry.get("disableExportImg") == null) {
            this.imgRegistry.put("disableExportImg", Activator.getImageDescriptor("icons/disableExport_16x16.gif"));
        }
        if (this.imgRegistry.get("loadFilters") == null) {
            this.imgRegistry.put("loadFilters", Activator.getImageDescriptor("icons/document_import.png"));
        }
        if (this.imgRegistry.get("saveFilters") == null) {
            this.imgRegistry.put("saveFilters", Activator.getImageDescriptor("icons/document_export.png"));
        }
        if (this.imgRegistry.get("ann_overlay") == null) {
            this.imgRegistry.put("ann_overlay", Activator.getImageDescriptor("icons/ann_overlay.gif"));
        }
    }

    private void buildTabSummary() {
        UsageStateAdapter state = this.descriptor.getState();
        FilterData filterData = (FilterData)state.getData().get("FilterData");
        String fullSummaryForToolTip = "";
        if (filterData != null) {
            List prjList = (List)state.getData().get("PROJECT_LIST");
            String shortenedSummary = filterData.createShortenedSummary(this.descriptor.isEnableLimits(), 100, prjList);
            fullSummaryForToolTip = filterData.createFullSummaryFormatted(this.descriptor.isEnableLimits(), prjList);
            this.tabSummary.setText(shortenedSummary);
            this.tabSummary.setToolTipText(fullSummaryForToolTip);
        } else {
            this.tabSummary.setText("");
        }
        this.tabSummary.getParent().layout();
        if (this.manager != null) {
            ((BrowserManager)this.manager).getCurrentEntryInfo().getTabItem().setTooltip(fullSummaryForToolTip);
        }
    }

    public void markTabSummary(boolean addMark) {
        if (this.tabSummary == null || this.tabSummary.getToolTipText() == null) {
            return;
        }
        String fullSummaryForToolTip = this.tabSummary.getToolTipText();
        String shortenedSummary = this.tabSummary.getText();
        if (addMark) {
            if (!shortenedSummary.startsWith("*")) {
                shortenedSummary = "*".concat(shortenedSummary);
                fullSummaryForToolTip = "*".concat(fullSummaryForToolTip);
            }
        } else if (shortenedSummary.startsWith("*")) {
            shortenedSummary = shortenedSummary.substring(1);
            fullSummaryForToolTip = fullSummaryForToolTip.substring(1);
        }
        this.tabSummary.setText(shortenedSummary);
        this.tabSummary.setToolTipText(fullSummaryForToolTip);
        this.tabSummary.getParent().layout();
    }

    public IActionManager getManager() {
        return this.manager;
    }

    public UsageDescriptorAdapter getDescriptor() {
        return this.descriptor;
    }

    public ImageRegistry getImageRegistry() {
        return this.imgRegistry;
    }

    public void close() {
        this.resultsTreeViewer.getTree().dispose();
        this.spinnerController.close();
        this.filterCtrl.close();
        this.unsetAnnotationsContext();
    }

    private void copyFromTreeToClipboard() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        ISelection sel = this.resultsTreeViewer.getSelection();
        ResultElement resultElement = (ResultElement)((Object)((IStructuredSelection)sel).getFirstElement());
        if (resultElement != null) {
            cb.setContents(new Object[]{resultElement.getDisplayName()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void updateFromAnn(ResultElement[] elements) {
        this.resultsTreeViewer.update((Object[])elements, null);
        this.spinnerController.doUpdate();
    }

    private class ToolbarAccessibleAdapter
    extends AccessibleAdapter {
        private ToolbarAccessibleAdapter() {
        }

        public void getName(AccessibleEvent e) {
            switch (e.childID) {
                case 0: {
                    e.result = UsageViewer.this.descriptor.hasReorderResultsAction() ? UsageViewer.this.orderItem.getToolTipText() : UsageViewer.this.expandAllItem.getToolTipText();
                    break;
                }
                case 1: {
                    e.result = UsageViewer.this.descriptor.hasReorderResultsAction() ? UsageViewer.this.expandAllItem.getToolTipText() : UsageViewer.this.collapseAllItem.getToolTipText();
                    break;
                }
                case 2: {
                    e.result = UsageViewer.this.descriptor.hasReorderResultsAction() ? UsageViewer.this.collapseAllItem.getToolTipText() : UsageViewer.this.exportResultsItem.getToolTipText();
                    break;
                }
                case 3: {
                    e.result = UsageViewer.this.descriptor.hasReorderResultsAction() ? UsageViewer.this.exportResultsItem.getToolTipText() : "";
                    break;
                }
            }
            L.debug("getName for toolbar {}: {}", (Object)(e.childID == -1 ? "itself" : "button with id " + e.childID), (Object)e.result);
        }
    }
}

