/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.ui.AbstractFilterSettingsDialog;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.analysis.mainframe.utils.StmtFilters;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtState;
import com.ez.mainframe.model.StmtType;
import com.ez.report.application.ui.StmtTreeObject;
import com.ez.report.application.ui.StmtTreeViewContentProvider;
import com.ez.report.application.ui.StmtTreeViewLabelProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmtSettingsDialog
extends AbstractFilterSettingsDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(StmtSettingsDialog.class);
    private TreeViewer lstGroups;
    private StmtTreeObject root = null;
    private Table tblValues;
    private Map<String, StmtGroup> groups;
    private List<StmtGroup> allGroupsList;
    private List<ProjectInfo> prjs;
    private Set<StmtType> stmtTypeUnchecked = new HashSet<StmtType>();
    private static final String no_operators_err = Messages.getString(StmtSettingsDialog.class, "empty.operators.list.message");
    private String stmtString;
    private StmtFilters filter;

    public StmtSettingsDialog(List<ProjectInfo> prjs, StmtFilters filter, Shell shell) {
        super(shell);
        this.prjs = prjs;
        this.filter = filter;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString(StmtSettingsDialog.class, "dialog.title"));
    }

    @Override
    protected void createPage(Composite page) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        page.setLayoutData((Object)data);
        this.createWeightsTab(page);
        this.update();
    }

    @Override
    protected void update() {
        L.debug("before fillUI");
        this.fillUI();
        L.debug("after fillUI");
    }

    private Control createWeightsTab(Composite parent) {
        Composite myParent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 8;
        myParent.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        myParent.setLayoutData((Object)data);
        Text lblGroups = new Text(myParent, 8);
        lblGroups.setText(Messages.getString(StmtSettingsDialog.class, "label.stmtTypes.groups"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lblGroups.setLayoutData((Object)data);
        Label lblValues = new Label(myParent, 0);
        lblValues.setText(Messages.getString(StmtSettingsDialog.class, "label.stmtStates"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lblValues.setLayoutData((Object)data);
        this.createGroupsList(myParent, lblGroups);
        this.createTableValues(myParent, lblValues);
        this.createGroupSetValue(myParent);
        return myParent;
    }

    private void createGroupsList(Composite parent, final Text lblGroups) {
        this.lstGroups = new TreeViewer(parent, 68356);
        this.lstGroups.setContentProvider((IContentProvider)new StmtTreeViewContentProvider());
        this.lstGroups.setLabelProvider((IBaseLabelProvider)new StmtTreeViewLabelProvider());
        Accessible accessibleTbl = this.lstGroups.getTree().getAccessible();
        accessibleTbl.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = lblGroups.getText();
                }
                L.trace("statementTypes.getDescription={} for {}", (Object)event.result, (Object)event.childID);
            }

            public void getName(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = lblGroups.getText();
                }
                L.trace("statementTypes.getName={} for {}", (Object)event.result, (Object)event.childID);
            }
        });
        GridData data = new GridData();
        data.verticalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.lstGroups.getControl().setLayoutData((Object)data);
        this.lstGroups.addSelectionChangedListener((ISelectionChangedListener)new GroupSelectionListener());
    }

    private void createTableValues(Composite parent, Label caption) {
        this.tblValues = new Table(parent, 68128);
        GridData data = new GridData();
        data.heightHint = 100;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.tblValues.setLayoutData((Object)data);
        this.tblValues.addListener(13, (Listener)new StmtSelectionListener());
        TableColumn tc1 = new TableColumn(this.tblValues, 16384);
        tc1.setWidth(400);
        this.tblValues.setHeaderVisible(true);
        this.tblValues.setLinesVisible(true);
    }

    private void createGroupSetValue(Composite parent) {
        Group groupSetVal = new Group(parent, 0);
        groupSetVal.setText(Messages.getString(StmtSettingsDialog.class, "label.setValue.group"));
        GridLayout lay = new GridLayout(4, true);
        lay.marginBottom = 5;
        lay.marginLeft = 5;
        lay.marginRight = 5;
        lay.marginTop = 5;
        groupSetVal.setLayout((Layout)lay);
        GridData data = new GridData();
        data.horizontalAlignment = 131072;
        data.grabExcessHorizontalSpace = true;
        groupSetVal.setLayoutData((Object)data);
        SelectionAdapter selectAllListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StmtSettingsDialog.this.checkAll();
            }
        };
        SelectionAdapter deselectAllListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StmtGroup allGroup;
                TableItem[] items;
                TableItem[] tableItemArray = items = StmtSettingsDialog.this.tblValues.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ti = tableItemArray[n2];
                    ti.setChecked(false);
                    StmtType type = (StmtType)ti.getData();
                    StmtState obj = type.getState();
                    obj.setValue(Boolean.FALSE.toString());
                    ti.setData((Object)type);
                    StmtSettingsDialog.this.stmtTypeUnchecked.add(type);
                    ++n2;
                }
                StmtSettingsDialog.this.tblValues.update();
                StmtGroup stmtGroup = allGroup = StmtSettingsDialog.this.allGroupsList != null ? (StmtGroup)StmtSettingsDialog.this.allGroupsList.get(0) : null;
                if (allGroup != null && allGroup.getTypes().size() == StmtSettingsDialog.this.stmtTypeUnchecked.size()) {
                    StmtSettingsDialog.this.setErrorMessage(no_operators_err);
                }
                StmtSettingsDialog.this.checkHasErrors();
            }
        };
        Button btnSelectAll = new Button((Composite)groupSetVal, 1032);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 1;
        btnSelectAll.setLayoutData((Object)data);
        btnSelectAll.setText(Messages.getString(StmtSettingsDialog.class, "selall.button.text"));
        btnSelectAll.addSelectionListener((SelectionListener)selectAllListener);
        Button btnDeselectAll = new Button((Composite)groupSetVal, 1032);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 1;
        btnDeselectAll.setLayoutData((Object)data);
        btnDeselectAll.setText(Messages.getString(StmtSettingsDialog.class, "deselall.button.text"));
        btnDeselectAll.addSelectionListener((SelectionListener)deselectAllListener);
    }

    private void checkAll() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.tblValues.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            ti.setChecked(true);
            StmtType type = (StmtType)ti.getData();
            StmtState obj = type.getState();
            obj.setValue(Boolean.TRUE.toString());
            ti.setData((Object)type);
            this.stmtTypeUnchecked.remove(type);
            ++n2;
        }
        this.tblValues.update();
        this.checkHasErrors();
    }

    private boolean checkHasErrors() {
        boolean err = false;
        if (this.allGroupsList != null && this.allGroupsList.get(0).getTypes().size() == this.stmtTypeUnchecked.size()) {
            err = true;
        }
        if (err) {
            this.setErrorMessage(no_operators_err);
        } else {
            this.removeErrorMessage(no_operators_err);
        }
        this.getButton(0).setEnabled(!err);
        return err;
    }

    private void fillUI() {
        Shell shell = this.display.getActiveShell();
        if (shell != null) {
            shell.setCursor(this.waitCursor);
        }
        L.debug("fillUI call to fillList()");
        this.fillList();
        L.debug("list was filled");
        this.fillTable();
        L.debug("table was filled");
        if (shell != null) {
            shell.setCursor(this.defCursor);
        }
    }

    private void fillTable() {
        StmtGroup allGroup;
        int selGroupsCount = this.lstGroups.getTree().getSelectionCount();
        if (selGroupsCount > 0) {
            TreeItem gTreeItem = this.lstGroups.getTree().getSelection()[0];
            String name = ((StmtTreeObject)gTreeItem.getData()).getStmtId();
            StmtGroup currentGroup = this.groups.get(name);
            this.tblValues.removeAll();
            TreeSet types = new TreeSet(currentGroup.getTypes());
            for (StmtType type : types) {
                TableItem ti = new TableItem(this.tblValues, 32);
                if (this.stmtTypeUnchecked.contains(type)) {
                    ti.setChecked(false);
                } else {
                    ti.setChecked(true);
                }
                ti.setText(type.getName());
                ti.setData((Object)type);
            }
        }
        StmtGroup stmtGroup = allGroup = this.allGroupsList != null ? this.allGroupsList.get(0) : null;
        if (allGroup != null) {
            for (StmtType type : allGroup.getTypes()) {
                String value = type.getState().getValue();
                if (!value.equalsIgnoreCase(Boolean.FALSE.toString())) continue;
                this.stmtTypeUnchecked.add(type);
            }
        }
    }

    private void loadStatements() {
        Map stmtTypes = Utils.readStmtTypes();
        Map<Object, Object> allStmtTypes = new HashMap();
        allStmtTypes = stmtTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<String> selectedStmts = new ArrayList<String>();
        if (this.stmtString != null && !this.stmtString.isEmpty()) {
            String[] stmts;
            String[] stringArray = stmts = this.stmtString.split(",");
            int n = stmts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                selectedStmts.add(s.trim());
                ++n2;
            }
        }
        this.allGroupsList = Utils.getStmtGroups(allStmtTypes, StmtFilters.getParents(this.filter), StmtFilters.getChildren(this.filter));
        if (this.groups == null) {
            this.groups = new HashMap<String, StmtGroup>();
        }
        this.root = StmtTreeViewContentProvider.createStmtTreeModel(this.prjs, this.allGroupsList, this.groups);
        Set currentGroupStmts = this.allGroupsList.get(0).getTypes();
        for (StmtType type : currentGroupStmts) {
            StmtState state = type.getState();
            if (state == null) {
                state = new StmtState(type);
                type.setState(state);
            }
            state.setDefValue(Boolean.TRUE.toString());
            if (selectedStmts.contains(StmtDialogTextCellEditor.DEFAULT_ALLSTMT) || selectedStmts.contains(type.getName())) {
                state.setValue(Boolean.TRUE.toString());
                this.stmtTypeUnchecked.remove(type);
                continue;
            }
            state.setValue(Boolean.FALSE.toString());
            this.stmtTypeUnchecked.add(type);
        }
        this.lstGroups.refresh();
        this.lstGroups.setSelection(this.lstGroups.getSelection());
    }

    private void fillList() {
        this.loadStatements();
        this.lstGroups.setInput((Object)this.root);
        this.lstGroups.refresh();
        this.lstGroups.expandAll();
        TreeItem ti = this.lstGroups.getTree().getItem(0);
        this.lstGroups.getTree().setSelection(ti);
    }

    protected boolean allChecked() {
        return this.stmtTypeUnchecked.isEmpty();
    }

    protected boolean noneChecked() {
        return this.allGroupsList.get(0).getTypes().size() == this.stmtTypeUnchecked.size();
    }

    protected Set<StmtType> getCheckedStmts() {
        HashSet<StmtType> checkedStmts = new HashSet<StmtType>(this.allGroupsList.get(0).getTypes());
        checkedStmts.removeAll(this.stmtTypeUnchecked);
        return checkedStmts;
    }

    public void setStmtStates(String stmtString) {
        this.stmtString = stmtString;
    }

    private class GroupSelectionListener
    implements ISelectionChangedListener {
        private GroupSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            StmtSettingsDialog.this.fillTable();
        }
    }

    private class StmtSelectionListener
    implements Listener {
        private StmtSelectionListener() {
        }

        public void handleEvent(Event e) {
            if (e.detail == 32) {
                TableItem item = (TableItem)e.item;
                StmtType type = (StmtType)item.getData();
                if (item.getChecked()) {
                    StmtSettingsDialog.this.stmtTypeUnchecked.remove(type);
                    StmtSettingsDialog.this.removeErrorMessage(no_operators_err);
                } else {
                    StmtSettingsDialog.this.stmtTypeUnchecked.add(type);
                    if (StmtSettingsDialog.this.checkHasErrors()) {
                        StmtSettingsDialog.this.setErrorMessage(no_operators_err);
                    }
                }
                type.getState().setValue(String.valueOf((Object)item.getChecked()));
            }
        }
    }
}

