/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.ui.FilterEditingSupport;
import com.ez.analysis.mainframe.usage.ui.StmtSettingsDialog;
import com.ez.analysis.mainframe.utils.StmtFilters;
import com.ez.mainframe.model.StmtType;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StmtDialogTextCellEditor
extends TextCellEditor {
    public static String DEFAULT_ALLSTMT = Messages.getString(StmtDialogTextCellEditor.class, "filter.label.allchkd");
    private FilterEntry entry;
    private UsageDescriptorAdapter descriptor;
    private FilterEditingSupport filterEditingSupport;

    public StmtDialogTextCellEditor(UsageDescriptorAdapter descriptor, FilterEntry entry, TextCellEditor textCellEditor, FilterEditingSupport filterEditingSupport) {
        super(textCellEditor.getControl().getParent());
        this.entry = entry;
        this.descriptor = descriptor;
        this.filterEditingSupport = filterEditingSupport;
    }

    protected Control createControl(final Composite parent) {
        this.text = new Text(parent, this.getStyle());
        this.text.setFont(parent.getFont());
        this.text.setBackground(parent.getBackground());
        this.text.setText(DEFAULT_ALLSTMT);
        this.text.setEditable(false);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object newValue = StmtDialogTextCellEditor.this.openDialogBox((Control)parent);
                if (newValue != null) {
                    boolean newValidState = StmtDialogTextCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        StmtDialogTextCellEditor.this.markDirty();
                        StmtDialogTextCellEditor.this.setValue(newValue);
                        StmtDialogTextCellEditor.this.filterEditingSupport.setValue(StmtDialogTextCellEditor.this.entry, newValue);
                        StmtDialogTextCellEditor.this.filterEditingSupport.getViewer().refresh();
                    } else {
                        StmtDialogTextCellEditor.this.setErrorMessage(MessageFormat.format(StmtDialogTextCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                }
            }
        });
        return this.text;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        String stmtString = super.doGetValue().toString();
        StmtSettingsDialog dialog = this.initDialog(cellEditorWindow.getShell());
        dialog.setStmtStates(stmtString);
        int retCode = dialog.open();
        if (retCode == 1) {
            return null;
        }
        String ret = DEFAULT_ALLSTMT;
        if (!dialog.allChecked() && !dialog.noneChecked()) {
            Set<StmtType> checkedStmts = dialog.getCheckedStmts();
            ret = checkedStmts.stream().map(stmt -> stmt.getName()).collect(Collectors.joining(", "));
        }
        this.entry.put("value from a dialog of a text", ret);
        int i = this.entry.getPropertyIndex(FilterEntry.ATTR_FILTER);
        this.entry.put(FilterEntry.ATTR_FILTER, this.entry.getValidValue(i, ret));
        return ret;
    }

    private StmtSettingsDialog initDialog(Shell shell) {
        Map<String, Object> data = this.descriptor.getState().getData();
        List prjList = (List)data.get("PROJECT_LIST");
        StmtFilters filterName = StmtFilters.getFilterByDescriptor(this.descriptor.getAnalysisType().getId());
        return new StmtSettingsDialog(prjList, filterName, shell);
    }
}

