/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.annotations.UsagesAnnotationPartStateManager;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.common.ui.guielements.EZSpinner;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotatedResultsLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinnerController {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SpinnerController.class);
    private EZSpinner spinner;
    private Label lblFilter;
    private Text txtFilter;
    private List<ResultElement> filteredBySpinner = new ArrayList<ResultElement>();
    private int spinnerSelection;
    private TreeViewer treeViewer;
    private ImageRegistry imgRegistry;
    private boolean considerAnnotations = false;
    private Button annBtn;
    private UsagesAnnotationPartStateManager annManager;

    public SpinnerController(Composite parent, ImageRegistry imgRegistry, boolean considerAnnotations) {
        this.imgRegistry = imgRegistry;
        this.considerAnnotations = considerAnnotations;
        this.buildSpinner(parent);
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    private void buildSpinner(Composite filterComp) {
        Label lblImg = new Label(filterComp, 0);
        Image searchImg = this.imgRegistry.get("searchImg");
        lblImg.setImage(searchImg);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)15);
        lblImg.setLayoutData((Object)gd);
        this.txtFilter = new Text(filterComp, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txtFilter.setLayoutData((Object)gd);
        this.addTextFilterListeners();
        if (this.considerAnnotations) {
            this.annBtn = new Button(filterComp, 2);
            Image annImg = this.imgRegistry.get("ann_overlay");
            this.annBtn.setImage(annImg);
            this.annBtn.setToolTipText(Messages.getString(SpinnerController.class, "find.annotated.button"));
            this.annBtn.setLayoutData((Object)new GridData());
            this.addBtnAnnotationsListeners();
        }
        this.spinner = new EZSpinner(filterComp, 0);
        gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)18);
        gd.heightHint = DpiScaler.getScaledSize((int)24);
        this.spinner.setLayoutData((Object)gd);
        this.addSpinnerListeners();
        this.lblFilter = new Label(filterComp, 131072);
        gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)35);
        gd.horizontalAlignment = 0x1000008;
        if (!this.considerAnnotations) {
            gd.horizontalSpan = 2;
        }
        this.lblFilter.setLayoutData((Object)gd);
        if (this.considerAnnotations) {
            filterComp.setTabList(new Control[]{this.txtFilter, this.annBtn, this.spinner, this.lblFilter});
        } else {
            filterComp.setTabList(new Control[]{this.txtFilter, this.spinner, this.lblFilter});
        }
    }

    private void addTextFilterListeners() {
        this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SpinnerController.this.filterItems();
            }
        });
        this.txtFilter.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SpinnerController.this.getDescriptionMsg(false);
                }
            }

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(SpinnerController.class, "textFilter.name");
            }
        });
    }

    private void addSpinnerListeners() {
        AccessibleAdapter upAccAdapter = new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SpinnerController.this.getDescriptionMsg(true);
                }
            }
        };
        AccessibleAdapter downAdapter = new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SpinnerController.this.getDescriptionMsg(true);
                }
            }
        };
        SelectionAdapter upSelector = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = SpinnerController.this.spinnerSelection - 1;
                SpinnerController.this.makeSpinnerSelection(selection);
                SpinnerController.this.spinner.sendAccessibleEvent(32781, null, 0);
            }
        };
        SelectionAdapter downSelector = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = SpinnerController.this.spinnerSelection + 1;
                SpinnerController.this.makeSpinnerSelection(selection);
                SpinnerController.this.spinner.sendAccessibleEvent(32781, null, 1);
            }
        };
        this.spinner.addSelectionListener((SelectionListener)upSelector, 0);
        this.spinner.addSelectionListener((SelectionListener)downSelector, 1);
        this.spinner.addAccessibleListener((AccessibleListener)upAccAdapter, 0);
        this.spinner.addAccessibleListener((AccessibleListener)downAdapter, 1);
    }

    private void addBtnAnnotationsListeners() {
        this.annBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpinnerController.this.doUpdate();
                SpinnerController.this.annBtn.getAccessible().sendEvent(32781, null);
            }
        });
        this.annBtn.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = SpinnerController.this.annBtn.getToolTipText();
            }

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SpinnerController.this.getDescriptionMsg(false);
                }
            }
        });
    }

    private String getDescriptionMsg(boolean selected) {
        int no = this.spinnerSelection < 0 ? 0 : (this.spinnerSelection == 0 ? 1 : this.spinnerSelection + 1);
        int all = this.filteredBySpinner.size();
        String ret = selected ? Messages.getString(SpinnerController.class, "spinner.buttons.description", new Object[]{no, all}) : Messages.getString(SpinnerController.class, "textFilter.description", new Object[]{no, all});
        return ret;
    }

    private void makeSpinnerSelection(int selection) {
        if (selection > -1 && selection < this.filteredBySpinner.size()) {
            this.lblFilter.setText(String.valueOf(selection + 1) + "/" + this.filteredBySpinner.size());
            ResultElement reToSelect = null;
            if (this.filteredBySpinner.size() > 0) {
                reToSelect = this.filteredBySpinner.get(selection);
            }
            StructuredSelection sel = new StructuredSelection(reToSelect);
            this.treeViewer.setSelection((ISelection)sel, true);
            this.spinnerSelection = selection;
        }
    }

    public void filterItems() {
        String filter = this.txtFilter.getText();
        Assert.isNotNull((Object)this.treeViewer);
        this.treeViewer.getTree().deselectAll();
        this.resetSpinnerFilters();
        if (filter != null && !"".equals(filter)) {
            boolean showOnlyAnnotated = this.considerAnnotations ? this.annBtn.getSelection() : false;
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            Object[] elems = contentProvider.getElements((Object)"root");
            boolean start = false;
            boolean end = false;
            if (filter.startsWith("*")) {
                filter = filter.substring(1);
                start = true;
            } else if (filter.endsWith("*")) {
                filter = filter.substring(0, filter.length() - 1);
                end = true;
            }
            List<ResultElement> results = this.recursiveSearch(contentProvider, filter, elems, start, end, showOnlyAnnotated);
            this.filteredBySpinner.addAll(results);
        }
        if (this.filteredBySpinner.size() > 0) {
            this.spinnerSelection = 0;
            this.makeSpinnerSelection(this.spinnerSelection);
            this.txtFilter.setForeground(Display.getCurrent().getSystemColor(24));
        } else {
            this.resetSpinnerFilters();
            this.txtFilter.setForeground(Display.getCurrent().getSystemColor(3));
            this.spinnerSelection = -1;
        }
        this.txtFilter.getAccessible().sendEvent(32781, null);
    }

    private List<ResultElement> recursiveSearch(ITreeContentProvider contentProvider, String toSearch, Object[] elems, boolean start, boolean end, boolean showOnlyAnnotated) {
        ArrayList<ResultElement> results = new ArrayList<ResultElement>();
        AnnotatedResultsLabelProvider labelProvider = (AnnotatedResultsLabelProvider)this.treeViewer.getLabelProvider();
        int i = 0;
        while (i < elems.length) {
            Object[] children;
            String value;
            ResultElement re = (ResultElement)((Object)elems[i]);
            boolean addIt = this.filter(re, showOnlyAnnotated);
            if (addIt && this.matchSearch(toSearch, value = labelProvider.getText((AbstractResultElement)re), start, end)) {
                results.add(re);
            }
            if ((children = contentProvider.getChildren((Object)re)) != null && children.length > 0) {
                results.addAll(this.recursiveSearch(contentProvider, toSearch, children, start, end, showOnlyAnnotated));
            }
            ++i;
        }
        return results;
    }

    private boolean filter(ResultElement re, boolean showOnlyAnnotated) {
        boolean add = true;
        if (showOnlyAnnotated) {
            Boolean acceptAnn = (Boolean)re.getProperty("acceptAnn");
            if (acceptAnn == null || !acceptAnn.booleanValue()) {
                add = false;
            } else {
                Boolean ann = (Boolean)re.getProperty("annotation");
                if (ann == null) {
                    L.warn("ann not yet calculated for {} ?! ", (Object)re);
                    ann = this.annManager.hasAnn(re);
                }
                if (ann == null || !ann.booleanValue()) {
                    add = false;
                }
            }
        }
        return add;
    }

    private boolean matchSearch(String toSearch, String value, boolean start, boolean end) {
        String elementUpper = value.toUpperCase();
        String searchUpper = toSearch.toUpperCase();
        boolean match = false;
        match = start ? elementUpper.endsWith(searchUpper) : (end ? elementUpper.startsWith(searchUpper) : elementUpper.contains(searchUpper));
        return match;
    }

    private void resetSpinnerFilters() {
        this.filteredBySpinner.clear();
        this.lblFilter.setText(String.valueOf(this.spinnerSelection < 0 ? 0 : this.spinnerSelection) + "/" + this.filteredBySpinner.size());
    }

    public void close() {
        this.annManager = null;
        this.treeViewer.getTree().dispose();
        this.spinner.dispose();
    }

    public void setAnnManager(UsagesAnnotationPartStateManager annStateManager) {
        this.annManager = annStateManager;
    }

    public void doUpdate() {
        this.spinnerSelection = -1;
        this.filterItems();
    }
}

