/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.ElementActionWithJob;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected List<ResultElementType> elementTypes = null;
    public static final String LEVELS_ORDER = "LEVELS_ORDER";
    protected UsageDescriptorAdapter descriptor;

    public abstract void buildResultsTree(ResultElement var1, RecordsetProvider var2, IProgressMonitor var3);

    protected List<ResultElementType> getLevelsOrder() {
        return this.elementTypes;
    }

    public void setLevelsOrder(List<ResultElementType> elementTypes) {
        this.elementTypes = elementTypes;
        this.descriptor.getState().getData().put(LEVELS_ORDER, elementTypes);
    }

    protected abstract boolean isTreeLevelOrderSameAsFiltersOrder();

    protected boolean defaultIsTreeLevelOrderSameAsFiltersOrder() {
        boolean sameOrder = true;
        FilterData filterData = (FilterData)this.descriptor.getState().getData().get("FilterData");
        List<FilterEntry> fEntries = filterData.getEntries();
        int prjInfoOffset = 0;
        if (this.elementTypes.contains(ResultElementType.PROJECT_INFO)) {
            prjInfoOffset = 1;
        }
        int offset = 0;
        int i = 0;
        while (i < fEntries.size()) {
            FilterEntry filterEntry = fEntries.get(i);
            String filterEntryName = fEntries.get(i).get("filterEntryName");
            if (!filterEntry.isEntryInUse()) {
                ++offset;
            } else if (!filterEntryName.equalsIgnoreCase(this.elementTypes.get(prjInfoOffset + i - offset).name())) {
                sameOrder = false;
                break;
            }
            ++i;
        }
        return sameOrder;
    }

    protected void checkLimitReached(ResultElementType levelElementType, ResultElement root, ResultElement parent) {
        if (this.descriptor.isEnableLimits() && this.isTreeLevelOrderSameAsFiltersOrder()) {
            FilterData filterData = (FilterData)this.descriptor.getState().getData().get("FilterData");
            List<FilterEntry> fEntries = filterData.getEntries();
            FilterEntry filterEntry = null;
            int filterLimit = -1;
            int i = 0;
            while (i < fEntries.size()) {
                filterEntry = fEntries.get(i);
                String filterEntryName = filterEntry.get("filterEntryName");
                if (filterEntryName.equalsIgnoreCase(levelElementType.name())) {
                    if (!filterEntry.isEntryInUse() || !filterEntry.canModify(3) || filterEntry.getValidAttribute(3) == null) break;
                    filterLimit = Integer.valueOf(filterEntry.getValidAttribute(3));
                    break;
                }
                ++i;
            }
            if (filterLimit > 0) {
                Set<ResultElementType> levelsWithCategories;
                int childrenCount = 0;
                ResultElement parentForLimitFlag = parent;
                if (parent.getType() != null && parent.getType().isCategory()) {
                    parentForLimitFlag = parent.getParent() != null ? parent.getParent() : root;
                }
                if ((childrenCount = (levelsWithCategories = this.getLevelsWithCategoriesAndLimit()) != null && levelsWithCategories.contains(levelElementType) ? this.countChildrenForLevelsWithCategories(parentForLimitFlag, levelElementType).intValue() : parent.getChildren().size()) >= filterLimit) {
                    String levelDisplayName = levelElementType.getDisplayName();
                    String limitReachedText = Messages.getString(ResultsTreeProvider.class, "limit.reached.element.text", new String[]{levelDisplayName});
                    ResultElement limitReachedChild = new ResultElement(limitReachedText, ResultElementType.LIMIT_REACHED, parentForLimitFlag);
                    parentForLimitFlag.addChild(levelElementType + ResultElementType.LIMIT_REACHED.getDisplayName(), limitReachedChild);
                }
            }
        }
    }

    protected Integer countChildrenForLevelsWithCategories(ResultElement parentForLimitFlag, ResultElementType levelElementType) {
        Integer count = 0;
        for (AbstractResultElement categoryElement : parentForLimitFlag.getChildren().values()) {
            Iterator iterator;
            if (categoryElement.getChildren() == null || categoryElement.getType().equals((Object)ResultElementType.LIMIT_REACHED) || !(iterator = categoryElement.getChildren().values().iterator()).hasNext() || !levelElementType.equals((Object)((AbstractResultElement)iterator.next()).getType())) continue;
            count = count + categoryElement.getChildren().size();
        }
        return count;
    }

    protected abstract Set<ResultElementType> getLevelsWithCategoriesAndLimit();

    public List<ElementActionWithJob> contributeToContextMenu(ResultElement resultElem) {
        return null;
    }

    public ElementActionWithJob contributeToDoubleClick(ResultElement resultElem) {
        return null;
    }
}

