/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.Activator;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import com.ibm.ez.analysis.api.model.ApiTargetType;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultsLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResultsLabelProvider.class);
    protected ImageRegistry registry;

    public ResultsLabelProvider(ImageRegistry registry) {
        this.registry = registry;
    }

    public String getText(Object element) {
        String txt = ((ResultElement)((Object)element)).getDisplayName();
        if (txt == null) {
            L.warn("element without displayName: {}", element);
            txt = "";
        }
        return txt;
    }

    public String getToolTipText(Object element) {
        String elemStr;
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        String ret = null;
        String string = elemStr = re == null ? "" : re.getDisplayName();
        if (type == null) {
            ret = "";
        } else {
            ret = type.getDisplayName();
            if (type.isCategory()) {
                if (!ret.isEmpty()) {
                    String categoryText = Messages.getString(ResultsLabelProvider.class, "tooltip.category.text");
                    ret = String.valueOf(ret) + " " + categoryText;
                } else {
                    L.warn("category type without displayName: {}", (Object)elemStr);
                    ret = elemStr;
                }
                if (type.equals((Object)ResultElementType.PROGRAM_CATEGORY) || type.equals((Object)ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY)) {
                    ret = String.valueOf(ret) + " - " + elemStr;
                }
            } else {
                ret = ret.isEmpty() ? elemStr : String.valueOf(ret) + " - " + elemStr;
            }
        }
        if (ret.isEmpty()) {
            ret = Messages.getString(ResultsLabelProvider.class, "no.results.tooltip.text");
        }
        return ResultsLabelProvider.escapeText(ret);
    }

    public Image getImage(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        Image img = null;
        if (type != null) {
            Boolean seqType;
            Boolean val;
            if (type.equals((Object)ResultElementType.CATALOG_TARGET)) {
                String tgType = (String)re.getProperty(DatabaseMetadata.CATALOG_TARGET_TYPE.getName());
                if (ApiTargetType.PROGRAM.name().equals(tgType)) {
                    type = ResultElementType.PROGRAM;
                } else if (ApiTargetType.IMS_TRANSACTION.name().equals(tgType)) {
                    type = ResultElementType.IMS_TRANSACTION;
                }
            }
            String reTypeString = type.name();
            if (type.equals((Object)ResultElementType.PROGRAM)) {
                reTypeString = ProgramUtils.getProgramTypeAsString(re);
            }
            if (type.equals((Object)ResultElementType.PROGRAM_CATEGORY)) {
                reTypeString = re.getName();
            }
            if (type.equals((Object)ResultElementType.COBOL_OR_DDCL)) {
                Integer programTypeId = (Integer)re.getProperty("Program Type Id");
                reTypeString = programTypeId != null && 1 == programTypeId ? ProgramUtils.getProgramTypeAsString(programTypeId) : ResultElementType.DDCL_ELEMENT.name();
            }
            if (reTypeString.equals(ResultElementType.VARIABLE.name())) {
                boolean isInclude = (Boolean)re.getProperty("VarIsInclude");
                reTypeString = String.valueOf(ResultElementType.VARIABLE.name()) + "_" + re.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()) + (isInclude ? "_Include" : "_Program");
            }
            if (reTypeString.equals(ResultElementType.STMT_SOURCE_INFO.name()) && (val = Boolean.valueOf(re.getProperty("Logical segment name") != null && !((String)re.getProperty("Logical segment name")).isEmpty())).booleanValue()) {
                reTypeString = ResultElementType.STMT_SOURCE_INFO.name().concat("_IMSDB_LogicalOccurence");
            }
            if ((reTypeString.equals(ResultElementType.IMSDB_FIELD.name()) || reTypeString.equals(ResultElementType.IMSDB_SEARCH_FIELD.name())) && (seqType = Boolean.valueOf(!Utils.null2empty(re.getProperty(DatabaseMetadata.IMSDB_FIELD_SEQ.getName())).isEmpty())).booleanValue()) {
                reTypeString = ResultElementType.IMSDB_FIELD.name().concat("_seq");
            }
            if ((img = this.registry.get(reTypeString)) == null && (img = this.createImage(re)) != null) {
                this.registry.put(reTypeString, img);
            }
        }
        return img;
    }

    protected Image createImage(ResultElement element) {
        Image ret = null;
        switch (element.getType()) {
            case PROGRAM: 
            case PROGRAM_CATEGORY: {
                ret = this.getImageByPrgTypeId(element);
                break;
            }
            case DDCL_ELEMENT_TYPE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/ddcl/elementgroup.png").createImage();
                break;
            }
            case COBOL_OR_DDCL: {
                Integer programTypeId = (Integer)element.getProperty("Program Type Id");
                if (programTypeId != null && programTypeId == 1) {
                    ret = this.getImageByPrgTypeId(element);
                    break;
                }
                ret = Activator.getImageDescriptor("icons/ddcl/element.png").createImage();
                break;
            }
            case DDCL_ELEMENT_NAME: 
            case DDCL_ELEMENT: 
            case DDCL_ELEMENT_FILE_NAME: {
                ret = Activator.getImageDescriptor("icons/ddcl/element.png").createImage();
                break;
            }
            case DDCL_PROPERTY_NAME: {
                ret = Activator.getImageDescriptor("icons/ddcl/elementproperty.png").createImage();
                break;
            }
            case LOAD_MODULE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/loadmodules.png").createImage();
                break;
            }
            case UTILITY_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/utilities.png").createImage();
                break;
            }
            case ASSEMBLER_CSECT: 
            case ASSEMBLER_ENTRY: {
                ret = Activator.getImageDescriptor("icons/assembler.png").createImage();
                break;
            }
            case ASSEMBLER_CSECT_CATEGORY: 
            case ASSEMBLER_ENTRY_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/assembler.png").createImage();
                break;
            }
            case SQL_TABLE: {
                ret = Activator.getImageDescriptor("icons/SQLTable.png").createImage();
                break;
            }
            case DATACOM: {
                ret = Activator.getImageDescriptor("icons/datacom.png").createImage();
                break;
            }
            case SQL_FIELD_TABLE: {
                ret = Activator.getImageDescriptor("icons/SQLTableField.png").createImage();
                break;
            }
            case IMSDB_TERMINAL: {
                ret = Activator.getImageDescriptor("icons/imsdb_terminal.png").createImage();
                break;
            }
            case IMSDB_DATABASE: {
                ret = Activator.getImageDescriptor("icons/imsdb_database.png").createImage();
                break;
            }
            case IMSDB_TERMINAL_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsdb_terminal_group.png").createImage();
                break;
            }
            case IMSDB_DATABASE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsdb_database_group.png").createImage();
                break;
            }
            case TPMSX: {
                ret = Activator.getImageDescriptor("icons/tpmsx.png").createImage();
                break;
            }
            case IDMS_RECORD_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/idmsRecord.png").createImage();
                break;
            }
            case IDMS_SET_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/idmsSet.png").createImage();
                break;
            }
            case IDMS_SCHEMA: 
            case IDMSX_SCHEMA: {
                ret = Activator.getImageDescriptor("icons/idmsSchema.png").createImage();
                break;
            }
            case IDMS_SUBSCHEMA: 
            case IDMSX_SUBSCHEMA: {
                ret = Activator.getImageDescriptor("icons/idmsSubschema.png").createImage();
                break;
            }
            case IDMS_SET: {
                ret = Activator.getImageDescriptor("icons/idmsSet.png").createImage();
                break;
            }
            case IDMS_RECORD: {
                ret = Activator.getImageDescriptor("icons/idmsRecord.png").createImage();
                break;
            }
            case IDMS_FUNCTION: {
                ret = Activator.getImageDescriptor("icons/function.png").createImage();
                break;
            }
            case TPMSX_STMT_TYPE: {
                ret = Activator.getImageDescriptor("icons/TPMSX_Call.png").createImage();
                break;
            }
            case STMT_TYPE: 
            case STMT_READ_WRITE_CATEGORY: 
            case IDCAMS_AMS_STMT: 
            case IDCAMS_AMS_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/stmt.png").createImage();
                break;
            }
            case STMT_SOURCE_INFO: 
            case DDCL_PROPERTY_SOURCE_INFO: {
                Boolean val = element.getProperty("Logical segment name") != null && !((String)element.getProperty("Logical segment name")).isEmpty();
                if (val.booleanValue()) {
                    ret = Activator.getImageDescriptor("icons/occurenceLineForIMSDBLogic16.gif").createImage();
                    break;
                }
                ret = Activator.getImageDescriptor("icons/line.png").createImage();
                break;
            }
            case PROJECT_INFO: {
                ProjectInfo pi = (ProjectInfo)element.getProperty("ProjectInfo");
                ret = pi.getDescriptor().createImage();
                break;
            }
            case VARIABLE_SECTION_TYPE: {
                ret = Activator.getImageDescriptor("icons/variablesection.png").createImage();
                break;
            }
            case VARIABLE: {
                if (element.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(1)) {
                    boolean isInclude = (Boolean)element.getProperty("VarIsInclude");
                    if (isInclude) {
                        ret = Activator.getImageDescriptor("icons/cobolVariableInInclude.png").createImage();
                        break;
                    }
                    ret = Activator.getImageDescriptor("icons/cobolVariable.png").createImage();
                    break;
                }
                if (element.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(3)) {
                    boolean isInclude = (Boolean)element.getProperty("VarIsInclude");
                    if (isInclude) {
                        ret = Activator.getImageDescriptor("icons/naturalVariableInInclude.png").createImage();
                        break;
                    }
                    ret = Activator.getImageDescriptor("icons/naturalVariable.png").createImage();
                    break;
                }
                if (element.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(2)) {
                    boolean isInclude = (Boolean)element.getProperty("VarIsInclude");
                    if (isInclude) {
                        ret = Activator.getImageDescriptor("icons/Pl1VariableInInclude.png").createImage();
                        break;
                    }
                    ret = Activator.getImageDescriptor("icons/Pl1Variable.png").createImage();
                    break;
                }
                if (!element.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(8)) break;
                boolean isInclude = (Boolean)element.getProperty("VarIsInclude");
                if (isInclude) {
                    ret = Activator.getImageDescriptor("icons/assemblerVariableInInclude.png").createImage();
                    break;
                }
                ret = Activator.getImageDescriptor("icons/assemblerVariable.png").createImage();
                break;
            }
            case DSECT_SUBCATEGORY: 
            case LOCAL_SUBCATEGORY: {
                ret = Activator.getImageDescriptor("icons/assemblerVariable.png").createImage();
                break;
            }
            case PARAMETER: 
            case SCL_VARIABLE: 
            case SCL_VARIABLE_CATEGORY: 
            case PARAMETER_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/variableinprogram.png").createImage();
                break;
            }
            case INCLUDE: 
            case INCLUDE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/include.png").createImage();
                break;
            }
            case PARAGRAPH: 
            case PROCEDURE: 
            case SUBROUTINE: 
            case PARAGRAPH_CATEGORY: 
            case SUBROUTINE_CATEGORY: 
            case PROCEDURE_CATEGORY: 
            case SCL_PROC_SYNONYM: 
            case SCL_PROC_SYNONYM_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/paragraph.png").createImage();
                break;
            }
            case MACRO: 
            case MACRO_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/macro.png").createImage();
                break;
            }
            case DDNAME: 
            case DDNAME_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/ddname1_16x16.png").createImage();
                break;
            }
            case FILE: 
            case DATASET: {
                ret = Activator.getImageDescriptor("icons/dataset2_16x16.png").createImage();
                break;
            }
            case LOGICAL_NAME: {
                ret = Activator.getImageDescriptor("icons/logicalname_16x16.png").createImage();
                break;
            }
            case JCL_JOB: {
                ret = Activator.getImageDescriptor("icons/job.png").createImage();
                break;
            }
            case JCL_PROCEDURE: {
                ret = Activator.getImageDescriptor("icons/proc.png").createImage();
                break;
            }
            case LIMIT_REACHED: {
                ret = Activator.getImageDescriptor("icons/warn_16x16.png").createImage();
                break;
            }
            case JCL_STEP: {
                ret = Activator.getImageDescriptor("icons/step.png").createImage();
                break;
            }
            case PGM_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/pgms.png").createImage();
                break;
            }
            case JCL_PROCEDURE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/procs.png").createImage();
                break;
            }
            case INVOKEDBY_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/invoke_jobs.png").createImage();
                break;
            }
            case STEP_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/steps.png").createImage();
                break;
            }
            case DATASET_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/datasets.png").createImage();
                break;
            }
            case DS_MEMBER_NAME: {
                ret = Activator.getImageDescriptor("icons/membername.png").createImage();
                break;
            }
            case SCL_PROCEDURE: {
                ret = Activator.getImageDescriptor("icons/scl_program.png").createImage();
                break;
            }
            case MQ_MANAGER: {
                ret = Activator.getImageDescriptor("icons/queue_manager.png").createImage();
                break;
            }
            case MQ_QUEUE: {
                ret = Activator.getImageDescriptor("icons/queue.png").createImage();
                break;
            }
            case ADABAS_DB: {
                ret = Activator.getImageDescriptor("icons/adabasDB.png").createImage();
                break;
            }
            case ADABAS_FILE: {
                ret = Activator.getImageDescriptor("icons/adabas_table.png").createImage();
                break;
            }
            case ADABAS_VIEW: {
                ret = Activator.getImageDescriptor("icons/adabas_view.png").createImage();
                break;
            }
            case DAL: {
                ret = Activator.getImageDescriptor("icons/dal_16X16.png").createImage();
                break;
            }
            case DBI_TABLE: {
                ret = Activator.getImageDescriptor("icons/dbi_16.png").createImage();
                break;
            }
            case IMSDB_LOGICAL: {
                ret = Activator.getImageDescriptor("icons/imsDB3.png").createImage();
                break;
            }
            case IMSDB_LOGICAL_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB3.png").createImage();
                break;
            }
            case IMSDB_FAST_PATH: 
            case IMSDB_FAST_PATH_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB1.png").createImage();
                break;
            }
            case IMSDB_FILE_ACCESS: 
            case IMSDB_FILE_ACCESS_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB4.png").createImage();
                break;
            }
            case IMSDB_FULL_FUNCTION: 
            case IMSDB_FULL_FUNCTION_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB2.png").createImage();
                break;
            }
            case IMSDB_NOT_AVAILABLE: 
            case IMSDB_NOT_AVAILABLE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB5.png").createImage();
                break;
            }
            case IMSDB_SEGMENT: 
            case IMSDB_LOGICAL_SEGMENT: {
                ret = Activator.getImageDescriptor("icons/RecordFormatMetaData161.gif").createImage();
                break;
            }
            case IMSDB_FIELD: 
            case IMSDB_SEARCH_FIELD: {
                String seqType = Utils.null2empty(element.getProperty(DatabaseMetadata.IMSDB_FIELD_SEQ.getName()));
                if (seqType.isEmpty()) {
                    ret = Activator.getImageDescriptor("icons/XSDField.gif").createImage();
                    break;
                }
                ret = Activator.getImageDescriptor("icons/XSDFieldSeq.gif").createImage();
                break;
            }
            case CATALOG_API: {
                ret = Activator.getImageDescriptor("icons/api16x16.png").createImage();
                break;
            }
            case CATALOG_SERVICE: {
                ret = Activator.getImageDescriptor("icons/ServicesSmall.png").createImage();
                break;
            }
            case CATALOG_TARGET: {
                String tgType = (String)element.getProperty(DatabaseMetadata.CATALOG_TARGET_TYPE.getName());
                if (ApiTargetType.PROGRAM.name().equals(tgType)) {
                    ret = this.getImageByPrgTypeId(element);
                    break;
                }
                if (!ApiTargetType.IMS_TRANSACTION.name().equals(tgType)) break;
                ret = Activator.getImageDescriptor("icons/terTrans2.png").createImage();
            }
        }
        return ret;
    }

    protected Image getImageByPrgTypeId(ResultElement element) {
        Image ret;
        Integer programTypeId = (Integer)element.getProperty("Program Type Id");
        switch (programTypeId) {
            case 1: {
                ret = Activator.getImageDescriptor("icons/cobol.png").createImage();
                break;
            }
            case 2: {
                ret = Activator.getImageDescriptor("icons/Pl1.png").createImage();
                break;
            }
            case 3: {
                ret = Activator.getImageDescriptor("icons/natural.png").createImage();
                break;
            }
            case 8: {
                ret = Activator.getImageDescriptor("icons/assembler.png").createImage();
                break;
            }
            case 15: {
                ret = Activator.getImageDescriptor("icons/assembler.png").createImage();
                break;
            }
            case 16: {
                ret = Activator.getImageDescriptor("icons/assembler.png").createImage();
                break;
            }
            case 10: {
                ret = Activator.getImageDescriptor("icons/adsProcess.png").createImage();
                break;
            }
            case -2: {
                ret = Activator.getImageDescriptor("icons/loadmodule.png").createImage();
                break;
            }
            case -3: {
                ret = Activator.getImageDescriptor("icons/utility.png").createImage();
                break;
            }
            case 13: 
            case 19: {
                ret = Activator.getImageDescriptor("icons/scl_program.png").createImage();
                break;
            }
            case -1: {
                ret = Activator.getImageDescriptor("icons/cobol.png").createImage();
                break;
            }
            default: {
                ret = Activator.getImageDescriptor("icons/unknown.png").createImage();
            }
        }
        return ret;
    }

    protected static String escapeText(String text) {
        if (text.contains("&")) {
            text = text.replaceAll("&", "&&");
        }
        return text;
    }

    public void dispose() {
        this.registry = null;
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }
}

