/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.cobol.callgraph.nodes.StatementDataNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class ResultElementSelectionListener
implements ISelectionChangedListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final IActionManager manager;
    private AbstractActionDescriptor descriptor;

    public ResultElementSelectionListener(AbstractActionDescriptor descriptor, IActionManager manager) {
        this.manager = manager;
        this.descriptor = descriptor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection structSelection = (StructuredSelection)event.getSelection();
        final List resultElementList = structSelection.toList();
        final ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        for (ResultElement resultElement : resultElementList) {
            List projectList = (List)resultElement.getProperty("ProjectInfo List");
            if (projectList != null) {
                for (ProjectInfo pi : projectList) {
                    EZObjectType inputType = Utils.createApplicableInputType(resultElement, pi);
                    inputs.add(inputType);
                }
                continue;
            }
            inputs.add(null);
        }
        if (!inputs.isEmpty()) {
            final Object prjs = this.descriptor.getState().getData().get("projects");
            AbstractActionContext context = new AbstractActionContext(){

                public Map<String, Object> getData() {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("projects", prjs);
                    data.put("ANALYSIS_TYPE_INPUTS", inputs);
                    ResultElement resultElement = (ResultElement)((Object)resultElementList.get(0));
                    ISelection sel = ResultElementSelectionListener.this.getSelection4PropertiesView(resultElement);
                    if (sel != null) {
                        data.put("selection", sel);
                        data.put("unique identifier of the property sheet page contributor", ResultElementSelectionListener.this.getContributorIdForProperties(resultElement));
                    }
                    data.put("sourceView", new Pair((Object)"com.ez.analysisbrowser.views.UsagesView", (Object)((BrowserManager)ResultElementSelectionListener.this.manager).getViewSecondaryId()));
                    return data;
                }

                public String getId() {
                    return ResultElementSelectionListener.this.descriptor.getId();
                }
            };
            this.descriptor.getState().getData().put("selectedContext", context);
            this.manager.setCurrentContext((IActionContext)context);
        }
    }

    private ISelection getSelection4PropertiesView(ResultElement resultElement) {
        StructuredSelection sel = null;
        if (resultElement.getProperty("Node_Mainframe") != null) {
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg(resultElement.getProperty("Node_Mainframe"));
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            sel = new StructuredSelection((Object)entID);
        } else if (ResultElementType.PROJECT_INFO.equals((Object)resultElement.getType())) {
            ProjectInfo pi = (ProjectInfo)resultElement.getProperty("ProjectInfo");
            sel = new StructuredSelection((Object)pi);
        } else if (resultElement.getProperty("Application_Master_Node") != null) {
            EZEntityID id = new EZEntityID();
            id.addSegment((EZSegment)new EZSourceMainframeNodeIdSg(resultElement.getProperty("Application_Master_Node")));
            sel = new StructuredSelection((Object)id);
        } else if (ResultElementType.STMT_SOURCE_INFO.equals((Object)resultElement.getType())) {
            if (resultElement.getProperty("Stmt DBI Access") != null) {
                EZEntityID id = new EZEntityID();
                String name = (String)resultElement.getProperty("Stmt DBI Access");
                id.addSegment((EZSegment)new EZSourceMainframeNodeIdSg((Object)new StatementDataNode(name)));
                sel = new StructuredSelection((Object)id);
            }
        } else if (resultElement.getProperty("element of IMS/DB") != null) {
            boolean field_na;
            boolean bl = field_na = resultElement.getType().equals((Object)ResultElementType.IMSDB_SEARCH_FIELD) && resultElement.getName().equalsIgnoreCase("N/A");
            if (!field_na) {
                if (resultElement.getProperty("Node_Mainframe") == null) {
                    Utils.collectProperties4UsageResultTree(resultElement);
                }
                EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg(resultElement.getProperty("Node_Mainframe"));
                EZEntityID entID = new EZEntityID();
                entID.addSegment((EZSegment)sg);
                sel = new StructuredSelection((Object)entID);
            }
        }
        if (sel == null) {
            sel = new StructuredSelection();
        }
        return sel;
    }

    private String getContributorIdForProperties(ResultElement resultElement) {
        if (ResultElementType.PROJECT_INFO.equals((Object)resultElement.getType())) {
            return "ezresource.contributor";
        }
        return "ezselection.contributor";
    }
}

