/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.ResultsLabelProvider;
import com.ez.mainframe.data.results.ResultElementType;
import org.eclipse.jface.resource.ImageRegistry;

public class JobWithMemberLabelProvider
extends ResultsLabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public JobWithMemberLabelProvider(ImageRegistry registry) {
        super(registry);
    }

    @Override
    public String getToolTipText(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        String tooltip = null;
        if (ResultElementType.JCL_JOB.equals((Object)type)) {
            tooltip = String.valueOf(type.getDisplayName()) + " - ";
            String memberName = (String)re.getProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName());
            String jobName = (String)re.getProperty(DatabaseMetadata.JOB_NAME.getName());
            tooltip = tooltip.concat(jobName);
            tooltip = memberName != null && !memberName.isEmpty() && !memberName.equalsIgnoreCase(jobName) ? String.valueOf(tooltip) + "(" + memberName + ")" : tooltip;
        } else {
            tooltip = super.getToolTipText(element);
        }
        return tooltip;
    }

    @Override
    public String getText(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        String text = null;
        if (ResultElementType.JCL_JOB.equals((Object)type)) {
            String memberName = (String)re.getProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName());
            text = (String)re.getProperty(DatabaseMetadata.JOB_NAME.getName());
            text = memberName != null && !memberName.isEmpty() && !memberName.equalsIgnoreCase(text) ? String.valueOf(text) + "(" + memberName + ")" : text;
        } else {
            text = super.getText(element);
        }
        return text;
    }
}

