/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class InputListener
implements ModifyListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Widget toggleWidget;
    private Map<Widget, String> userInput = new HashMap<Widget, String>();
    private Color normalBkg;
    private Color normalFg;

    public InputListener() {
        Display d = Display.getCurrent();
        this.normalBkg = d.getSystemColor(1);
        this.normalFg = d.getSystemColor(21);
    }

    public void setToggleWidget(Widget toggleWidget) {
        this.toggleWidget = toggleWidget;
        this.toggle(false);
    }

    public void modifyText(ModifyEvent event) {
        Widget w = event.widget;
        if (w != null) {
            if (w instanceof Text) {
                Text t = (Text)w;
                this.userInput.put(w, t.getText());
            }
            this.inputChanged(w);
        }
        this.toggle(true);
    }

    public void inputChanged(Widget w) {
    }

    public void resetWidget(Widget w) {
        if (w instanceof Text) {
            Text t = (Text)w;
            t.setBackground(this.normalBkg);
            t.setForeground(this.normalFg);
        }
    }

    public String getUserInput(Widget w) {
        return this.userInput.get(w);
    }

    public void resetModifiedWidgets() {
        for (Widget w : this.userInput.keySet()) {
            this.resetWidget(w);
        }
        this.toggle(false);
    }

    public void toggle(boolean enable) {
        if (this.toggleWidget != null && this.toggleWidget instanceof Button) {
            ((Button)this.toggleWidget).setEnabled(enable);
        }
    }
}

