/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.mu.utils.ServerUtils;
import com.ez.workspace.mu.client.Utils;
import com.ez.workspace.utils.FileDataStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FiltersLoadDialog
extends Dialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String USAGE_FOLDER = "usage";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final String PROPERTIES_SEPARATOR = "<F>";
    protected static final String NAMES_PROP_KEY = "names";
    protected static final String FILTER_PROP_KEY = "filter";
    private static final int DIALOG_MIN_HEIGHT = 400;
    private static final int DIALOG_MIN_WIDTH = 300;
    private String title;
    protected Properties value;
    protected FileDataStore filtersDataStore;
    protected Text text;
    private Combo combo;
    private List filtersList;
    protected String filterPropertiesKey;
    private String propertiesFileName;

    public FiltersLoadDialog(Shell parentShell, String propertiesFileName) {
        super(parentShell);
        String dialogTitle;
        this.title = dialogTitle = Messages.getString(((Object)((Object)this)).getClass(), "dialog.title");
        this.propertiesFileName = propertiesFileName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label serverOptionLabel = new Label(composite, 0);
        serverOptionLabel.setText(Messages.getString(FiltersLoadDialog.class, "select.destination.lbl"));
        this.combo = new Combo(composite, 12);
        GridData data = new GridData(768);
        data.verticalAlignment = 128;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.combo.setLayoutData((Object)data);
        int i = 1;
        this.combo.add(Messages.getString(FiltersLoadDialog.class, "local.folder"));
        this.combo.select(0);
        Map servers = Utils.getServerPorts();
        for (String serverIP : servers.keySet()) {
            Integer port = (Integer)servers.get(serverIP);
            this.combo.add("Server: " + serverIP + " Port: " + port);
            this.combo.setData("Server" + i, (Object)serverIP);
            this.combo.setData("Port" + i, (Object)port);
            ++i;
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = FiltersLoadDialog.this.combo.getSelectionIndex();
                FiltersLoadDialog.this.createFileDataStore(idx);
                if (FiltersLoadDialog.this.filtersList.getItems().length > 0 && FiltersLoadDialog.this.filtersList.getMenu() == null) {
                    FiltersLoadDialog.this.addFiltersListMenu();
                } else if (FiltersLoadDialog.this.filtersList.getItems().length == 0 && FiltersLoadDialog.this.filtersList.getMenu() != null) {
                    FiltersLoadDialog.this.filtersList.setMenu(null);
                }
            }
        });
        this.createUpComposite(composite);
        Label label = new Label(composite, 0);
        label.setText(this.getListLabelText());
        this.filtersList = new List(composite, 2564);
        data = new GridData(768);
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.minimumHeight = 60;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.filtersList.setLayoutData((Object)data);
        this.filtersList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FiltersLoadDialog.this.enableOkBtn((TypedEvent)e);
            }
        });
        this.filtersList.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                FiltersLoadDialog.this.enableOkBtn((TypedEvent)e);
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return composite;
    }

    private void enableOkBtn(TypedEvent e) {
        List list = (List)e.getSource();
        String[] selection = list.getSelection();
        if (this.text != null && selection.length > 0) {
            this.text.setText(selection[0]);
        }
        this.getButton(0).setEnabled(this.verifyOK() || this.filtersDataStore != null && this.text == null && selection.length > 0);
    }

    private void addFiltersListMenu() {
        Menu menu = new Menu((Control)this.filtersList);
        this.filtersList.setMenu(menu);
        MenuItem deleteItem = new MenuItem(menu, 8);
        deleteItem.setText(this.getMenuItemText());
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FiltersLoadDialog.this.filtersList.getItems().length > 0) {
                    String filterName;
                    int item = FiltersLoadDialog.this.filtersList.getSelectionIndex();
                    if (item >= 0 && !(filterName = FiltersLoadDialog.this.filtersList.getItem(item)).isEmpty()) {
                        String allNamesStr = FiltersLoadDialog.this.filtersDataStore.getProperty(FiltersLoadDialog.FILTER_PROP_KEY, FiltersLoadDialog.NAMES_PROP_KEY);
                        if (allNamesStr.contains(filterName)) {
                            if (allNamesStr.equals(filterName)) {
                                FiltersLoadDialog.this.filtersDataStore.removeProperties(FiltersLoadDialog.FILTER_PROP_KEY, FiltersLoadDialog.NAMES_PROP_KEY);
                            } else if (allNamesStr.startsWith(filterName)) {
                                allNamesStr = allNamesStr.replace(filterName.concat(FiltersLoadDialog.PROPERTIES_SEPARATOR), "");
                                FiltersLoadDialog.this.filtersDataStore.setProperty(FiltersLoadDialog.FILTER_PROP_KEY, FiltersLoadDialog.NAMES_PROP_KEY, allNamesStr);
                            } else {
                                allNamesStr = allNamesStr.replace(FiltersLoadDialog.PROPERTIES_SEPARATOR.concat(filterName), "");
                                FiltersLoadDialog.this.filtersDataStore.setProperty(FiltersLoadDialog.FILTER_PROP_KEY, FiltersLoadDialog.NAMES_PROP_KEY, allNamesStr);
                            }
                        }
                        FiltersLoadDialog.this.filterPropertiesKey = "filter." + filterName;
                        FiltersLoadDialog.this.filtersDataStore.removeProperties(FiltersLoadDialog.this.filterPropertiesKey, "");
                        FiltersLoadDialog.this.filtersList.remove(FiltersLoadDialog.this.filtersList.getSelectionIndex());
                        if (FiltersLoadDialog.this.filtersList.getItems().length == 0) {
                            FiltersLoadDialog.this.filtersList.setMenu(null);
                        }
                        if (FiltersLoadDialog.this.text != null) {
                            FiltersLoadDialog.this.text.setText("");
                        }
                        FiltersLoadDialog.this.getButton(0).setEnabled(FiltersLoadDialog.this.verifyOK());
                    }
                } else {
                    FiltersLoadDialog.this.filtersList.setMenu(null);
                }
            }
        });
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.createFileDataStore(0);
        if (this.filtersList.getItems().length > 0) {
            this.addFiltersListMenu();
        }
        return control;
    }

    private void createFileDataStore(int idx) {
        Map serverWorkspaceInfoMap;
        String serverIP = (String)this.combo.getData("Server" + idx);
        Integer port = (Integer)this.combo.getData("Port" + idx);
        boolean pathIsRelative = true;
        String path = USAGE_FOLDER + FILE_SEPARATOR + this.propertiesFileName;
        if (serverIP != null && port != null && (serverWorkspaceInfoMap = ServerUtils.getServerWorkspace((String)serverIP, (int)port, null)) != null) {
            String pathPrefix = (String)serverWorkspaceInfoMap.get("server workspace key");
            StringBuilder sb = new StringBuilder(pathPrefix);
            sb.append(FILE_SEPARATOR);
            sb.append(".ez");
            sb.append(FILE_SEPARATOR);
            sb.append(USAGE_FOLDER);
            sb.append(FILE_SEPARATOR);
            sb.append(this.propertiesFileName);
            path = sb.toString();
            pathIsRelative = false;
        }
        this.filtersDataStore = FileDataStore.getDataStore((String)path, (boolean)pathIsRelative);
        this.filtersDataStore.setComments("filters for usage action");
        String allNamesStr = this.filtersDataStore.getProperty(FILTER_PROP_KEY, NAMES_PROP_KEY);
        String[] filterNames = null;
        this.filtersList.removeAll();
        this.getButton(0).setEnabled(this.verifyOK());
        if (allNamesStr != null) {
            filterNames = allNamesStr.split(PROPERTIES_SEPARATOR);
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = filterNames;
            int n = filterNames.length;
            int n2 = 0;
            while (n2 < n) {
                String filterName = stringArray[n2];
                list.add(filterName);
                ++n2;
            }
            Collections.sort(list);
            this.filtersList.setItems(list.toArray(new String[0]));
        }
    }

    protected String getListLabelText() {
        return Messages.getString(((Object)((Object)this)).getClass(), "filters.list.label");
    }

    protected String getMenuItemText() {
        return Messages.getString(((Object)((Object)this)).getClass(), "delete.item.label");
    }

    protected void createUpComposite(Composite composite) {
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.verifyOK());
        return c;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String filterName = "";
            filterName = this.text != null ? this.text.getText() : this.filtersList.getSelection()[0];
            this.filterPropertiesKey = "filter." + filterName;
            this.value = this.filtersDataStore.getProperties(this.filterPropertiesKey);
            this.beforeOKPressed();
        } else {
            this.value = null;
            this.filterPropertiesKey = null;
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        shell.setMinimumSize(300, 400);
    }

    public Properties getProperties() {
        return this.value;
    }

    public FileDataStore getFiltersDataStore() {
        return this.filtersDataStore;
    }

    protected void beforeOKPressed() {
    }

    protected boolean verifyOK() {
        return this.filtersDataStore != null && this.text != null && !this.text.getText().isEmpty();
    }
}

