/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.ui.FilterController;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterModifier
implements ICellModifier {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FilterModifier.class);
    private FilterController controller;
    private FilterData filterData;
    private TableViewer viewer;

    public FilterModifier(FilterController controller, TableViewer viewer, FilterData filterData) {
        this.viewer = viewer;
        this.controller = controller;
        this.filterData = filterData;
    }

    public boolean canModify(Object element, String property) {
        FilterEntry e = (FilterEntry)element;
        boolean canModify = e.canModify(property);
        return canModify;
    }

    public Object getValue(Object element, String property) {
        FilterEntry e = (FilterEntry)element;
        int i = e.getPropertyIndex(property);
        String r = "";
        if (i >= 0 && (r = e.getValidAttribute(i)) == null) {
            r = "";
        }
        return r;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof FilterEntry) {
            this.modifyEntry((FilterEntry)element, property, value);
        } else {
            TableItem item = (TableItem)element;
            if (item != null) {
                String entryName = item.getText(this.filterData.isCanSkipFilterEntry() ? 1 : 0);
                for (FilterEntry e : this.filterData.getEntries()) {
                    if (!entryName.equals(e.get(FilterEntry.ENTRY_ATTRIBUTES[1]))) continue;
                    this.modifyEntry(e, property, value);
                    break;
                }
                this.viewer.refresh();
            }
        }
    }

    private void modifyEntry(FilterEntry element, String property, Object value) {
        int i = element.getPropertyIndex(property);
        if (i >= 0) {
            if (element.isComboEntry()) {
                Map<String, String> inputMap = this.controller.getFilterTypesAsMap();
                if (inputMap != null) {
                    String val = null;
                    for (String key : inputMap.keySet()) {
                        if (!inputMap.get(key).equalsIgnoreCase(value.toString())) continue;
                        val = key;
                        break;
                    }
                    element.put("value from combo", val);
                } else {
                    element.put("value from combo", value.toString());
                }
            } else if (element.isDialogTextEntry() && property.equalsIgnoreCase(FilterEntry.ATTR_FILTER)) {
                element.put("value from a dialog of a text", value.toString());
            }
            String validValue = element.getValidValue(i, value.toString());
            try {
                if (property.equalsIgnoreCase(FilterEntry.ATTR_LIMIT) && !validValue.equalsIgnoreCase(value.toString()) && Integer.valueOf(value.toString()) != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"", (String)Messages.getString(FilterModifier.class, "limit.reached.msg"));
                        }
                    });
                }
            }
            catch (NumberFormatException ex) {
                L.error("Limit introduced by user is not a valid entry", (Throwable)ex);
            }
            element.put(property, element.getValidValue(i, value.toString()));
            this.controller.enableFilterAction();
        }
        this.viewer.refresh();
    }
}

