/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterLabelProvider
implements ITableLabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FilterLabelProvider.class);
    public static final String IN_CONTEXT_PREFFIX_KEY = "incontext_prefix";
    public static final String IN_CONTEXT_WHEN_FIRST_KEY = "in context value when is first used entry";
    protected List<FilterEntry> entries;
    private boolean canSkipFilterEntry = false;

    public FilterLabelProvider(boolean canSkipFilterEntry) {
        this.canSkipFilterEntry = canSkipFilterEntry;
    }

    public String getColumnText(Object element, int columnIndex) {
        int start;
        FilterEntry e = (FilterEntry)element;
        String[] attrNames = FilterEntry.ENTRY_ATTRIBUTES;
        String res = "";
        int n = start = this.canSkipFilterEntry ? 0 : 1;
        if (this.canSkipFilterEntry && columnIndex == 0) {
            res = "";
        } else if (columnIndex + start < attrNames.length) {
            if (e.canModify(columnIndex + start)) {
                res = e.getValidAttribute(columnIndex + start);
            }
        } else if (e.isEntryInUse() && this.entries != null) {
            if (!e.get("incontext").isEmpty()) {
                res = e.get("incontext");
            } else {
                int i = this.entries.indexOf(e);
                int j = i - 1;
                GroupFilterEntry groupFilterEntry = e.getGroupFilterEntry();
                while (j >= 0 && groupFilterEntry != null && groupFilterEntry.equals(this.entries.get(j).getGroupFilterEntry())) {
                    --j;
                }
                while (j >= 0) {
                    FilterEntry context = this.entries.get(j);
                    if (context.isEntryInUse()) break;
                    --j;
                }
                if (j < 0 && !e.get(IN_CONTEXT_WHEN_FIRST_KEY).isEmpty()) {
                    res = e.get(IN_CONTEXT_WHEN_FIRST_KEY);
                } else {
                    String usageType = Messages.getString(FilterLabelProvider.class, "usageType.per");
                    if (!e.get(IN_CONTEXT_PREFFIX_KEY).isEmpty()) {
                        usageType = e.get(IN_CONTEXT_PREFFIX_KEY);
                    }
                    if (j >= 0) {
                        int k = 0;
                        String[] resTypes = new String[this.entries.size()];
                        GroupFilterEntry parentGroupFilterEntry = this.entries.get(j).getGroupFilterEntry();
                        do {
                            if (!this.entries.get(j).isEntryInUse()) continue;
                            resTypes[k] = this.entries.get(j).get(FilterEntry.ENTRY_ATTRIBUTES[1]).toLowerCase();
                            ++k;
                        } while (--j >= 0 && parentGroupFilterEntry != null && parentGroupFilterEntry.equals(this.entries.get(j).getGroupFilterEntry()));
                        switch (k) {
                            case 1: {
                                res = Messages.getString(FilterLabelProvider.class, "context.oneresource.label", new String[]{usageType, resTypes[0]});
                                break;
                            }
                            case 2: {
                                res = Messages.getString(FilterLabelProvider.class, "context.tworesources.label", new String[]{usageType, resTypes[0], resTypes[1]});
                                break;
                            }
                            case 3: {
                                res = Messages.getString(FilterLabelProvider.class, "context.threeresources.label", new String[]{usageType, resTypes[0], resTypes[1], resTypes[2]});
                                break;
                            }
                            default: {
                                L.warn("different number of resource types in filter: {}! only first three will appear", (Object)resTypes.length);
                                res = Messages.getString(FilterLabelProvider.class, "context.threeresources.label", new String[]{usageType, resTypes[0], resTypes[1], resTypes[2]});
                                break;
                            }
                        }
                    } else {
                        res = Messages.getString(FilterLabelProvider.class, "context.project.label", new String[]{usageType});
                    }
                }
            }
        }
        return res;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public void setEntries(List<FilterEntry> entries) {
        this.entries = entries;
    }
}

