/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.ui.FilterContentProvider;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public final class FilterEditingSupport
extends EditingSupport {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ComboBoxViewerCellEditor comboCellEditor = null;
    private TextCellEditor textCellEditor = null;
    private StmtDialogTextCellEditor dialogTextCellEditor = null;
    private UsageDescriptorAdapter descriptor = null;

    public FilterEditingSupport(ColumnViewer viewer, UsageDescriptorAdapter descriptor, TextCellEditor textCellEditor) {
        super(viewer);
        this.descriptor = descriptor;
        this.textCellEditor = textCellEditor;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element != null && element instanceof FilterEntry) {
            FilterEntry entry = (FilterEntry)element;
            if (entry.isComboEntry()) {
                if (this.comboCellEditor == null) {
                    this.comboCellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
                    this.comboCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                    this.comboCellEditor.setContenProvider((IStructuredContentProvider)new FilterContentProvider());
                    Object input = this.descriptor.getState().getData().get("all types that restrict the search");
                    this.comboCellEditor.setInput(input);
                }
                return this.comboCellEditor;
            }
            if (entry.isDialogTextEntry()) {
                if (this.dialogTextCellEditor == null) {
                    this.dialogTextCellEditor = new StmtDialogTextCellEditor(this.descriptor, entry, this.textCellEditor, this);
                }
                return this.dialogTextCellEditor;
            }
        }
        return this.textCellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof FilterEntry) {
            FilterEntry entry = (FilterEntry)element;
            if (entry.isComboEntry()) {
                return this.comboCellEditor.getValue();
            }
            if (entry.isDialogTextEntry()) {
                Object ret = entry.getDialogTextValue();
                if (ret == null || ret.toString().isEmpty()) {
                    ret = this.getViewer().getCellModifier().getValue(element, FilterEntry.ATTR_FILTER);
                }
                return ret;
            }
        }
        return this.getViewer().getCellModifier().getValue(element, FilterEntry.ATTR_FILTER);
    }

    protected void setValue(Object element, Object value) {
        if (value == null) {
            return;
        }
        if (element != null && element instanceof FilterEntry) {
            FilterEntry entry = (FilterEntry)element;
            if (entry.isComboEntry()) {
                this.comboCellEditor.setValue(value);
            } else if (entry.isDialogTextEntry()) {
                this.dialogTextCellEditor.setValue(value);
            }
        }
        this.getViewer().getCellModifier().modify(element, FilterEntry.ATTR_FILTER, value);
    }
}

