/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import com.ez.analysis.mainframe.usage.ui.EnableLimitsListener;
import com.ez.analysis.mainframe.usage.ui.FilterButtonListener;
import com.ez.analysis.mainframe.usage.ui.FilterEditingSupport;
import com.ez.analysis.mainframe.usage.ui.FilterLabelProvider;
import com.ez.analysis.mainframe.usage.ui.FilterModifier;
import com.ez.analysis.mainframe.usage.ui.FiltersLoadDialog;
import com.ez.analysis.mainframe.usage.ui.FiltersSaveDialog;
import com.ez.analysis.mainframe.usage.ui.UsageViewer;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.mainframe.gui.ProjectsListWrapper;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.EZAnalysisType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterController {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FilterController.class);
    public static final int MARGIN = 5;
    public static final String FULL_SUMMARY_KEY = "fullSummary";
    public static final String APPLY_BUTTON_STATE_KEY = "ApplyButtonState";
    public static final String ENABLE_LIMITS_BUTTON_STATE_KEY = "EnableLimitsState";
    public static final String RESULTS_TREE_STATE_KEY = "ResultsTree";
    private static final String ENABLE_LIMIT_KEY = "enableLimit";
    private static final String PROJECTS_KEY = "projects";
    private IActionManager manager;
    private UsageDescriptorAdapter descriptor;
    private ImageRegistry reg;
    private Composite panel;
    private UsagesProjectsListWrapper projectList;
    private List<ProjectInfo> prjSelection;
    private TableViewer filterTable;
    private Button moveUp;
    private Button moveDown;
    private Button filterButton;
    private UsageViewer viewer;
    private FilterLabelProvider labelProvider;
    private Map<String, String> filterTypesAsMap;
    private boolean multi = true;
    private boolean showProjects = true;
    private Button enableLimits;
    private boolean disableLimits = false;

    public FilterController(UsageViewer viewer, Composite parent, boolean multi, boolean showProjects, boolean disableLimits) {
        this.viewer = viewer;
        this.panel = parent;
        this.manager = viewer.getManager();
        this.descriptor = viewer.getDescriptor();
        this.reg = viewer.getImageRegistry();
        this.multi = multi;
        this.showProjects = showProjects;
        this.disableLimits = disableLimits;
        this.prjSelection = new ArrayList<ProjectInfo>();
        this.build();
        this.updateProjectList();
        this.storeSelectedProjects();
        this.filterTypesAsMap = (Map)this.descriptor.getState().getData().get("all types that restrict the search");
    }

    public boolean hasMulti() {
        return this.multi;
    }

    private void build() {
        this.panel.setLayout((Layout)new FillLayout());
        Composite master = null;
        Composite leftComposite = null;
        Composite rightComposite = null;
        Composite bottom = null;
        master = new Composite(this.panel, 0);
        master.setLayout((Layout)new FormLayout());
        leftComposite = new Composite(master, 0);
        leftComposite.setLayout((Layout)new FormLayout());
        Group filterGrp = new Group(leftComposite, 0);
        filterGrp.setText(Messages.getString(FilterController.class, "attribute.filters.label"));
        filterGrp.setLayout((Layout)new FormLayout());
        Composite attrArea = new Composite((Composite)filterGrp, 0);
        attrArea.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100, -5);
        attrArea.setLayoutData((Object)fd);
        if (this.descriptor.hasReorderResultsAction()) {
            ReorderListener reorderListener = new ReorderListener();
            this.moveUp = new Button(attrArea, 8);
            this.moveUp.setImage(this.reg.get("arrowUp"));
            this.moveUp.addSelectionListener((SelectionListener)reorderListener);
            this.moveUp.setToolTipText(Messages.getString(FilterController.class, "moveUp.button.tooltip"));
            this.moveUp.getAccessible().addAccessibleListener((AccessibleListener)new ReorderButtonsAccessibilityAdapter());
            fd = new FormData();
            fd.top = new FormAttachment(0, 5);
            fd.left = new FormAttachment(0, 5);
            this.moveUp.setLayoutData((Object)fd);
            this.moveDown = new Button(attrArea, 8);
            this.moveDown.setImage(this.reg.get("arrowDown"));
            this.moveDown.setToolTipText(Messages.getString(FilterController.class, "moveDown.button.tooltip"));
            this.moveDown.getAccessible().addAccessibleListener((AccessibleListener)new ReorderButtonsAccessibilityAdapter());
            this.moveDown.addSelectionListener((SelectionListener)reorderListener);
            FormData fd2 = new FormData();
            fd2.top = new FormAttachment((Control)this.moveUp, 5);
            fd2.left = fd.left;
            this.moveDown.setLayoutData((Object)fd2);
        }
        Composite tableOnlyArea = new Composite(attrArea, 0);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment((Control)this.moveUp, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100);
        tableOnlyArea.setLayoutData((Object)fd);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableOnlyArea.setLayout((Layout)tableColumnLayout);
        int style = 68354;
        boolean use = this.getFilterData().isCanSkipFilterEntry();
        this.filterTable = use ? CheckboxTableViewer.newCheckList((Composite)tableOnlyArea, (int)style) : new TableViewer(tableOnlyArea, style);
        TestListener listener = new TestListener();
        this.filterTable.getTable().addListener(4, (Listener)listener);
        ArrayContentProvider acp = ArrayContentProvider.getInstance();
        this.filterTable.setContentProvider((IContentProvider)acp);
        this.labelProvider = new FilterLabelProvider(use);
        this.setupTable(tableColumnLayout);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment((Control)this.moveUp, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        this.filterTable.getTable().setLayoutData((Object)fd);
        this.filterTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100, -5);
        filterGrp.setLayoutData((Object)fd);
        this.projectList = new UsagesProjectsListWrapper();
        Group projectsGrp = null;
        if (this.showProjects) {
            rightComposite = new Composite(master, 0);
            rightComposite.setLayout((Layout)new FormLayout());
            projectsGrp = new Group(rightComposite, 0);
            projectsGrp.setText(Messages.getString(FilterController.class, "projects.group.txt"));
            projectsGrp.setLayout((Layout)new FormLayout());
            this.projectList.instantiateList((Composite)projectsGrp, 0x800 | (this.hasMulti() ? 2 : 4) | 0x200);
            this.projectList.getList().addSelectionListener((SelectionListener)new ProjectSelectionListener());
            FormData fd2 = new FormData();
            fd2.top = new FormAttachment(0, 5);
            fd2.left = new FormAttachment(0, 5);
            fd2.right = new FormAttachment(100, -5);
            fd2.bottom = new FormAttachment(100, -5);
            this.projectList.getList().setLayoutData((Object)fd2);
            fd = new FormData();
            fd.top = new FormAttachment(0);
            fd.left = new FormAttachment(0);
            fd.right = new FormAttachment(100);
            fd.bottom = new FormAttachment(100, -5);
            projectsGrp.setLayoutData((Object)fd);
        }
        bottom = new Composite(master, 0);
        bottom.setLayout((Layout)new FormLayout());
        this.createBottomActions(bottom);
        fd = new FormData();
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        bottom.setLayoutData((Object)fd);
        if (this.showProjects) {
            fd = new FormData();
            fd.top = new FormAttachment(0);
            fd.left = new FormAttachment(0);
            fd.right = new FormAttachment(70);
            fd.bottom = new FormAttachment((Control)bottom);
            leftComposite.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment(0);
            fd.left = new FormAttachment((Control)leftComposite);
            fd.right = new FormAttachment(100);
            fd.bottom = new FormAttachment((Control)bottom);
            rightComposite.setLayoutData((Object)fd);
        } else {
            fd = new FormData();
            fd.top = new FormAttachment(0);
            fd.left = new FormAttachment(0);
            fd.right = new FormAttachment(100);
            fd.bottom = new FormAttachment((Control)bottom);
            leftComposite.setLayoutData((Object)fd);
        }
        this.fillTable();
        FilterModifier modifier = new FilterModifier(this, this.filterTable, this.getFilterData());
        this.filterTable.setCellModifier((ICellModifier)modifier);
        this.navigateIntoTableStrategy();
        this.panel.setTabList(new Control[]{master});
        master.setTabList(new Control[]{leftComposite, rightComposite, bottom});
        leftComposite.setTabList(new Control[]{filterGrp});
        rightComposite.setTabList(new Control[]{projectsGrp});
    }

    private void navigateIntoTableStrategy() {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.filterTable, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.filterTable));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.filterTable){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.filterTable, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void createBottomActions(Composite parent) {
        Button loadButton = new Button(parent, 8);
        loadButton.setImage(this.reg.get("loadFilters"));
        loadButton.setText(Messages.getString(FilterController.class, "load.filter.button"));
        loadButton.setToolTipText(Messages.getString(FilterController.class, "load.filter.button.tooltip"));
        FormData fd2 = new FormData();
        fd2.left = new FormAttachment(0, 5);
        fd2.bottom = new FormAttachment(100, -5);
        loadButton.setLayoutData((Object)fd2);
        loadButton.addSelectionListener((SelectionListener)new LoadFilterListener());
        Button saveButton = new Button(parent, 8);
        saveButton.setImage(this.reg.get("saveFilters"));
        saveButton.setText(Messages.getString(FilterController.class, "save.filter.button"));
        saveButton.setToolTipText(Messages.getString(FilterController.class, "save.filter.button.tooltip"));
        saveButton.addSelectionListener((SelectionListener)new SaveFilterListener());
        fd2 = new FormData();
        fd2.left = new FormAttachment((Control)loadButton, 5);
        fd2.bottom = new FormAttachment(100, -5);
        saveButton.setLayoutData((Object)fd2);
        if (!this.disableLimits) {
            this.enableLimits = new Button(parent, 32);
            this.enableLimits.setText(Messages.getString(FilterController.class, "enable.limits.button"));
            this.enableLimits.setToolTipText(Messages.getString(FilterController.class, "enable.limits.button.tooltip"));
            this.enableLimits.setSelection(this.descriptor.isEnableLimits());
            this.enableLimits.addMouseListener((MouseListener)new EnableLimitsListener(this));
            fd2 = new FormData();
            fd2.left = new FormAttachment((Control)saveButton, 5);
            fd2.bottom = new FormAttachment(100, -5);
            this.enableLimits.setLayoutData((Object)fd2);
        }
        this.filterButton = new Button(parent, 8);
        this.filterButton.setToolTipText(Messages.getString(FilterController.class, "applyFilters.button.tooltip"));
        this.filterButton.setImage(this.reg.get("reloadImg"));
        this.filterButton.setText(Messages.getString(FilterController.class, "applyFilters.button.text"));
        this.filterButton.addSelectionListener((SelectionListener)new FilterButtonListener(this));
        fd2 = new FormData();
        fd2.top = new FormAttachment(0, 5);
        fd2.right = new FormAttachment(95);
        fd2.bottom = new FormAttachment(100, -5);
        this.filterButton.setLayoutData((Object)fd2);
        if (!this.disableLimits) {
            parent.setTabList(new Control[]{loadButton, saveButton, this.enableLimits, this.filterButton});
        } else {
            parent.setTabList(new Control[]{loadButton, saveButton, this.filterButton});
        }
    }

    private void fillTable() {
        FilterData model = this.getFilterData();
        ArrayList<FilterEntry> l = new ArrayList<FilterEntry>(model.getEntries());
        this.filterTable.setInput(l);
        this.labelProvider.setEntries(l);
        this.filterTable.refresh(true);
    }

    public void enableFilterAction() {
        if (this.filterButton != null && !this.filterButton.isDisposed()) {
            Map<String, Object> data = this.descriptor.getState().getData();
            String currentSummary = (String)data.get(FULL_SUMMARY_KEY);
            String newSummary = this.getFilterData().createFullSummary(this.descriptor.isEnableLimits(), true, this.prjSelection);
            boolean hasValidEntry = true;
            if (this.getFilterData().isCanSkipFilterEntry()) {
                hasValidEntry = false;
                List<FilterEntry> entries = this.getFilterData().getEntries();
                for (FilterEntry fe : entries) {
                    if (!fe.testAtFilterAction(FilterEntry.ATTR_USE) || !fe.isEntryInUse() || !fe.canModify(FilterEntry.ATTR_USE)) continue;
                    hasValidEntry = true;
                    break;
                }
            }
            boolean newValues = currentSummary == null || !currentSummary.equals(newSummary) || this.descriptor.getState().getData().get(RESULTS_TREE_STATE_KEY) != null && (Boolean)this.descriptor.getState().getData().get(RESULTS_TREE_STATE_KEY) != false;
            boolean enabled = newSummary != null && hasValidEntry && newValues && this.prjSelection.size() > 0;
            this.filterButton.setEnabled(hasValidEntry && this.prjSelection.size() > 0);
            data.put(APPLY_BUTTON_STATE_KEY, enabled);
            if (enabled) {
                this.viewer.markTabSummary(true);
                this.filterButton.setText(Messages.getString(FilterController.class, "applyFilters.button.text"));
                this.filterButton.setToolTipText(Messages.getString(FilterController.class, "applyFilters.button.tooltip"));
            } else {
                if (this.prjSelection.size() <= 0 || newSummary == null) {
                    this.viewer.markTabSummary(true);
                } else {
                    this.viewer.markTabSummary(false);
                }
                if (newValues) {
                    this.filterButton.setText(Messages.getString(FilterController.class, "applyFilters.button.text"));
                    this.filterButton.setToolTipText(Messages.getString(FilterController.class, "applyFilters.button.tooltip"));
                } else {
                    this.filterButton.setText(Messages.getString(FilterController.class, "applyFilters.button.text.refresh.mode"));
                    this.filterButton.setToolTipText(Messages.getString(FilterController.class, "applyFilters.button.tooltip.refresh.mode"));
                }
            }
            this.filterButton.getParent().layout();
        }
    }

    private void setupTable(TableColumnLayout tableColumnLayout) {
        TableViewerColumn c;
        Table t = this.filterTable.getTable();
        this.filterTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        t.setHeaderVisible(true);
        int useWidth = 10;
        int width = 100;
        TextCellEditor textCellEditor = new TextCellEditor((Composite)t);
        textCellEditor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TableItem tableItem = FilterController.this.filterTable.getTable().getSelection()[0];
                FilterController.this.updateSelection(tableItem);
            }

            public void applyEditorValue() {
                TableItem tableItem = FilterController.this.filterTable.getTable().getSelection()[0];
                FilterController.this.updateSelection(tableItem);
            }
        });
        String[] colNames = new String[FilterEntry.ENTRY_ATTRIBUTES.length];
        boolean use = this.getFilterData().isCanSkipFilterEntry();
        int start = use ? 0 : 1;
        int columnWidth = width / FilterEntry.ENTRY_ATTRIBUTES.length;
        int i = start;
        while (i < FilterEntry.ENTRY_ATTRIBUTES.length) {
            c = new TableViewerColumn(this.filterTable, 0, i - start);
            c.getColumn().setText(FilterEntry.ENTRY_ATTRIBUTES[i]);
            tableColumnLayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(i == 0 ? useWidth : columnWidth));
            colNames[i - start] = FilterEntry.ENTRY_ATTRIBUTES[i];
            if (FilterEntry.ATTR_FILTER.equals(FilterEntry.ENTRY_ATTRIBUTES[i])) {
                FilterEditingSupport editingSupport = new FilterEditingSupport(c.getViewer(), this.descriptor, textCellEditor);
                c.setEditingSupport((EditingSupport)editingSupport);
            }
            if (FilterEntry.ENTRY_ATTRIBUTES[i].equals(FilterEntry.ATTR_LIMIT)) {
                this.filterTable.setData("LimitColumn", (Object)c.getColumn());
                this.filterTable.setData("LimitColumnWidth", (Object)columnWidth);
                if (!this.descriptor.isEnableLimits()) {
                    ColumnWeightData colWeightData = new ColumnWeightData(0, 0, false);
                    tableColumnLayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)colWeightData);
                }
            }
            ++i;
        }
        c = new TableViewerColumn(this.filterTable, 0, t.getColumnCount());
        c.getColumn().setText(Messages.getString(FilterController.class, "context.column.name"));
        tableColumnLayout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWidth));
        if (this.getFilterData().isCanSkipFilterEntry()) {
            this.filterTable.setColumnProperties(FilterEntry.ENTRY_ATTRIBUTES);
            CellEditor[] cellEditorArray = new CellEditor[4];
            cellEditorArray[2] = textCellEditor;
            cellEditorArray[3] = textCellEditor;
            this.filterTable.setCellEditors(cellEditorArray);
            ((CheckboxTableViewer)this.filterTable).addCheckStateListener((ICheckStateListener)new FilterEntryCheckStateListener());
            ((CheckboxTableViewer)this.filterTable).setCheckStateProvider((ICheckStateProvider)new FilterEntryCheckStateProvider());
        } else {
            this.filterTable.setColumnProperties(colNames);
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[1] = textCellEditor;
            cellEditorArray[2] = textCellEditor;
            this.filterTable.setCellEditors(cellEditorArray);
        }
        this.filterTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FilterController.this.moveUp == null || FilterController.this.moveDown == null) {
                    return;
                }
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                FilterEntry fEntry = (FilterEntry)sel.getFirstElement();
                if (fEntry == null) {
                    return;
                }
                boolean enabled = !Boolean.toString(true).equals(fEntry.get("Fixed.position"));
                int index = FilterController.this.filterTable.getTable().getSelectionIndex();
                FilterEntry next = (FilterEntry)FilterController.this.filterTable.getElementAt(index + 1);
                FilterController.this.moveDown.setEnabled(enabled && next != null && !Boolean.toString(true).equals(next.get("Fixed.position")));
                FilterEntry prev = (FilterEntry)FilterController.this.filterTable.getElementAt(index - 1);
                FilterController.this.moveUp.setEnabled(enabled && prev != null && !Boolean.toString(true).equals(prev.get("Fixed.position")));
            }
        });
    }

    private void updateProjectList() {
        UsageStateAdapter state = this.descriptor.getState();
        List inputProjects = (List)state.getData().get("PROJECT_LIST");
        List allProjects = (List)state.getData().get(PROJECTS_KEY);
        List filteredProjects = Utils.filterProjects((List)allProjects, (EZAnalysisType)this.descriptor.getAnalysisType());
        this.projectList.collectSelection(this.prjSelection);
        this.projectList.fill(filteredProjects, inputProjects);
        this.storeSelectedProjects();
    }

    public void storeSelectedProjects() {
        Map<String, Object> data = this.descriptor.getState().getData();
        data.put("PROJECT_LIST", this.prjSelection);
    }

    public FilterData getFilterData() {
        Map<String, Object> data = this.descriptor.getState().getData();
        FilterData tableFilter = (FilterData)data.get("FilterData");
        return tableFilter;
    }

    public IActionManager getManager() {
        return this.manager;
    }

    public UsageDescriptorAdapter getDescriptor() {
        return this.descriptor;
    }

    private void refreshProjectSelection() {
        this.prjSelection.clear();
        int[] nArray = this.projectList.getList().getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            this.prjSelection.add((ProjectInfo)this.projectList.getList().getData(String.valueOf(index)));
            ++n2;
        }
        this.enableFilterAction();
    }

    public void update() {
        this.getDescriptor().getState().getData().remove("ANALYSIS_TYPE_INPUTS");
        this.viewer.update(null);
    }

    public void close() {
        this.filterTable.getTable().dispose();
        this.labelProvider.dispose();
        this.filterButton = null;
    }

    private void updateSelection(TableItem selectedTableItem) {
        if (selectedTableItem != null) {
            FilterEntry filterEntry = (FilterEntry)selectedTableItem.getData();
            GroupFilterEntry groupFilterEntry = filterEntry.getGroupFilterEntry();
            ArrayList<Object> elements = new ArrayList<Object>();
            if (groupFilterEntry != null) {
                TableItem[] tableItems;
                TableItem[] tableItemArray = tableItems = this.filterTable.getTable().getItems();
                int n = tableItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    FilterEntry tableItemFilterEntry = (FilterEntry)tableItem.getData();
                    if (groupFilterEntry.equals(tableItemFilterEntry.getGroupFilterEntry())) {
                        elements.add(tableItemFilterEntry);
                    }
                    ++n2;
                }
            } else {
                elements.add(selectedTableItem.getData());
            }
            StructuredSelection selection = new StructuredSelection(elements);
            this.filterTable.setSelection((ISelection)selection);
        }
    }

    public Map<String, String> getFilterTypesAsMap() {
        return this.filterTypesAsMap;
    }

    public void updateGuiWhenEnableLimits(Button enableButton) {
        TableColumn limitColumn = (TableColumn)this.filterTable.getData("LimitColumn");
        this.descriptor.setEnableLimits(enableButton.getSelection());
        if (enableButton.getSelection()) {
            int w = this.filterTable.getControl().getSize().x;
            int columnWidth = w / FilterEntry.ENTRY_ATTRIBUTES.length;
            int limitColumnWidth = (Integer)this.filterTable.getData("LimitColumnWidth");
            limitColumnWidth = Math.max(limitColumnWidth, columnWidth);
            limitColumn.setWidth(limitColumnWidth);
            limitColumn.setResizable(true);
        } else {
            this.filterTable.setData("LimitColumnWidth", (Object)limitColumn.getWidth());
            limitColumn.setWidth(0);
            limitColumn.setResizable(false);
        }
        this.filterTable.refresh();
        this.enableFilterAction();
    }

    private static class DataStoreUtility {
        private DataStoreUtility() {
        }

        private static void propToTableElements(Properties properties, List<FilterEntry> tableElements) {
            ArrayList<FilterEntry> newTableElements = new ArrayList<FilterEntry>();
            int i = 0;
            while (i < tableElements.size()) {
                String entry = "ENTRY." + i;
                String attr = FilterEntry.ENTRY_ATTRIBUTES[1];
                String value = properties.getProperty(String.valueOf(entry) + "." + attr);
                int j = 0;
                while (j < tableElements.size()) {
                    FilterEntry currentFE = tableElements.get(j);
                    if (currentFE.get(attr).equals(value)) {
                        L.debug("filter that is loading has on position " + i + " filter entry: " + value);
                        int ii = 0;
                        while (ii < FilterEntry.ENTRY_ATTRIBUTES.length) {
                            attr = FilterEntry.ENTRY_ATTRIBUTES[ii];
                            value = properties.getProperty(String.valueOf(entry) + "." + attr);
                            currentFE.put(attr, value);
                            ++ii;
                        }
                        if (currentFE.isComboEntry()) {
                            String comboVal = properties.getProperty(String.valueOf(entry) + "." + "value from combo");
                            currentFE.put("value from combo", comboVal);
                        }
                        if (currentFE.isDialogTextEntry()) {
                            String val = properties.getProperty(String.valueOf(entry) + "." + "value from a dialog of a text");
                            currentFE.put("value from a dialog of a text", val);
                        }
                        newTableElements.add(i, currentFE);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            tableElements.clear();
            tableElements.addAll(newTableElements);
        }

        private static Properties filterTableElementsToProp(List<FilterEntry> filterTableElements) {
            Properties properties = new Properties();
            int j = 0;
            for (FilterEntry fe : filterTableElements) {
                String entry = "ENTRY." + j;
                int i = 0;
                while (i < FilterEntry.ENTRY_ATTRIBUTES.length) {
                    String attr = FilterEntry.ENTRY_ATTRIBUTES[i];
                    String value = fe.get(FilterEntry.ENTRY_ATTRIBUTES[i]);
                    properties.setProperty(String.valueOf(entry) + "." + attr, value);
                    ++i;
                }
                if (fe.isComboEntry()) {
                    properties.setProperty(String.valueOf(entry) + "." + "value from combo", fe.getComboValue());
                }
                if (fe.isDialogTextEntry()) {
                    properties.setProperty(String.valueOf(entry) + "." + "value from a dialog of a text", fe.getDialogTextValue());
                }
                ++j;
            }
            return properties;
        }
    }

    private class FilterEntryCheckStateListener
    implements ICheckStateListener {
        private FilterEntryCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            FilterEntry fe = (FilterEntry)event.getElement();
            boolean canModify = fe.canModify(FilterEntry.ATTR_USE);
            boolean checked = true;
            if (canModify) {
                checked = event.getChecked();
            }
            fe.put(FilterEntry.ENTRY_ATTRIBUTES[0], Boolean.toString(checked));
            FilterController.this.filterTable.refresh();
            FilterController.this.enableFilterAction();
        }
    }

    private final class FilterEntryCheckStateProvider
    implements ICheckStateProvider {
        private FilterEntryCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            FilterEntry fe = (FilterEntry)element;
            return fe.isEntryInUse();
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    private class LoadFilterListener
    extends SelectionAdapter {
        private LoadFilterListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FiltersLoadDialog dialog = new FiltersLoadDialog(Display.getCurrent().getActiveShell(), FilterController.this.descriptor.getFileName());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Properties properties = dialog.getProperties();
                List<FilterEntry> entries = FilterController.this.getFilterData().getEntries();
                DataStoreUtility.propToTableElements(properties, entries);
                FilterController.this.fillTable();
                String allSelectedProjects = properties.getProperty(FilterController.PROJECTS_KEY);
                if (allSelectedProjects != null) {
                    String[] projects = allSelectedProjects.split("<F>");
                    FilterController.this.projectList.getList().setSelection(projects);
                    FilterController.this.projectList.getList().update();
                    FilterController.this.refreshProjectSelection();
                }
                String enableLimit = properties.getProperty(FilterController.ENABLE_LIMIT_KEY);
                FilterController.this.enableLimits.setSelection(enableLimit == null || "true".equals(enableLimit));
                FilterController.this.updateGuiWhenEnableLimits(FilterController.this.enableLimits);
            }
        }
    }

    class ProjectSelectionListener
    extends SelectionAdapter {
        ProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FilterController.this.refreshProjectSelection();
        }
    }

    private class ReorderButtonsAccessibilityAdapter
    extends AccessibleAdapter {
        private ReorderButtonsAccessibilityAdapter() {
        }

        public void getName(AccessibleEvent e) {
            e.result = ((Button)((Accessible)e.getSource()).getControl()).getToolTipText();
        }
    }

    class ReorderListener
    extends SelectionAdapter {
        ReorderListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] tableItemSelection = FilterController.this.filterTable.getTable().getSelection();
            ArrayList<FilterEntry> filterItemSelection = new ArrayList<FilterEntry>();
            int i = 0;
            while (i < tableItemSelection.length) {
                filterItemSelection.add((FilterEntry)tableItemSelection[i].getData());
                ++i;
            }
            FilterData fd = FilterController.this.getFilterData();
            List<FilterEntry> data = fd.getEntries();
            List treeData = (List)FilterController.this.filterTable.getInput();
            if (e.widget == FilterController.this.moveUp) {
                int index = 0;
                while (index < treeData.size()) {
                    FilterEntry filterEntry = (FilterEntry)treeData.get(index);
                    if (filterItemSelection.contains(filterEntry) && index > 0 && (filterEntry.getGroupFilterEntry() == null || !filterEntry.getGroupFilterEntry().equals(((FilterEntry)treeData.get(index - 1)).getGroupFilterEntry()))) {
                        int newIndex = index;
                        GroupFilterEntry groupFilterEntry = ((FilterEntry)treeData.get(newIndex - 1)).getGroupFilterEntry();
                        while (--newIndex > 0 && groupFilterEntry != null && groupFilterEntry.equals(((FilterEntry)treeData.get(newIndex - 1)).getGroupFilterEntry())) {
                        }
                        FilterEntry moved = data.remove(index);
                        data.add(newIndex, moved);
                        moved = (FilterEntry)treeData.remove(index);
                        treeData.add(newIndex, moved);
                    }
                    ++index;
                }
            } else if (e.widget == FilterController.this.moveDown) {
                int index = treeData.size() - 1;
                while (index >= 0) {
                    FilterEntry filterEntry = (FilterEntry)treeData.get(index);
                    if (filterItemSelection.contains(filterEntry) && index < treeData.size() - 1 && (filterEntry.getGroupFilterEntry() == null || !filterEntry.getGroupFilterEntry().equals(((FilterEntry)treeData.get(index + 1)).getGroupFilterEntry()))) {
                        int newIndex = index;
                        GroupFilterEntry groupFilterEntry = ((FilterEntry)treeData.get(newIndex + 1)).getGroupFilterEntry();
                        while (++newIndex < treeData.size() - 1 && groupFilterEntry != null && groupFilterEntry.equals(((FilterEntry)treeData.get(newIndex + 1)).getGroupFilterEntry())) {
                        }
                        FilterEntry moved = data.remove(index);
                        data.add(newIndex, moved);
                        moved = (FilterEntry)treeData.remove(index);
                        treeData.add(newIndex, moved);
                    }
                    --index;
                }
            }
            FilterController.this.filterTable.refresh();
            FilterController.this.enableFilterAction();
            FilterController.this.filterTable.setSelection(FilterController.this.filterTable.getSelection());
        }
    }

    private class SaveFilterListener
    extends SelectionAdapter {
        private SaveFilterListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FiltersSaveDialog dialog = new FiltersSaveDialog(Display.getCurrent().getActiveShell(), FilterController.this.descriptor.getFileName());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                String[] selectedProjectNames;
                Properties properties = dialog.getProperties();
                List filterTableElements = (List)FilterController.this.filterTable.getInput();
                properties.putAll((Map<?, ?>)DataStoreUtility.filterTableElementsToProp(filterTableElements));
                if (FilterController.this.projectList != null && FilterController.this.projectList.getList() != null && (selectedProjectNames = FilterController.this.projectList.getList().getSelection()) != null) {
                    String projects = "";
                    String[] stringArray = selectedProjectNames;
                    int n = selectedProjectNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String prjName = stringArray[n2];
                        projects = String.valueOf(projects) + prjName + "<F>";
                        ++n2;
                    }
                    properties.put(FilterController.PROJECTS_KEY, projects);
                }
                properties.put(FilterController.ENABLE_LIMIT_KEY, String.valueOf(FilterController.this.descriptor.isEnableLimits()));
                dialog.updateProperties();
            }
        }
    }

    class TestListener
    implements Listener {
        TestListener() {
        }

        public void handleEvent(Event event) {
            TableItem selectedTableItem = FilterController.this.filterTable.getTable().getItem(new Point(0, event.y));
            FilterController.this.updateSelection(selectedTableItem);
        }
    }

    class UsagesProjectsListWrapper
    extends ProjectsListWrapper {
        protected boolean shouldAdd(ProjectInfo projectInfo) {
            return FilterController.this.showProjects;
        }

        protected void doSelection(int[] selection, int selIndex) {
            if (FilterController.this.showProjects) {
                super.doSelection(selection, selIndex);
            }
        }

        protected void addListener() {
            if (FilterController.this.showProjects) {
                super.addListener();
            }
        }
    }
}

