/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.ui.FilterController;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.views.BrowserManager;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;

public class FilterButtonListener
extends SelectionAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private FilterController controller;

    public FilterButtonListener(FilterController ctrl) {
        this.controller = ctrl;
    }

    public void widgetSelected(SelectionEvent e) {
        this.controller.getDescriptor().getState().detach();
        if (e.getSource() != null && !((Button)e.getSource()).isDisposed()) {
            ((Button)e.getSource()).setEnabled(false);
        }
        this.controller.getManager().setCurrentContext(null);
        Button applyButton = (Button)e.getSource();
        Boolean compute = (Boolean)applyButton.getData();
        if (compute == null || compute.booleanValue()) {
            IAction action = this.controller.getDescriptor().getAction();
            action.setInputContext((IActionContext)new AbstractActionContext(){

                public Map<String, Object> getData() {
                    UsageStateAdapter state = FilterButtonListener.this.controller.getDescriptor().getState();
                    FilterButtonListener.this.controller.storeSelectedProjects();
                    return state.getData();
                }

                public String getId() {
                    UsageStateAdapter state = FilterButtonListener.this.controller.getDescriptor().getState();
                    return state.getId();
                }
            });
            this.controller.getManager().runInPlace(action, new IFinishedListener(){

                public void finished(boolean canceled, Throwable t) {
                    ((BrowserManager)FilterButtonListener.this.controller.getManager()).updateTools();
                    FilterButtonListener.this.enableFilterAction(canceled || t != null);
                }
            });
        } else {
            this.controller.update();
            this.enableFilterAction(false);
        }
    }

    private void enableFilterAction(final boolean isCanceled) {
        Display disp = Display.getDefault();
        if (disp != null) {
            disp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    List prjList = (List)FilterButtonListener.this.controller.getDescriptor().getState().getData().get("PROJECT_LIST");
                    String newSummary = FilterButtonListener.this.controller.getFilterData().createFullSummary(FilterButtonListener.this.controller.getDescriptor().isEnableLimits(), true, prjList);
                    if (!isCanceled) {
                        Map<String, Object> data = FilterButtonListener.this.controller.getDescriptor().getState().getData();
                        data.put("fullSummary", newSummary);
                    }
                    FilterButtonListener.this.controller.enableFilterAction();
                }
            });
        }
    }
}

