/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ChangeLevelsOrderDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DEFAULT_TITLE = Messages.getString(ChangeLevelsOrderDialog.class, "dialog.title");
    private List<FilterEntry> levelsList;
    private List<FilterEntry> modifiedLevelsList = new ArrayList<FilterEntry>();
    private TableViewer viewer;
    private ImageRegistry reg;
    private Button moveResUp;
    private Button moveResDown;

    public ChangeLevelsOrderDialog(Shell shell, List<FilterEntry> levelsList, ImageRegistry registry) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.levelsList = levelsList;
        Assert.isNotNull(levelsList);
        this.setHelpAvailable(false);
        this.reg = registry;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DEFAULT_TITLE);
        newShell.setMinimumSize(200, 150);
        Rectangle rect = newShell.getParent().getBounds();
        newShell.setLocation(rect.x + rect.width / 6, rect.y + rect.height / 8);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ChangeLevelsOrderDialog.applyDialogFont((Control)composite);
        GridData layoutData = new GridData(4, 4, true, true, 3, 4);
        this.viewer = new TableViewer(composite, 68354);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LevelsLabelProvider());
        this.viewer.setInput(this.levelsList);
        this.viewer.getTable().setLayoutData((Object)layoutData);
        this.modifiedLevelsList = new ArrayList<FilterEntry>();
        this.modifiedLevelsList.addAll(this.levelsList);
        TestListener listener = new TestListener();
        this.viewer.getTable().addListener(4, (Listener)listener);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ChangeLevelsOrderDialog.this.moveResUp == null || ChangeLevelsOrderDialog.this.moveResDown == null) {
                    return;
                }
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                FilterEntry fEntry = (FilterEntry)sel.getFirstElement();
                if (fEntry == null) {
                    return;
                }
                boolean enabled = !Boolean.toString(true).equals(fEntry.get("Fixed.position"));
                int index = ChangeLevelsOrderDialog.this.viewer.getTable().getSelectionIndex();
                FilterEntry next = (FilterEntry)ChangeLevelsOrderDialog.this.viewer.getElementAt(index + 1);
                ChangeLevelsOrderDialog.this.moveResDown.setEnabled(enabled && next != null && !Boolean.toString(true).equals(next.get("Fixed.position")));
                FilterEntry prev = (FilterEntry)ChangeLevelsOrderDialog.this.viewer.getElementAt(index - 1);
                ChangeLevelsOrderDialog.this.moveResUp.setEnabled(enabled && prev != null && !Boolean.toString(true).equals(prev.get("Fixed.position")));
            }
        });
        ReorderListener reorderListener = new ReorderListener();
        layoutData.grabExcessHorizontalSpace = true;
        this.moveResUp = new Button(composite, 8);
        this.moveResUp.setImage(this.reg.get("arrowUp"));
        this.moveResDown = new Button(composite, 8);
        layoutData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        this.moveResUp.setLayoutData((Object)layoutData);
        this.moveResUp.setToolTipText(Messages.getString(ChangeLevelsOrderDialog.class, "dialog.moveResUp"));
        this.moveResUp.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(ChangeLevelsOrderDialog.class, "dialog.moveResUp");
            }
        });
        this.moveResDown.setImage(this.reg.get("arrowDown"));
        layoutData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        this.moveResDown.setLayoutData((Object)layoutData);
        this.moveResDown.setToolTipText(Messages.getString(ChangeLevelsOrderDialog.class, "dialog.moveResDown"));
        this.moveResDown.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(ChangeLevelsOrderDialog.class, "dialog.moveResDown");
            }
        });
        this.moveResUp.addSelectionListener((SelectionListener)reorderListener);
        this.moveResDown.addSelectionListener((SelectionListener)reorderListener);
        return composite;
    }

    public List<FilterEntry> getOrder() {
        return this.modifiedLevelsList;
    }

    private void updateSelection(TableItem selectedTableItem) {
        if (selectedTableItem != null) {
            FilterEntry filterEntry = (FilterEntry)selectedTableItem.getData();
            GroupFilterEntry groupFilterEntry = filterEntry.getGroupFilterEntry();
            ArrayList<Object> elements = new ArrayList<Object>();
            if (groupFilterEntry != null) {
                TableItem[] tableItems;
                TableItem[] tableItemArray = tableItems = this.viewer.getTable().getItems();
                int n = tableItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    FilterEntry tableItemFilterEntry = (FilterEntry)tableItem.getData();
                    if (groupFilterEntry.equals(tableItemFilterEntry.getGroupFilterEntry())) {
                        elements.add(tableItemFilterEntry);
                    }
                    ++n2;
                }
            } else {
                elements.add(selectedTableItem.getData());
            }
            StructuredSelection selection = new StructuredSelection(elements);
            this.viewer.setSelection((ISelection)selection);
        }
    }

    class LevelsLabelProvider
    extends LabelProvider {
        LevelsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof FilterEntry) {
                return ((FilterEntry)element).getValidAttribute(((FilterEntry)element).getPropertyIndex(FilterEntry.ATTR_NAME));
            }
            return "";
        }
    }

    class ReorderListener
    extends SelectionAdapter {
        ReorderListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] tableItemSelection = ChangeLevelsOrderDialog.this.viewer.getTable().getSelection();
            ArrayList<FilterEntry> filterItemSelection = new ArrayList<FilterEntry>();
            int i = 0;
            while (i < tableItemSelection.length) {
                filterItemSelection.add((FilterEntry)tableItemSelection[i].getData());
                ++i;
            }
            List treeData = (List)ChangeLevelsOrderDialog.this.viewer.getInput();
            if (e.widget == ChangeLevelsOrderDialog.this.moveResUp) {
                int index = 0;
                while (index < treeData.size()) {
                    FilterEntry filterEntry = (FilterEntry)treeData.get(index);
                    if (filterItemSelection.contains(filterEntry) && index > 0 && (filterEntry.getGroupFilterEntry() == null || !filterEntry.getGroupFilterEntry().equals(((FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.get(index - 1)).getGroupFilterEntry()))) {
                        int newIndex = index;
                        GroupFilterEntry groupFilterEntry = ((FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.get(newIndex - 1)).getGroupFilterEntry();
                        while (--newIndex > 0 && groupFilterEntry != null && groupFilterEntry.equals(((FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.get(newIndex - 1)).getGroupFilterEntry())) {
                        }
                        FilterEntry moved = (FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.remove(index);
                        ChangeLevelsOrderDialog.this.modifiedLevelsList.add(newIndex, moved);
                    }
                    ++index;
                }
            } else if (e.widget == ChangeLevelsOrderDialog.this.moveResDown) {
                int index = treeData.size() - 1;
                while (index >= 0) {
                    FilterEntry filterEntry = (FilterEntry)treeData.get(index);
                    if (filterItemSelection.contains(filterEntry) && index < treeData.size() - 1 && (filterEntry.getGroupFilterEntry() == null || !filterEntry.getGroupFilterEntry().equals(((FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.get(index + 1)).getGroupFilterEntry()))) {
                        int newIndex = index;
                        GroupFilterEntry groupFilterEntry = ((FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.get(newIndex + 1)).getGroupFilterEntry();
                        while (++newIndex < treeData.size() - 1 && groupFilterEntry != null && groupFilterEntry.equals(((FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.get(newIndex + 1)).getGroupFilterEntry())) {
                        }
                        FilterEntry moved = (FilterEntry)ChangeLevelsOrderDialog.this.modifiedLevelsList.remove(index);
                        ChangeLevelsOrderDialog.this.modifiedLevelsList.add(newIndex, moved);
                    }
                    --index;
                }
            }
            ChangeLevelsOrderDialog.this.viewer.setInput((Object)ChangeLevelsOrderDialog.this.modifiedLevelsList);
            ChangeLevelsOrderDialog.this.viewer.refresh();
            ChangeLevelsOrderDialog.this.viewer.setSelection(ChangeLevelsOrderDialog.this.viewer.getSelection());
        }
    }

    class TestListener
    implements Listener {
        TestListener() {
        }

        public void handleEvent(Event event) {
            TableItem selectedTableItem = ChangeLevelsOrderDialog.this.viewer.getTable().getItem(new Point(0, event.y));
            ChangeLevelsOrderDialog.this.updateSelection(selectedTableItem);
        }
    }
}

