/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ui;

import com.ez.report.application.event.ErrorEvent;
import com.ez.report.application.event.ErrorEventListener;
import com.ez.report.application.event.ErrorMessage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilterSettingsDialog
extends Dialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractFilterSettingsDialog.class);
    protected Display display = Display.getDefault();
    protected final Cursor waitCursor = new Cursor((Device)this.display, 1);
    protected final Cursor defCursor = new Cursor((Device)this.display, 0);
    protected final Color redColor = new Color((Device)this.display, 255, 0, 0);
    protected Font titleFont = null;
    protected ErrorMessage msg;
    protected String fileName = "default";
    protected boolean initiated = false;

    public AbstractFilterSettingsDialog(Shell shell) {
        super(shell);
    }

    protected abstract void update();

    public Control createDialogArea(Composite parent) {
        Composite page = (Composite)super.createDialogArea(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        GridLayout layout = new GridLayout();
        page.setLayout((Layout)layout);
        this.msg = new ErrorMessage(page, 0);
        this.msg.addErrorListener(new ErrorEventListener(){

            public void errorEventHappend(ErrorEvent errEv) {
                Button okB = AbstractFilterSettingsDialog.this.getButton(0);
                if ((errEv.error == null || errEv.error.equals("")) && okB != null) {
                    okB.setEnabled(true);
                }
            }
        });
        this.createPage(page);
        return page;
    }

    protected abstract void createPage(Composite var1);

    public void setErrorMessage(String message) {
        L.info("ERROR: {}", (Object)message);
        this.msg.notify(message);
    }

    public void removeErrorMessage(String messageErr) {
        L.info("remove ERROR: {}", (Object)messageErr);
        this.msg.remove(messageErr);
    }

    protected boolean isResizable() {
        return true;
    }
}

