/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.tpmsx;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMNodesFactory;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class TPMSXTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DDCLPROGRAMTYPE = String.valueOf(14);

    public TPMSXTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.COBOL_OR_DDCL);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElement resultElement;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.COBOL_OR_DDCL)) {
                        String categoryName = (String)r.getColumnValue(DatabaseMetadata.TYPE_DESCRIPTION.getName());
                        Integer typeId = (Integer)r.getColumnValue(DatabaseMetadata.TYPE_ID.getName());
                        if (typeId == 1) {
                            parent = Utils.getCategory(ResultElementType.PROGRAM, parent, categoryName);
                            parent.addProperty("Program Type Id", typeId);
                        } else {
                            parent = Utils.getCategory(ResultElementType.COBOL_OR_DDCL, parent, categoryName);
                        }
                    }
                    if ((resultElement = parent.getChild(name)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(name, resultElement);
                    }
                    TPMSXTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case TPMSX: {
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.TPMSX_ID.getName());
                    Integer prgTypeId = (Integer)r.getColumnValue(DatabaseMetadata.TYPE_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.TPMSX_ID.getName(), id);
                    resultElement.addProperty(DatabaseMetadata.PRG_TYPE_ID.getName(), prgTypeId);
                    String spath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.SCREEN_PATH.getName()));
                    if (!spath.isEmpty()) {
                        Integer scrstartRow = (Integer)r.getColumnValue(DatabaseMetadata.SCREEN_START_ROW.getName());
                        Integer scrstartCol = (Integer)r.getColumnValue(DatabaseMetadata.SCREEN_START_COL.getName());
                        Integer screndRow = (Integer)r.getColumnValue(DatabaseMetadata.SCREEN_END_ROW.getName());
                        Integer screndCol = (Integer)r.getColumnValue(DatabaseMetadata.SCREEN_END_COL.getName());
                        Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, spath, scrstartRow, scrstartCol, screndRow, screndCol);
                    }
                    GenericProgramRelatedNode prgNodeTMPSX = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.TPMSX.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", prgNodeTMPSX);
                    break;
                }
                case COBOL_OR_DDCL: {
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.ID.getName());
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    String path = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PATH.getName()));
                    Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    Integer typeId = (Integer)r.getColumnValue(DatabaseMetadata.TYPE_ID.getName());
                    if (typeId == 1) {
                        resultElement.addProperty("Program Type Id", typeId);
                        String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)typeId.toString());
                        MainframeSourceNode prgNode = new MainframeSourceNode(programType, path);
                        resultElement.addProperty("Node_Mainframe", prgNode);
                        Utils.setFileAttribute(resultElement, typeId.toString(), path, startRow, startCol, endRow, endCol);
                        resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), path);
                        resultElement.addProperty("Ancestor Name", r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                    } else {
                        Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, path, startRow, startCol, endRow, endCol);
                        resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), typeId);
                        Integer elemID = (Integer)r.getColumnValue(DatabaseMetadata.ID.getName());
                        resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), elemID);
                        resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), r.getColumnValue(DatabaseMetadata.PARENT_NAME.getName()));
                        AMBaseNode ddclNode = AMNodesFactory.createNode((Integer)typeId, (String)resultElement.getName(), (Integer)elemID);
                        if (ddclNode != null) {
                            resultElement.addProperty("Application_Master_Node", ddclNode);
                        }
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    String categoryName = (String)r.getColumnValue(DatabaseMetadata.TYPE_DESCRIPTION.getName());
                    GenericProgramRelatedNode prgNodeTypeDDCL = new GenericProgramRelatedNode(resultElement.getName(), categoryName);
                    resultElement.addProperty("Node_Mainframe", prgNodeTypeDDCL);
                    break;
                }
                case STMT_SOURCE_INFO: {
                    String programTypeStmt;
                    Integer typeId = (Integer)r.getColumnValue(DatabaseMetadata.TYPE_ID.getName());
                    String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                    resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                    String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_TYPE_NAME.getName());
                    if (stmtTypeName == null) {
                        stmtTypeName = "";
                    }
                    if (typeId.equals(1)) {
                        programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(typeId));
                        resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                    } else {
                        programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)DDCLPROGRAMTYPE);
                        resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                    }
                    Integer sstartRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                    resultElement.addProperty("Stmt Start Row", sstartRow);
                    Integer sstartCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                    Integer sendRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                    Integer sendCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, typeId.toString(), stmtPath, sstartRow, sstartCol, sendRow, sendCol);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

