/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.tpmsx;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class TPMSXFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public TPMSXFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "TPMSXUsageTPMSXLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.TPMSX, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@TPMSXScreenName");
        e.setValidator(3, limitValidator);
        this.addColumnsForTPMSX(e);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "TPMSXUsageProgramLimit", 0);
        e = this.makeFilterEntry(ResultElementType.COBOL_OR_DDCL, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@Program");
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        e.setValidator(3, limitValidator);
        this.addColumnsForProgram(e);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "TPMSXUsageStmtTypeLimit", 0);
        e = this.makeFilterEntry(ResultElementType.TPMSX_STMT_TYPE, defaultPatterns, limit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        e.setValidator(3, limitValidator);
        this.addColumnsForStmt(e);
        this.entries.add(e);
    }

    private void addColumnsForTPMSX(FilterEntry e) {
        e.put(DatabaseMetadata.TPMSX_ID.getName(), DatabaseMetadata.TPMSX_ID.getName());
        e.put(DatabaseMetadata.TPMSX_NAME.getName(), DatabaseMetadata.TPMSX_NAME.getName());
        e.put(DatabaseMetadata.SCREEN_PATH.getName(), DatabaseMetadata.SCREEN_PATH.getName());
        e.put(DatabaseMetadata.SCREEN_START_ROW.getName(), DatabaseMetadata.SCREEN_START_ROW.getName());
        e.put(DatabaseMetadata.SCREEN_END_ROW.getName(), DatabaseMetadata.SCREEN_END_ROW.getName());
        e.put(DatabaseMetadata.SCREEN_START_COL.getName(), DatabaseMetadata.SCREEN_START_COL.getName());
        e.put(DatabaseMetadata.SCREEN_END_COL.getName(), DatabaseMetadata.SCREEN_END_COL.getName());
        this.addMandatoryColumns(e);
    }

    private void addColumnsForProgram(FilterEntry e) {
        e.put(DatabaseMetadata.ID.getName(), DatabaseMetadata.ID.getName());
        e.put(DatabaseMetadata.PARENT_NAME.getName(), DatabaseMetadata.PARENT_NAME.getName());
        e.put(DatabaseMetadata.PATH.getName(), DatabaseMetadata.PATH.getName());
        e.put(DatabaseMetadata.TYPE_DESCRIPTION.getName(), DatabaseMetadata.TYPE_DESCRIPTION.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        this.addMandatoryColumns(e);
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
    }

    @Override
    protected void addColumnsForStmt(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
        this.addMandatoryColumns(e);
    }

    @Override
    protected void addMandatoryColumns(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_TYPE_ID.getName(), DatabaseMetadata.STMT_TYPE_ID.getName());
        e.put(DatabaseMetadata.STMT_TYPE_NAME.getName(), DatabaseMetadata.STMT_TYPE_NAME.getName());
        super.addMandatoryColumns(e);
    }
}

