/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.tpmsx;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.tpmsx.State;
import com.ez.analysis.mainframe.usage.tpmsx.TPMSXFilter;
import com.ez.analysis.mainframe.usage.tpmsx.TPMSXTreeProvider;
import com.ez.analysis.mainframe.usage.tpmsx.TPMSXUsageAnalysis;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZCobolProgram;
import com.ez.internal.analysis.config.inputs.EZDDCLComponent;
import com.ez.internal.analysis.config.inputs.EZDDCLDialogue;
import com.ez.internal.analysis.config.inputs.EZDDCLExchange;
import com.ez.internal.analysis.config.inputs.EZDDCLScreen;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceScreen;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPMSXDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TPMSXDescriptor.class);
    public static final String TPMSX_PARAM = "@TPMSXScreenName";
    private static final String TPMSX_PARAM_LIMIT = "@TPMSXScreenNameLimit";
    private static final String TPMSX_COLUMN = DatabaseMetadata.TPMSX_NAME.getName();
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PARENT_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeNameLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_TYPE_NAME.getName();
    private static final String TPMSX_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.TPMSX, new String[0]);
    protected static final String COBOL_OR_DDCL_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.COBOL_OR_DDCL, new String[0]);
    protected static final String ANCESTOR_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.COBOL_OR_DDCL, "LIKE_OR_IN_SECOND");
    public static final String MAINFRAME_TPMSX_USAGE = "com.ez.analysis.mainframe.usage.tpmsx";
    private static final String TPMSXS_USAGE_FILTERS_FILE_NAME = "TPMSXUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> TPMSX_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.TPMSX.name(), list);
            list.add(DatabaseMetadata.TPMSX_ID);
            list.add(DatabaseMetadata.TPMSX_NAME);
            list = new ArrayList();
            this.put(ResultElementType.TPMSX_STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_TYPE_NAME);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.COBOL_OR_DDCL.name(), list);
            list.add(DatabaseMetadata.ID);
            list.add(DatabaseMetadata.PARENT_NAME);
            list.add(DatabaseMetadata.TYPE_DESCRIPTION);
            list.add(DatabaseMetadata.PATH);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public TPMSXDescriptor(TPMSXUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_TPMSX_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new TPMSXTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        HashMap<ResultElementType, StringBuilder> defaultPatterns = new HashMap<ResultElementType, StringBuilder>();
        if (objTypes != null) {
            for (EZObjectType objType : objTypes) {
                if (objType instanceof EZSourceScreen || objType instanceof EZDDCLScreen) {
                    String name = objType.getName();
                    if (name == null) {
                        EZSourceScreenIDSg segment = (EZSourceScreenIDSg)objType.getEntID().getSegment(EZSourceScreenIDSg.class);
                        name = segment.getResourceName();
                    }
                    Utils.addInput(defaultPatterns, ResultElementType.TPMSX, name);
                    continue;
                }
                if (objType instanceof EZCobolProgram) {
                    EZSourceProgramIDSg ezSourceProgramIDSg = (EZSourceProgramIDSg)objType.getEntID().getSegment(EZSourceProgramIDSg.class);
                    String name = ezSourceProgramIDSg.getProgramName();
                    String ancestorName = ezSourceProgramIDSg.getAncestorName();
                    String prgName = "";
                    if (ancestorName != null && !ancestorName.trim().isEmpty()) {
                        prgName = String.valueOf(ancestorName) + ":";
                    }
                    prgName = String.valueOf(prgName) + name;
                    Utils.addInput(defaultPatterns, ResultElementType.COBOL_OR_DDCL, prgName);
                    continue;
                }
                if (!(objType instanceof EZDDCLDialogue) && !(objType instanceof EZDDCLExchange) && !(objType instanceof EZDDCLComponent)) continue;
                Utils.addInput(defaultPatterns, ResultElementType.COBOL_OR_DDCL, objType.getName());
            }
        }
        return new TPMSXFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.TPMSX_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_TPMSX";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.TPMSX.name(), " @TPMSXScreenNameLimit INT, @TPMSXScreenName VARCHAR(64)");
            spParam.put(ResultElementType.COBOL_OR_DDCL.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.TPMSX_STMT_TYPE.name(), " @StatementTypeNameLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.TPMSX.name(), " (@TPMSXScreenName = ''%'' or UPPER(" + TPMSX_COLUMN + ") " + TPMSX_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.COBOL_OR_DDCL.name(), " ((@Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + COBOL_OR_DDCL_LIKE_OR_IN_MARKER + ")" + " AND (" + "@Ancestor" + " = ''%'' or " + "UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.TPMSX_STMT_TYPE.name(), " (@StatementType = ''%'' or UPPER(" + STATEMENT_TYPE_COLUMN + ") " + STATEMENT_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.TPMSX.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(TPMSX_COLUMN).limitParamName(" @TPMSXScreenNameLimit ").create());
                this.put(ResultElementType.COBOL_OR_DDCL.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.TPMSX_STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_TYPE_COLUMN).limitParamName(" @StatementTypeNameLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return TPMSXS_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.TPMSX, TPMSX_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.COBOL_OR_DDCL, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.TPMSX_STMT_TYPE, STATEMENT_TYPE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return TPMSX_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "TPMSX";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.COBOL_OR_DDCL.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

