/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.sqltables;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.sqltables.SQLTablesFilter;
import com.ez.analysis.mainframe.usage.sqltables.SQLTablesUsageAnalysis;
import com.ez.analysis.mainframe.usage.sqltables.SqlTablesTreeProvider;
import com.ez.analysis.mainframe.usage.sqltables.State;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTablesDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SQLTablesDescriptor.class);
    protected static final String SQL_TABLE_PARAM = "@Table";
    private static final String SQL_TABLE_PARAM_LIMIT = "@TableLimit";
    private static final String SQL_TABLE_COLUMN = DatabaseMetadata.SQL_TABLE_NAME.getName();
    private static final String PROGRAM_PARAM = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_DESC_PARAM_LIMIT = "@StatementDescLimit";
    private static final String STATEMENT_DESC_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    public static final String MAINFRAME_SQLTABLE_USAGE = "com.ez.analysis.mainframe.usage.sqltables";
    private static final String SQL_TABLES_USAGE_FILTERS_FILE_NAME = "SQLTablesUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> SQL_TABLE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.SQL_TABLE.name(), list);
            list.add(DatabaseMetadata.SQL_TABLE_ID);
            list.add(DatabaseMetadata.SQL_TABLE_NAME);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list.add(DatabaseMetadata.STMT_PATH_STR);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public SQLTablesDescriptor(SQLTablesUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_SQLTABLE_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new SqlTablesTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new SQLTablesFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.SQL_TABLE_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_SQLTables";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.SQL_TABLE.name(), " @TableLimit INT, @Table VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementDescLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.SQL_TABLE.name(), " (@Table =''%'' or UPPER(" + SQL_TABLE_COLUMN + ") " + SQL_TABLE_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.PROGRAM.name(), " ((@Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + PROGRAM_LIKE_OR_IN_MARKER + ") AND (" + "@Ancestor" + " = ''%'' or UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or UPPER(" + STATEMENT_DESC_COLUMN + ") " + STATEMENT_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.SQL_TABLE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(SQL_TABLE_COLUMN).limitParamName(" @TableLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_DESC_COLUMN).limitParamName(" @StatementDescLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return SQL_TABLES_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.SQL_TABLE, SQL_TABLE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_DESC_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return SQL_TABLE_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "SQLTable";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

