/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.scl;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.programs.BasicProgramTreeProvider;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.ParagraphNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SCLTreeProvider
extends BasicProgramTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public SCLTreeProvider(BasicProgramDescriptor descriptor) {
        super(descriptor);
    }

    protected ResultElement processVariable(Map<String, ResultElement> variablesMap, Row r, ResultElement parent, String name, ProjectInfo projectInfo) {
        String projectName = projectInfo.getName();
        Integer varID = (Integer)r.getColumnValue(DatabaseMetadata.VAR_ID.getName());
        String varKey = Utils.getKeyForVariable(projectName, varID);
        Integer paramNr = (Integer)r.getColumnValue(DatabaseMetadata.IS_PARAMETER.getName());
        boolean isParam = paramNr != 0;
        ResultElement resultElement = variablesMap.get(varKey);
        if (resultElement == null) {
            Integer headFather = (Integer)r.getColumnValue(DatabaseMetadata.VAR_Father.getName());
            ResultElement varParent = variablesMap.get(Utils.getKeyForVariable(projectName, headFather));
            if (varParent != null && headFather != 0) {
                parent = varParent;
            }
            if (isParam) {
                parent = Utils.getCategory(ResultElementType.PARAMETER, parent.getParent(), null);
                resultElement = new ResultElement(name, ResultElementType.PARAMETER, parent);
            } else {
                resultElement = new ResultElement(name, ResultElementType.SCL_VARIABLE, parent);
            }
            variablesMap.put(varKey, resultElement);
            resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), varID);
            String key = varID.toString().concat(name);
            parent.addChild(key, resultElement);
            this.addElementInfo(resultElement, r);
            Utils.completeProjectInfo(resultElement, projectInfo);
        }
        return resultElement;
    }

    private ResultElement processProcedure(Row r, ResultElement parent, ProjectInfo projectInfo) {
        String name = Utils.null2empty(r.getColumnValue(DatabaseMetadata.SCL_PROC_SYNONYMUS.getName()));
        parent = Utils.getCategory(ResultElementType.SCL_PROC_SYNONYM, parent, null);
        ResultElement resultElement = new ResultElement(name, ResultElementType.SCL_PROC_SYNONYM, parent);
        resultElement.addProperty("Program Type Id", this.programTypeId);
        String paraPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CHILD_PRG_PATH.getName()));
        Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_ROW.getName());
        Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_COL.getName());
        Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_ROW.getName());
        Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_COL.getName());
        Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), paraPath, startRow, startCol, endRow, endCol);
        parent.addChild(name, resultElement);
        Utils.completeProjectInfo(resultElement, projectInfo);
        return resultElement;
    }

    @Override
    protected boolean hasLevelCategory(ResultElementType levelElementType) {
        return levelElementType.equals((Object)ResultElementType.STMT_TYPE) || levelElementType.equals((Object)ResultElementType.SCL_VARIABLE);
    }

    @Override
    protected void addElementInfo(ResultElement resultElement, Row r) {
        if (resultElement.getProperty("FILE") != null || resultElement.getProperty("ProjectInfo") != null) {
            return;
        }
        ResultElementType type = resultElement.getType();
        if (ResultElementType.PROGRAM.equals((Object)type)) {
            this.setSCLAttributes(resultElement, r);
            resultElement.addProperty("is program scl having procedure's information", Boolean.TRUE);
            String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
            resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
            Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
            Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
            Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
            Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
            String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(this.programTypeId));
            String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
            ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (ResultElementType.SCL_VARIABLE.equals((Object)type) || ResultElementType.PARAMETER.equals((Object)type)) {
            String varPath = (String)r.getColumnValue(DatabaseMetadata.VAR_PATH_STR.getName());
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName());
            Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_COL.getName());
            Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_END_ROW.getName());
            Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.VAR_END_COL.getName());
            String category = resultElement.getType().equals((Object)ResultElementType.SCL_VARIABLE) ? ResultElementType.SCL_VARIABLE.getDisplayName() : ResultElementType.VARIABLE.getDisplayName();
            GenericProgramRelatedNode prgNode = new GenericProgramRelatedNode(resultElement.getName(), category);
            resultElement.addProperty("Node_Mainframe", prgNode);
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), varPath, startRow, startCol, endRow, endCol);
        } else if (ResultElementType.STMT_SOURCE_INFO.equals((Object)type)) {
            resultElement.addProperty("Program Type Id", this.programTypeId);
            String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
            resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
            String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(this.programTypeId));
            String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
            resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
            resultElement.addProperty("Stmt Start Row", startRow);
            Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), stmtPath, startRow, startCol);
        } else if (ResultElementType.PROJECT_INFO.equals((Object)type)) {
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (((BasicProgramDescriptor)this.descriptor).getSpecificElementType().equals((Object)type)) {
            this.addSpecificElementInfo(resultElement, r);
        }
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected void addSpecificElementInfo(ResultElement resultElement, Row r) {
        this.setSCLAttributes(resultElement, r);
        String paraName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PARA_NAME.getName()));
        Integer ordinalNumber = (Integer)r.getColumnValue(DatabaseMetadata.PARA_ORDINAL.getName());
        String paraPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CHILD_PRG_PATH.getName()));
        Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_ROW.getName());
        Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_COL.getName());
        Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_ROW.getName());
        Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_COL.getName());
        ParagraphNode paraNode = new ParagraphNode(paraName, String.valueOf(ordinalNumber), null, null, null, null, null, null);
        paraNode.setParagraphTypeLbl(((BasicProgramDescriptor)this.descriptor).getSpecificElementType().name());
        resultElement.addProperty("Node_Mainframe", paraNode);
        Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), paraPath, startRow, startCol, endRow, endCol);
    }

    private void setSCLAttributes(ResultElement resultElement, Row r) {
        Integer typeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName());
        resultElement.addProperty("Program Type Id", typeId);
        String paraName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CHILD_PRG_NAME.getName()));
        resultElement.addProperty("Program name", paraName);
        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_ID.getName());
        resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
        String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
        resultElement.addProperty("Ancestor Name", ancestorName);
        Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
        resultElement.addProperty("Ancestor Id", ancestorId);
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        Map<String, ResultElement> variablesMap;
        ResultElement procParent;

        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.variablesMap = new HashMap<String, ResultElement>();
            this.procParent = null;
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (SCLTreeProvider.this.isElementValidForCreation(name, levelElementType, r)) {
                        if (SCLTreeProvider.this.hasLevelCategory(levelElementType)) {
                            String categoryName = null;
                            if (levelElementType.equals((Object)ResultElementType.SCL_VARIABLE)) {
                                if (this.procParent != null) {
                                    parent = this.procParent;
                                }
                            } else if (levelElementType.equals((Object)ResultElementType.STMT_TYPE)) {
                                Integer bRead = (Integer)r.getColumnValue(DatabaseMetadata.STMT_bREAD.getName());
                                categoryName = "Read value";
                                if (bRead == 0 || bRead == 2) {
                                    categoryName = "Write value";
                                }
                            }
                            parent = Utils.getCategory(levelElementType, parent, categoryName);
                        }
                        ResultElement resultElement = null;
                        if (levelElementType.equals((Object)ResultElementType.SCL_VARIABLE)) {
                            resultElement = SCLTreeProvider.this.processVariable(this.variablesMap, r, parent, name, projectInfo);
                        } else {
                            resultElement = parent.getChild(name);
                            if (resultElement == null) {
                                resultElement = new ResultElement(name, levelElementType, parent);
                                SCLTreeProvider.this.addElementInfo(resultElement, r);
                                parent.addChild(name, resultElement);
                                Utils.completeProjectInfo(resultElement, projectInfo);
                            }
                            if (levelElementType.equals((Object)ResultElementType.SCL_PROCEDURE)) {
                                this.procParent = resultElement;
                                resultElement = SCLTreeProvider.this.processProcedure(r, resultElement, projectInfo);
                            }
                        }
                        SCLTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                    }
                } else if (levelIndex == this.levelsOrder.size() && r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName()) != null) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    SCLTreeProvider.this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

