/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.scl;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.programs.BasicProgramFilter;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.Map;

public class SCLFilter
extends BasicProgramFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public SCLFilter(Map<ResultElementType, StringBuilder> defaultPatterns, ResultElementType specificElementType) {
        super(defaultPatterns, specificElementType);
        this.addFilterEntries(defaultPatterns, 10);
    }

    @Override
    protected void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns, Integer defaultLimit) {
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(10, null, 0, this.getProgramLimitPrefStoreKey(), 0);
        FilterEntry e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e.put("incontext", MATCHING_ALL_FILTERS_BELOW);
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        this.addFilterEntryInfoProgram(e);
        e = this.makeFilterEntry(this.specificElementType, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@ParaName");
        e.setValidator(3, limitValidator);
        this.addFilterEntryInfoSpecificUsageElem(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.SCL_VARIABLE, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@VarName");
        e.setValidator(3, limitValidator);
        this.addFilterEntryInfoVariable(e);
        this.entries.add(e);
    }

    @Override
    protected int getProgramTypeId() {
        return 13;
    }

    @Override
    protected void addFilterEntryInfoProgram(FilterEntry e) {
        super.addFilterEntryInfoProgram(e);
        e.put(DatabaseMetadata.CHILD_PRG_ID.getName(), "Programs_Children.ProgramID");
        e.put(DatabaseMetadata.CHILD_PRG_NAME.getName(), "Programs_Children.ProgramName");
        e.put(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName(), "Programs_Children.ProgramTypeID");
        e.put(DatabaseMetadata.CHILD_PRG_START_ROW.getName(), "Occurrences_PrgChildren.StartRow");
        e.put(DatabaseMetadata.CHILD_PRG_START_COL.getName(), "Occurrences_PrgChildren.StartCol");
        e.put(DatabaseMetadata.CHILD_PRG_END_ROW.getName(), "Occurrences_PrgChildren.EndRow");
        e.put(DatabaseMetadata.CHILD_PRG_END_COL.getName(), "Occurrences_PrgChildren.EndCol");
        e.put(DatabaseMetadata.CHILD_PRG_PATH.getName(), "Paths_PrgChildren.PathStr");
    }

    protected void addFilterEntryInfoVariable(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), "StatementReference.StartRow");
        e.put(DatabaseMetadata.STMT_START_COL.getName(), "StatementReference.StartCol");
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), "Paths_Stmt.PathStr");
        e.put(DatabaseMetadata.VAR_ID.getName(), "Variables.VarID");
        e.put(DatabaseMetadata.VAR_NAME.getName(), "Variables.VarName");
        e.put(DatabaseMetadata.VAR_Father.getName(), "Variables.Father");
        e.put(DatabaseMetadata.VAR_START_ROW.getName(), "Occurrences_Var.StartRow");
        e.put(DatabaseMetadata.VAR_START_COL.getName(), "Occurrences_Var.StartCol");
        e.put(DatabaseMetadata.VAR_END_ROW.getName(), "Occurrences_Var.EndRow");
        e.put(DatabaseMetadata.VAR_END_COL.getName(), "Occurrences_Var.EndCol");
        e.put(DatabaseMetadata.VAR_PATH_STR.getName(), "Paths_Var.PathStr");
        e.put(DatabaseMetadata.STMT_bREAD.getName(), "StatementReference.bRead");
        e.put(DatabaseMetadata.STMT_DESC.getName(), "Statements.Description");
        e.put(DatabaseMetadata.IS_PARAMETER.getName(), " CASE WHEN ParagraphArguments.ID IS NULL THEN 0 ELSE 1 END");
    }

    @Override
    protected void addFilterEntryInfoSpecificUsageElem(FilterEntry e) {
        e.put(DatabaseMetadata.PARA_NAME.getName(), "Paragraphs.ParaName");
        e.put(DatabaseMetadata.PARA_ORDINAL.getName(), "Paragraphs.OrdinalNum");
        e.put(DatabaseMetadata.SCL_PROC_SYNONYMUS.getName(), "SCLProcedureSynonyms.SCLProcedureSynonymName");
    }

    @Override
    protected String getProgramLimitPrefStoreKey() {
        return "SCLUsageProgramLimit";
    }

    @Override
    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
        if (ResultElementType.SCL_VARIABLE.equals((Object)type) || this.specificElementType.equals((Object)type) || ResultElementType.INCLUDE.equals((Object)type)) {
            e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
            e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
            e.put("incontext", "  ");
        }
    }

    @Override
    protected void addFilterEntryInfoInclude(FilterEntry e) {
    }
}

