/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.scl;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.scl.SCLFilter;
import com.ez.analysis.mainframe.usage.scl.SCLTreeProvider;
import com.ez.analysis.mainframe.usage.scl.State;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SCLDescriptor
extends BasicProgramDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String MAINFRAME_SCL_USAGE = "com.ez.analysis.mainframe.usage.scl";
    private static final String SCL_USAGE_FILTERS_FILE_NAME = "SCLUsageFilters.properties";
    private static final String PROG_WITH_ALIAS = "(SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p";
    private static String SCL_VARIABLE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.SCL_VARIABLE, new String[0]);
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    private static Map<String, String> spDetails;
    private static Map<String, String> spOrderBy;
    private static Map<String, String> spSelectProgramIds;

    public SCLDescriptor(AbstractAnalysis analysis) {
        super(analysis);
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new SCLTreeProvider(this);
    }

    public String getId() {
        return MAINFRAME_SCL_USAGE;
    }

    @Override
    protected void initializeCSVSuffixes() {
        this.csvFileSuffixMap = new HashMap();
        ArrayList<ResultElementType> list = null;
        list = new ArrayList<ResultElementType>();
        list.add(ResultElementType.PROGRAM);
        ResultElementType tabSpecificElementType = this.getSpecificElementType();
        list.add(tabSpecificElementType);
        this.csvFileSuffixMap.put(tabSpecificElementType, new Pair((Object)" - ".concat(tabSpecificElementType.getDisplayName()).concat("s"), list));
        list = new ArrayList();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.SCL_VARIABLE);
        this.csvFileSuffixMap.put(ResultElementType.SCL_VARIABLE, new Pair((Object)" - Variables", list));
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, true, new ResultElementType[0]);
        SCLFilter pf = new SCLFilter(defaultPatterns.isEmpty() ? null : defaultPatterns, this.getSpecificElementType());
        return pf;
    }

    @Override
    public String getFileName() {
        return SCL_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    public ResultElementType getSpecificElementType() {
        return ResultElementType.SCL_PROCEDURE;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null || !spParam.containsKey(this.getSpecificElementType().name())) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.SCL_VARIABLE.name(), " @_VarName VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), "@_PrgTypeID INT, @_PrgLimit INT, @_Program VARCHAR(255)");
            spParam.put(this.getSpecificElementType().name(), " @_ParaName VARCHAR(64)");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureSelectProgramIDs() {
        spSelectProgramIds = new HashMap<String, String>();
        String from_where = "@@@@@EZLEGACY@@@@\n  WHERE ENTRY1.ProgramId = ENTRY2.ProgramId AND ENTRY2.ProgramId = ENTRY3.ProgramID\n  ORDER BY ENTRY1.ProgramName";
        spSelectProgramIds.put(ResultElementType.PROGRAM.name(), "\n select top (@PrgLimit) ENTRY1.ProgramId into #tempids from " + from_where);
        spSelectProgramIds.put("query_unlimited".concat(ResultElementType.PROGRAM.name()), "\n select ENTRY1.ProgramId into #tempids from " + from_where);
        spSelectProgramIds.put(this.getSpecificElementType().name(), "\n (select distinct ProgramID, ProgramName from #temppara \n union select ProgramID, ProgramName from #nopara\n ) as ENTRY");
        spSelectProgramIds.put(ResultElementType.SCL_VARIABLE.name(), "\n (select distinct programid, ProgramName from #varUsage \n union select ProgramID, ProgramName from #novars\n ) as ENTRY");
        return spSelectProgramIds;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            String PARAGRAPH_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(this.getSpecificElementType(), new String[0]);
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(this.getSpecificElementType().name(), "\n SELECT * into #temppara from (\n SELECT distinct p.ProgramName, p.ProgramID\n\t\t\tFROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p INNER JOIN Paragraphs ON p.ProgramID = Paragraphs.ProgramID\n\t\t\t\t left join SCLProcedureSynonyms ON Paragraphs.ParaName = SCLProcedureSynonyms.SCLProcedureName\n \t\tWHERE (p.ProgramTypeID = @PrgTypeID)\n\t\t\t\tAND (p.OccurID <> 0)\n\t\t\t\tAND (ProgramName " + PROGRAM_LIKE_OR_IN_MARKER + ")" + "\n\t\t\t\tAND ((ParaName " + PARAGRAPH_LIKE_OR_IN_MARKER + ") OR (SCLProcedureSynonymName " + PARAGRAPH_LIKE_OR_IN_MARKER + "))" + "\n ) as tq1 " + "\n select ProgramID, ProgramName into #nopara " + "\n \t\tFROM (select distinct p.programid, ProgramName from " + PROG_WITH_ALIAS + "\n\t\t\t\tLEFT JOIN Paragraphs ON p.ProgramID = Paragraphs.ProgramID " + "\n\t\t\t\tWHERE (p.ProgramTypeID = @PrgTypeID) " + "\n\t\t\t\t\tAND (p.OccurID <> 0) " + "\n\t\t\t\t\tAND Paragraphs.ParaID IS NULL " + "\n\t\t\t\t\tAND (ProgramName " + PROGRAM_LIKE_OR_IN_MARKER + ") " + "\n\t\t\t\t\tAND @ParaName = ''%'' " + "\n ) as para");
            spWhereClause.put(ResultElementType.SCL_VARIABLE.name(), "\n select * into #varUsage from (\n\t\tSELECT distinct p.ProgramName, p.ProgramID \n\t\t\t\tFROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p \n inner join Variables ON Variables.ProgIDReference = p.ProgramID\n\t\t\t\tWHERE (ProgramTypeID = @PrgTypeID)\n\t\t\t\t\tAND (p.OccurID <> 0)\n\t\t\t\t\tAND (ProgramName " + PROGRAM_LIKE_OR_IN_MARKER + ")" + "\n\t\t\t\t\tAND VarName " + SCL_VARIABLE_LIKE_OR_IN_MARKER + "\n ) as tq2" + "\n select ProgramID, ProgramName into #novars " + "\n \t\tFROM (select distinct p.programid, ProgramName from " + PROG_WITH_ALIAS + "\n\t\t\t\tLEFT JOIN Variables ON p.ProgramID = Variables.ProgIDReference " + "\n\t\t\t\tWHERE (p.ProgramTypeID = @PrgTypeID) " + "\n\t\t\t\t\tAND (p.OccurID <> 0)" + "\n\t\t\t\t\tAND (ProgramName " + PROGRAM_LIKE_OR_IN_MARKER + ") " + "\n\t\t\t\t\tAND Variables.VarID IS NULL " + "\n\t\t\t\t\tAND @VarName = ''%'' " + "\n ) as vars");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureDetailsSelect() {
        if (spDetails == null) {
            spDetails = new HashMap<String, String>();
            spDetails.put(ResultElementType.PROGRAM.name(), "\n SELECT @@@@@EZLEGACY@@@@ FROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p\n INNER JOIN Occurrences AS Occurrences_Prg ON Occurrences_Prg.OccurID = p.OccurID\n INNER JOIN Paths AS Paths_Prg ON Paths_Prg.PathID = Occurrences_Prg.PathID\n\t\tINNER JOIN Programs AS Programs_Children ON p.ProgramName = Programs_Children.Ancestor \n\t\t\tAND Programs_Children.ProgramTypeID IN (19)\n\t\tINNER JOIN Occurrences AS Occurrences_PrgChildren ON Occurrences_PrgChildren.OccurID = Programs_Children.OccurID\n\t\tINNER JOIN Paths AS Paths_PrgChildren ON Occurrences_PrgChildren.PathID = Paths_PrgChildren.PathID\n left join (\n select * from ( @@@@@EZLEGACY@@@@ ) AS det\n ) as m ON m.ProgramId = p.programid \n WHERE p.ProgramID in (select * from #tempids) ");
            spDetails.put(ResultElementType.SCL_VARIABLE.name(), "\n FROM StatementReference\n INNER JOIN OccurrencesStmt ON StatementReference.OccurID = OccurrencesStmt.OccurID\n INNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType\n INNER JOIN Paths AS Paths_Stmt ON OccurrencesStmt.PathID = Paths_Stmt.PathID\n RIGHT JOIN Variables ON StatementReference.ResourceID = Variables.VarID\n AND StatementReference.ResourceType = 4\n LEFT JOIN VarTypes ON Variables.Type = VarTypes.VarType\n INNER JOIN Occurrences AS Occurrences_Var ON Variables.OccurID = Occurrences_Var.OccurID\n INNER JOIN Paths AS Paths_Var ON Occurrences_Var.PathID = Paths_Var.PathID\n INNER JOIN (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p\n ON Variables.ProgIDReference = p.ProgramID\n left join ParagraphArguments ON Variables.VarID = ParagraphArguments.VariableId\n where p.ProgramId in (select * from #tempids) \n AND (@VarName = ''%''  OR VarName " + SCL_VARIABLE_LIKE_OR_IN_MARKER + ")");
            spDetails.put(this.getSpecificElementType().name(), "\n FROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p\n INNER JOIN Paragraphs ON p.ProgramID = Paragraphs.ProgramID\n INNER JOIN Occurrences AS Occurrences_Para ON Paragraphs.OccurID = Occurrences_Para.OccurID\n INNER JOIN Paths AS Paths_Para ON Occurrences_Para.PathID = Paths_Para.PathID\n left join SCLProcedureSynonyms ON Paragraphs.ParaName = SCLProcedureSynonyms.SCLProcedureName\n where p.ProgramID in (select * from #tempids)");
        }
        return spDetails;
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.SCL_HEADER_INFO;
        return res;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (spOrderBy == null || !spOrderBy.containsKey(this.getSpecificElementType().name())) {
            spOrderBy = new HashMap<String, String>();
            spOrderBy.put(ResultElementType.SCL_VARIABLE.name(), "varid");
            spOrderBy.put(ResultElementType.PROGRAM.name(), "ProgramName");
        }
        return spOrderBy;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(this.getSpecificElementType(), DatabaseMetadata.PARA_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.SCL_VARIABLE, DatabaseMetadata.VAR_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        HashMap<String, List<ColumnInfo>> csvHeader = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.STMT_TYPE.name(), list);
                list.add(DatabaseMetadata.STMT_DESC);
                list.add(DatabaseMetadata.STMT_START_ROW);
                list.add(DatabaseMetadata.STMT_START_COL);
                list.add(DatabaseMetadata.STMT_END_ROW);
                list.add(DatabaseMetadata.STMT_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.PROGRAM.name(), list);
                list.add(DatabaseMetadata.PRG_ID);
                list.add(DatabaseMetadata.PRG_NAME);
                list.add(DatabaseMetadata.PRG_TYPE_ID);
                list.add(DatabaseMetadata.PRG_PATH);
                list = new ArrayList();
                this.put(ResultElementType.SCL_VARIABLE.name(), list);
                list.add(DatabaseMetadata.VAR_ID);
                list.add(DatabaseMetadata.VAR_NAME);
                list.add(DatabaseMetadata.VAR_PATH_STR);
                list.add(DatabaseMetadata.VAR_START_ROW);
                list.add(DatabaseMetadata.VAR_START_COL);
                list.add(DatabaseMetadata.VAR_END_ROW);
                list.add(DatabaseMetadata.VAR_END_COL);
                list.add(DatabaseMetadata.IS_PARAMETER);
                list = new ArrayList();
                this.put(SCLDescriptor.this.getSpecificElementType().name(), list);
                list.add(DatabaseMetadata.PARA_ORDINAL);
                list.add(DatabaseMetadata.PARA_NAME);
            }
        };
        return csvHeader;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "Program_SCL";
    }

    @Override
    public int getDefaultExpandLevel() {
        int level = 3;
        if (this.hasManyProjects()) {
            level = 4;
        }
        return level;
    }

    @Override
    public boolean hasAnnotationsFilterAction() {
        return false;
    }
}

