/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.rank;

import com.ez.analysis.mainframe.usage.rank.DataProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreviousEntryDataProcessor
implements DataProcessor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String pre;
    private String post;
    private String separator;
    private Map<String, String> entryMap;
    private String entry;

    public static void main(String[] args) {
        HashMap<String, String> recordDataProcesorMap = new HashMap<String, String>();
        recordDataProcesorMap.put("1", "@1");
        recordDataProcesorMap.put("2", "@2");
        recordDataProcesorMap.put("3", "@3");
        recordDataProcesorMap.put("4", "@4");
        recordDataProcesorMap.put("5", "@5");
        recordDataProcesorMap.put("6", "@6");
        ArrayList<String> recordDataProcesor = new ArrayList<String>();
        recordDataProcesor.add("1");
        recordDataProcesor.add("3");
        recordDataProcesor.add("4");
        recordDataProcesor.add("5");
        PreviousEntryDataProcessor stringEntryDataProcessor = new PreviousEntryDataProcessor("pre ", " post", " AND ", "4", recordDataProcesorMap);
        System.out.println(stringEntryDataProcessor.process(recordDataProcesor));
    }

    public PreviousEntryDataProcessor(String pre, String post, String separator, String entry, Map<String, String> entryMap) {
        this.pre = pre;
        this.post = post;
        this.entry = entry;
        this.separator = separator;
        this.entryMap = entryMap;
    }

    public String getPre() {
        return this.pre;
    }

    public String getPost() {
        return this.post;
    }

    public Map<String, String> getDataProcesorMap() {
        return this.entryMap;
    }

    @Override
    public String process(List<String> order) {
        String retVal;
        if (!order.contains(this.entry) || order.size() == 0) {
            retVal = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            boolean appendSeparator = false;
            stringBuilder.append(this.pre);
            for (String e : order) {
                if (e.equals(this.entry)) break;
                if (!this.entryMap.containsKey(e)) continue;
                if (appendSeparator) {
                    stringBuilder.append(this.separator);
                }
                stringBuilder.append(this.entryMap.get(e));
                appendSeparator = true;
            }
            stringBuilder.append(this.post);
            retVal = stringBuilder.toString();
        }
        return retVal;
    }
}

