/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.rank;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.List;

public class IMSDBQueryBuilder
extends DenseRankQueryBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String COLUMNS = ":";
    public static final String DATABASE_PREFFIX = ResultElementType.IMSDB_DATABASE.getDisplayName().concat(":");
    public static final String TERMINAL_PREFFIX = ResultElementType.IMSDB_TERMINAL.getDisplayName().concat(":");
    private static final String CONDITION_PREFFIX = " AND (" + DatabaseMetadata.IMSDB_TERMINAL_OR_DATABASE.getName() + " = ";

    @Override
    protected String makeRestriction(List<FilterEntry> entries) {
        for (FilterEntry fe : entries) {
            String value;
            if (!fe.isEntryInUse() || !ResultElementType.IMSDB.name().equals(fe.get("filterEntryName")) || (value = fe.getValidAttribute(2)) == null) continue;
            if (value.startsWith(DATABASE_PREFFIX)) {
                return String.valueOf(CONDITION_PREFFIX) + 18 + ")";
            }
            if (!value.startsWith(TERMINAL_PREFFIX)) continue;
            return String.valueOf(CONDITION_PREFFIX) + 19 + ")";
        }
        return null;
    }
}

