/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.rank;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DataProcessor;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.ezsource.connection.ServerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenseRankQueryBuilder
extends AbstractQueryBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DenseRankQueryBuilder.class);
    private static final String SP_Query_END = "\nEND";
    private static final String SP_Open_Cursor = ";\nOPEN crs;";
    private static final String PRE_QUERY = "@@@@@PRE_QUERY@@@@";
    private static final String DENSE_RANK_CLAUSE = "@@@@DENSE_RANK@@@@";
    private static final String WHERE_LIKE_CLAUSE = "@@@@WHERE_LIKE@@@@";
    private static final String WHERE_ROW_NUMBER_LIMITS_CLAUSE = "@@@@WHERE_ROW_NMBER_LIMITS@@@@";
    private static final String ORDER_BY_CLAUSE = "@@@@ORDER_BY@@@@";
    private static final String COLUMN_LIST = "@@@@COLUMN_LIST@@@@";
    public static final String ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS = "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@";
    public static final String GROUP_FILTER_ADDITIONAL_CONDITIONS = "@@@@GROUP_CONDITIONS@@@@";
    public static final String DENSE_RANK_TABLE_NAME = "DENSE_RANK_TABLE";
    private static final String SP_Query_BEGIN = "\n AS BEGIN \nset nocount on \n@@@@@PRE_QUERY@@@@";
    private static final String SP_Query_BEGIN_DB2Z = "\nDYNAMIC RESULT SETS 1 \nLANGUAGE SQL \nBEGIN \n";
    private static final String SP_Query_BODY = "SELECT @@@@COLUMN_LIST@@@@\n FROM (\n\tSELECT @@@@COLUMN_LIST@@@@@@@@DENSE_RANK@@@@ \n\tFROM \n\t\t#temporary AS DENSE_RANK_TABLE \n\t@@@@WHERE_LIKE@@@@) AS X2 \n\t@@@@WHERE_ROW_NMBER_LIMITS@@@@ \n@@@@ORDER_BY@@@@";
    private static final String SP_Query_BODY_UNLIMITED = "SELECT @@@@COLUMN_LIST@@@@ \n\tFROM \n\t\t#temporary \n\t@@@@WHERE_LIKE@@@@ \n@@@@ORDER_BY@@@@";
    private static DenseRankQueryBuilder qb;

    public static DenseRankQueryBuilder getInstance() {
        if (qb == null) {
            qb = new DenseRankQueryBuilder();
        }
        return qb;
    }

    @Override
    protected String makeSPContent(UsageDescriptorAdapter descriptor, List<FilterEntry> entries, ServerType dbEngine) {
        if (descriptor instanceof DenseRankDescriptorAdapter) {
            return this.makeSPContent((DenseRankDescriptorAdapter)descriptor, entries, dbEngine);
        }
        throw new IllegalStateException("denseRankQueryBuild can work only with a descriptor instance of DenseRankDescriptorAdapter");
    }

    protected String makeSPContent(DenseRankDescriptorAdapter descriptor, List<FilterEntry> entries, final ServerType dbEngine) {
        String tableName;
        boolean cursorBlock;
        String preQuery = descriptor.getPreQuery();
        BiFunction<String, String, String> myReplace = new BiFunction<String, String, String>(){

            @Override
            public String apply(String k, String v) {
                return v.replaceAll("@", DenseRankQueryBuilder.this.replaceParamPrefixMarker(dbEngine, true));
            }
        };
        HashMap<String, String> spParam = new HashMap<String, String>(descriptor.getStoredProcedureParam());
        spParam.replaceAll(myReplace);
        Map<String, String> spWhereClause = descriptor.getStoredProcedureWhereClause();
        Map<String, String> spWhereRowLimits = descriptor.getStoredProcedureWhereRowLimitsClause();
        Map<String, String> spOrderBy = descriptor.getStoredProcedureOrderBy();
        Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatement = descriptor.getStoredProcedureDenseRankStatements();
        Map<String, DataProcessor> spDataProcessors = descriptor.getDataProcesorMap();
        boolean appendComma = false;
        StringBuilder strBuilder = new StringBuilder();
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            strBuilder.append("(");
        }
        for (FilterEntry e : entries) {
            String name = e.get("filterEntryName");
            if (!spParam.containsKey(name)) continue;
            if (appendComma && e.isEntryInUse()) {
                strBuilder.append(", ");
            }
            if (!e.isEntryInUse()) continue;
            strBuilder.append("\n\t" + (String)spParam.get(name));
            appendComma = true;
        }
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            strBuilder.append("\n )");
        }
        String sqlString = strBuilder.toString();
        String s = "";
        switch (dbEngine) {
            case SqlServer: {
                s = SP_Query_BEGIN.replace(PRE_QUERY, preQuery);
                break;
            }
            case Db2: 
            case Db2Z: {
                s = SP_Query_BEGIN_DB2Z;
                break;
            }
            default: {
                L.info("nothing special for dbEngine={}", (Object)dbEngine);
            }
        }
        String generateDropCacheTables = this.generateDropCacheTablesClause(0, spDenseRankStatement, dbEngine);
        String generatedCachingTables = this.generateCachingTables(descriptor, 0, entries, spDenseRankStatement, dbEngine);
        boolean bl = cursorBlock = generatedCachingTables != null && generatedCachingTables.length() > 0;
        if (cursorBlock) {
            s = String.valueOf(s) + generateDropCacheTables;
            s = String.valueOf(s) + "\n";
            s = String.valueOf(s) + generatedCachingTables;
        }
        sqlString = String.valueOf(sqlString) + s;
        sqlString = String.valueOf(sqlString) + "\n";
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            if (cursorBlock) {
                sqlString = String.valueOf(sqlString) + "BEGIN";
            }
            sqlString = String.valueOf(sqlString) + "\n DECLARE crs CURSOR WITH RETURN FOR \n" + PRE_QUERY.replace(PRE_QUERY, preQuery) + " \n";
        }
        strBuilder = new StringBuilder();
        String body = SP_Query_BODY_UNLIMITED;
        if (descriptor.isEnableLimits()) {
            body = SP_Query_BODY;
        }
        if ((tableName = descriptor.getPrepareCacheTable()) != null) {
            strBuilder.append(body.replace("#temporary", tableName));
        } else {
            strBuilder.append(body);
        }
        sqlString = String.valueOf(sqlString) + strBuilder.toString();
        sqlString = sqlString.replaceAll(COLUMN_LIST, this.generateColumnList(2, entries, descriptor, dbEngine));
        String generateWhereClause = this.generateWhereClause(descriptor, 2, entries, spWhereClause, spDenseRankStatement, true, dbEngine);
        String restriction = this.makeRestriction(entries);
        if (restriction != null) {
            if (generateWhereClause.length() == 0) {
                generateWhereClause = "WHERE\n";
            }
            generateWhereClause = String.valueOf(generateWhereClause) + restriction;
        }
        sqlString = sqlString.replaceAll(WHERE_LIKE_CLAUSE, generateWhereClause);
        sqlString = sqlString.replaceAll(WHERE_ROW_NUMBER_LIMITS_CLAUSE, this.generateWhereClause(descriptor, 1, entries, spWhereRowLimits, spDenseRankStatement, dbEngine));
        sqlString = sqlString.replaceAll(DENSE_RANK_CLAUSE, this.generateDenseRank(2, entries, spDenseRankStatement));
        sqlString = sqlString.replaceAll(ORDER_BY_CLAUSE, this.generateOrderByClause(2, entries, spOrderBy));
        sqlString = this.executeDataProcessors(sqlString, entries, spDataProcessors);
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            sqlString = String.valueOf(sqlString) + SP_Open_Cursor;
            if (cursorBlock) {
                sqlString = String.valueOf(sqlString) + "\nEND; \n";
            }
        }
        sqlString = String.valueOf(sqlString) + SP_Query_END;
        String procContent = this.replaceLikeOrIn(entries, sqlString.toString());
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            procContent = procContent.replaceAll("''", "'");
        }
        String paramPrefix = this.replaceParamPrefixMarker(dbEngine, false);
        procContent = procContent.replaceAll("@", paramPrefix);
        L.trace("stored procedure: " + procContent);
        return procContent;
    }

    private String replaceParamPrefixMarker(ServerType dbEngine, boolean create) {
        String paramPrefix = null;
        switch (dbEngine) {
            case SqlServer: {
                paramPrefix = "@";
                break;
            }
            case Db2: 
            case Db2Z: {
                paramPrefix = create ? "IN p_" : "p_";
                break;
            }
            default: {
                L.info("no parameter replacement for dbEngine={}", (Object)dbEngine);
            }
        }
        return paramPrefix;
    }

    protected String makeRestriction(List<FilterEntry> entries) {
        return null;
    }

    private String executeDataProcessors(String sqlString, List<FilterEntry> entries, Map<String, DataProcessor> spDataProcessors) {
        if (spDataProcessors != null) {
            ArrayList<String> filterEntryStringList = new ArrayList<String>();
            for (FilterEntry filterEntry : entries) {
                if (!filterEntry.isEntryInUse()) continue;
                filterEntryStringList.add(filterEntry.get("filterEntryName"));
            }
            for (Map.Entry entry : spDataProcessors.entrySet()) {
                String key = (String)entry.getKey();
                DataProcessor value = (DataProcessor)entry.getValue();
                sqlString = sqlString.replaceAll(key, value.process(filterEntryStringList));
            }
        }
        return sqlString;
    }

    private String generateColumnList(int tabNr, List<FilterEntry> entries, DenseRankDescriptorAdapter descriptor, ServerType dbEngine) {
        String tab = this.generateTabSpacing(tabNr);
        RowHeaderInfo header = descriptor.getRowHeaderInfo();
        StringBuilder sqlStrBuilder = new StringBuilder();
        boolean appendComma = false;
        String str = ",\n" + tab;
        for (ColumnInfo ci : header.getColumnInfo()) {
            boolean columnIsRequired = false;
            for (FilterEntry e : entries) {
                String column;
                if (!e.isEntryInUse() || (column = e.get(ci.getName())).equalsIgnoreCase("")) continue;
                if (appendComma) {
                    sqlStrBuilder.append(str);
                }
                sqlStrBuilder.append(column);
                appendComma = true;
                columnIsRequired = true;
                break;
            }
            if (columnIsRequired) continue;
            if (appendComma) {
                sqlStrBuilder.append(str);
            }
            switch (dbEngine) {
                case SqlServer: {
                    sqlStrBuilder.append("null AS " + ci.getName());
                    break;
                }
                case Db2: 
                case Db2Z: {
                    sqlStrBuilder.append("CAST(NULL AS VARCHAR(250)) AS " + ci.getName());
                }
                default: {
                    L.info("nothing at generatingColumns for dbEngine={}", (Object)dbEngine);
                }
            }
            appendComma = true;
        }
        return sqlStrBuilder.toString();
    }

    private String generateCachingTables(DenseRankDescriptorAdapter descriptor, int tabNr, List<FilterEntry> entries, Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatement, ServerType dbEngine) {
        String tab = this.generateTabSpacing(tabNr);
        StringBuilder strBuilder = new StringBuilder();
        LinkedList previousColumnNames = new LinkedList();
        int i = 0;
        while (i < entries.size()) {
            ArrayList<FilterEntry> filterEntryList = new ArrayList<FilterEntry>();
            FilterEntry e = entries.get(i);
            String name = e.get("filterEntryName");
            if (!e.isEntryInUse() || !spDenseRankStatement.containsKey(name)) {
                ++i;
                continue;
            }
            GroupFilterEntry groupFilterEntry = e.getGroupFilterEntry();
            do {
                if (!(e = entries.get(i)).isEntryInUse()) continue;
                filterEntryList.add(e);
            } while (groupFilterEntry != null && ++i < entries.size() && groupFilterEntry.equals(entries.get(i).getGroupFilterEntry()));
            HashSet<String> columnNamesToAdd = new HashSet<String>();
            for (FilterEntry e2 : filterEntryList) {
                DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement;
                String tempTableName;
                String entryNameToAdd;
                String name2 = entryNameToAdd = e2.get("filterEntryName");
                if (!columnNamesToAdd.contains(entryNameToAdd) && !previousColumnNames.contains(entryNameToAdd)) {
                    columnNamesToAdd.add(spDenseRankStatement.get(entryNameToAdd).getTableColumnName());
                }
                if ((tempTableName = (denseRankStatement = spDenseRankStatement.get(name2)).getTempTableName()) == null) continue;
                tempTableName = DenseRankQueryBuilder.toDBPlatformTemporaryPrefix(tempTableName, "#", dbEngine);
                StringBuilder stringBuilder2 = new StringBuilder();
                String createTable = new String();
                boolean appendComa = false;
                for (String previousEntryName : previousColumnNames) {
                    if (appendComa) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(previousEntryName);
                    appendComa = true;
                }
                Set<String> additionalColumns = denseRankStatement.getAdditionalColumns();
                if (additionalColumns != null) {
                    for (String additionalColumn : additionalColumns) {
                        if (appendComa) {
                            stringBuilder2.append(", ");
                        }
                        stringBuilder2.append(additionalColumn);
                        if (!columnNamesToAdd.contains(additionalColumn) && !previousColumnNames.contains(additionalColumn)) {
                            columnNamesToAdd.add(additionalColumn);
                        }
                        appendComa = true;
                    }
                }
                if (appendComa) {
                    stringBuilder2.append(", ");
                    appendComa = true;
                }
                String tableColumnName = denseRankStatement.getTableColumnName();
                stringBuilder2.append(tableColumnName);
                appendComa = true;
                String cacheTableAditionalCondition = denseRankStatement.getCacheTableAdditionalCondition();
                createTable = DenseRankQueryBuilder.createTempTable(tempTableName, stringBuilder2.toString(), descriptor.getPrepareCacheTable(), cacheTableAditionalCondition, dbEngine);
                if (createTable.length() == 0) continue;
                strBuilder.append("\n" + tab + createTable);
            }
            previousColumnNames.addAll(columnNamesToAdd);
        }
        if (strBuilder.length() > 0 && ServerType.Db2Z.equals((Object)dbEngine)) {
            strBuilder.insert(0, "\n BEGIN \n").append("\n END; \n");
        }
        return strBuilder.toString();
    }

    private String generateDropCacheTablesClause(int tabNr, Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatement, ServerType dbEngine) {
        String tab = this.generateTabSpacing(tabNr);
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> tableSet = new HashSet<String>();
        for (DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement : spDenseRankStatement.values()) {
            String tempTableName = denseRankStatement.getTempTableName();
            if (tempTableName == null || tempTableName.length() <= 0) continue;
            tableSet.add(DenseRankQueryBuilder.toDBPlatformTemporaryPrefix(tempTableName, "#", dbEngine));
            if (!ServerType.SqlServer.equals((Object)dbEngine)) continue;
            stringBuilder.append("\n" + tab + "IF OBJECT_ID(N''tempdb.." + tempTableName + "'', N''U'') IS NOT NULL drop table " + tempTableName);
        }
        if ((ServerType.Db2Z.equals((Object)dbEngine) || dbEngine.equals((Object)ServerType.Db2)) && tableSet.size() > 0) {
            String dropStr = this.dropDB2TemporaryTables(tableSet);
            stringBuilder.append(dropStr);
        }
        return stringBuilder.toString();
    }

    private String generateWhereClause(DenseRankDescriptorAdapter descriptor, int tabNr, List<FilterEntry> entries, Map<String, String> spWhereClause, Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatement, ServerType dbEngine) {
        return this.generateWhereClause(descriptor, tabNr, entries, spWhereClause, spDenseRankStatement, false, dbEngine);
    }

    private String generateWhereClause(DenseRankDescriptorAdapter descriptor, int tabNr, List<FilterEntry> entries, Map<String, String> spWhereClause, Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatement, boolean additionalConditions, ServerType dbEngine) {
        String tab = this.generateTabSpacing(tabNr);
        StringBuilder strBuilder = new StringBuilder();
        boolean appendAND = false;
        LinkedList<FilterEntry> previousEntries = new LinkedList<FilterEntry>();
        int i = 0;
        while (i < entries.size()) {
            ArrayList<FilterEntry> filterEntryList = new ArrayList<FilterEntry>();
            FilterEntry e = entries.get(i);
            String name = e.get("filterEntryName");
            if (!e.isEntryInUse() || !spWhereClause.containsKey(name)) {
                ++i;
                continue;
            }
            GroupFilterEntry groupFilterEntry = e.getGroupFilterEntry();
            do {
                if (!(e = entries.get(i)).isEntryInUse()) continue;
                filterEntryList.add(e);
            } while (groupFilterEntry != null && ++i < entries.size() && groupFilterEntry.equals(entries.get(i).getGroupFilterEntry()));
            if (appendAND) {
                strBuilder.append(" AND ");
            } else {
                appendAND = true;
            }
            if (filterEntryList.size() > 1) {
                strBuilder.append("(");
            }
            boolean appendOR = false;
            for (FilterEntry e2 : filterEntryList) {
                String name2 = e2.get("filterEntryName");
                if (spWhereClause.containsKey(name2)) {
                    if (appendOR) {
                        strBuilder.append(" OR ");
                    } else {
                        appendOR = true;
                    }
                    String clause = spWhereClause.get(name2);
                    if (clause.contains(GROUP_FILTER_ADDITIONAL_CONDITIONS)) {
                        String additionalEqualityConditions = this.computeAdditionalGroupConditions(descriptor, e2, previousEntries, spDenseRankStatement);
                        if (!additionalConditions || additionalEqualityConditions == null) {
                            additionalEqualityConditions = "";
                        }
                        clause = clause.replace(GROUP_FILTER_ADDITIONAL_CONDITIONS, additionalEqualityConditions);
                    }
                    strBuilder.append("\n" + tab + clause);
                }
                previousEntries.add(e2);
            }
            if (filterEntryList.size() <= 1) continue;
            strBuilder.append(")");
        }
        if (strBuilder.length() > 0) {
            strBuilder.insert(0, "WHERE\n");
        }
        return DenseRankQueryBuilder.toDBPlatformTemporaryPrefix(strBuilder.toString(), "#", dbEngine);
    }

    private String computeAdditionalGroupConditions(DenseRankDescriptorAdapter descriptor, FilterEntry currentFilterEntry, List<FilterEntry> previousFilterEntries, Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatement) {
        StringBuilder stringBuilder = null;
        GroupFilterEntry currentFilterEntryGroup = currentFilterEntry.getGroupFilterEntry();
        LinkedList filterEntry2List = new LinkedList();
        Object previousFilterEntryGroup = null;
        for (FilterEntry filterEntry : previousFilterEntries) {
            List<FilterEntry> filterEntry1List;
            GroupFilterEntry groupFilterEntry = filterEntry.getGroupFilterEntry();
            if (currentFilterEntryGroup == null || currentFilterEntryGroup.equals(groupFilterEntry)) continue;
            if (previousFilterEntryGroup != null && previousFilterEntryGroup.equals(groupFilterEntry)) {
                filterEntry1List = (List)filterEntry2List.getLast();
            } else {
                filterEntry1List = new LinkedList();
                filterEntry2List.add(filterEntry1List);
            }
            filterEntry1List.add(filterEntry);
            previousFilterEntryGroup = groupFilterEntry;
        }
        String currentName = currentFilterEntry.get("filterEntryName");
        DenseRankDescriptorAdapter.DenseRankStatement currentDenseRankStatement = spDenseRankStatement.get(currentName);
        for (FilterEntry filterEntry : currentFilterEntryGroup.getFilterEntries()) {
            if (filterEntry.equals(currentFilterEntry) || !filterEntry.isEntryInUse()) continue;
            String feName = filterEntry.get("filterEntryName");
            String clause = currentDenseRankStatement.getAdditionalGroupDependencies().get(feName);
            StringBuilder stringBuilder2 = null;
            if (filterEntry2List.size() <= 0) continue;
            stringBuilder2 = new StringBuilder();
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            for (List list : filterEntry2List) {
                stringBuilder2.append(" AND ");
                if (list.size() > 1) {
                    stringBuilder2.append("(");
                }
                boolean appendOr = false;
                for (FilterEntry filterEntry2 : list) {
                    if (appendOr) {
                        stringBuilder2.append(" OR ");
                    }
                    String name = filterEntry2.get("filterEntryName");
                    DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement = spDenseRankStatement.get(name);
                    String tableColumnName = denseRankStatement.getTableColumnName();
                    if (descriptor.isEnableLimits()) {
                        stringBuilder2.append("UPPER(DENSE_RANK_TABLE." + tableColumnName + ")=" + tableColumnName);
                    } else {
                        stringBuilder2.append(String.valueOf(descriptor.getPrepareCacheTable()) + "." + tableColumnName + "=" + tableColumnName);
                    }
                    appendOr = true;
                }
                if (list.size() <= 1) continue;
                stringBuilder2.append(")");
            }
            stringBuilder.append(clause.replaceAll(ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS, stringBuilder2.toString()));
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    private String generateOrderByClause(int tabNr, List<FilterEntry> entries, Map<String, String> spOrderBy) {
        String tab = this.generateTabSpacing(tabNr);
        StringBuilder strBuilder = new StringBuilder();
        boolean appendComma = false;
        HashSet<String> alreadyAdded = new HashSet<String>();
        for (FilterEntry e : entries) {
            String value;
            String name = e.get("filterEntryName");
            if (!spOrderBy.containsKey(name) || alreadyAdded.contains(value = spOrderBy.get(name))) continue;
            if (appendComma && e.isEntryInUse()) {
                strBuilder.append(", ");
            }
            if (!e.isEntryInUse()) continue;
            strBuilder.append(value);
            appendComma = true;
            alreadyAdded.add(value);
        }
        if (strBuilder.length() > 0) {
            strBuilder.insert(0, "ORDER BY \n" + tab);
        }
        return strBuilder.toString();
    }

    protected String generateDenseRank(int tabNr, List<FilterEntry> entries, Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spRowNumberLimitsClause) {
        String tab = this.generateTabSpacing(tabNr);
        StringBuilder strBuilder = new StringBuilder();
        LinkedList denseRankStatementListDeque = new LinkedList();
        HashSet<String> alreadSetTable = new HashSet<String>();
        HashMap grouptFilterEntryDenseRankStatementMap = new HashMap();
        Object previousFilterEntryGroup = null;
        for (FilterEntry filterEntry : entries) {
            List<DenseRankDescriptorAdapter.DenseRankStatement> denseRankStatementList;
            String name = filterEntry.get("filterEntryName");
            DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement = spRowNumberLimitsClause.get(name);
            if (!filterEntry.isEntryInUse() || !spRowNumberLimitsClause.containsKey(name) || filterEntry.getGroupFilterEntry() != null && alreadSetTable.contains(denseRankStatement.getTableColumnName())) continue;
            GroupFilterEntry groupFilterEntry = filterEntry.getGroupFilterEntry();
            if (previousFilterEntryGroup != null && previousFilterEntryGroup.equals(groupFilterEntry)) {
                denseRankStatementList = (List)grouptFilterEntryDenseRankStatementMap.get(groupFilterEntry);
            } else {
                denseRankStatementList = new ArrayList();
                denseRankStatementListDeque.add(denseRankStatementList);
                grouptFilterEntryDenseRankStatementMap.put(groupFilterEntry, denseRankStatementList);
            }
            denseRankStatementList.add(denseRankStatement);
            previousFilterEntryGroup = groupFilterEntry;
            alreadSetTable.add(denseRankStatement.getTableColumnName());
        }
        alreadSetTable = new HashSet();
        StringBuilder previous = new StringBuilder();
        LinkedHashSet<String> previousElementsToAdd = new LinkedHashSet<String>();
        for (List list : denseRankStatementListDeque) {
            for (DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement : list) {
                Collection<String> additionalParseByElements = denseRankStatement.getAdditionalParseByElements();
                String partitionBy = previous.toString();
                if (additionalParseByElements != null && additionalParseByElements.size() > 0) {
                    for (String element : additionalParseByElements) {
                        previousElementsToAdd.add(element);
                        partitionBy = String.valueOf(partitionBy) + (partitionBy.isEmpty() ? "" : ", ") + element;
                    }
                }
                for (DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement2 : list) {
                    String tableColumnName = denseRankStatement2.getTableColumnName();
                    if (tableColumnName.equals(denseRankStatement.getTableColumnName())) continue;
                    partitionBy = String.valueOf(partitionBy) + (partitionBy.isEmpty() ? "" : ", ") + tableColumnName;
                }
                partitionBy = partitionBy.isEmpty() ? partitionBy : "PARTITION BY " + partitionBy;
                String orderBy = "ORDER BY " + denseRankStatement.getTableColumnName();
                Collection<String> additionalOrderByElements = denseRankStatement.getAdditionalOrderByElements();
                String as = "AS " + denseRankStatement.getAsElement();
                strBuilder.append(", \n" + tab);
                strBuilder.append("DENSE_RANK()  OVER (" + partitionBy + " ").append(orderBy);
                if (additionalOrderByElements != null) {
                    for (String additionalOrderByElement : additionalOrderByElements) {
                        strBuilder.append(", " + additionalOrderByElement);
                    }
                    previousElementsToAdd.addAll(additionalOrderByElements);
                }
                strBuilder.append(") " + as);
                alreadSetTable.add(denseRankStatement.getTableColumnName());
                previousElementsToAdd.add(denseRankStatement.getTableColumnName());
            }
            previous = new StringBuilder();
            for (String string : previousElementsToAdd) {
                if (previous.length() != 0) {
                    previous.append(", ");
                }
                previous.append(string);
            }
        }
        return strBuilder.toString();
    }

    private String generateTabSpacing(int tabNr) {
        String tab = "";
        int i = 0;
        while (i < tabNr) {
            tab = tab.concat("\t");
            ++i;
        }
        return tab;
    }
}

