/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.rank;

import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DataProcessor;
import com.ez.workspace.analysis.EZAnalysisType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class DenseRankDescriptorAdapter
extends UsageDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private HashMap<String, String> spWhereRowLimits;
    private HashMap<String, String> orderBy;

    public DenseRankDescriptorAdapter(EZAnalysisType ezAnalysisType) {
        super(ezAnalysisType);
    }

    public abstract Map<String, DenseRankStatement> getStoredProcedureDenseRankStatements();

    public Map<String, String> getStoredProcedureWhereRowLimitsClause() {
        this.spWhereRowLimits = null;
        if (this.spWhereRowLimits == null) {
            this.spWhereRowLimits = new HashMap();
            Map<String, DenseRankStatement> denseRankStatementCollection = this.getStoredProcedureDenseRankStatements();
            for (Map.Entry<String, DenseRankStatement> denseRankStatementCollectionEntry : denseRankStatementCollection.entrySet()) {
                String key = denseRankStatementCollectionEntry.getKey();
                if (key == null) {
                    throw new IllegalStateException("null key");
                }
                DenseRankStatement value = denseRankStatementCollectionEntry.getValue();
                if (value == null) {
                    throw new IllegalStateException("null DenseRankStatement");
                }
                String whereRowLimitClause = String.valueOf(value.getAsElement()) + "<=" + value.getLimitParamName();
                String additionalCondition = value.getAdditionalCondition();
                if (additionalCondition != null && !additionalCondition.isEmpty()) {
                    whereRowLimitClause = "(" + whereRowLimitClause + " AND " + additionalCondition + ")";
                }
                this.spWhereRowLimits.put(key, whereRowLimitClause);
            }
        }
        return this.spWhereRowLimits;
    }

    @Override
    public String getDatabaseViewName() {
        return null;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (this.orderBy == null) {
            this.orderBy = new HashMap();
            Map<String, DenseRankStatement> denseRankStatementCollection = this.getStoredProcedureDenseRankStatements();
            for (Map.Entry<String, DenseRankStatement> denseRankStatementCollectionEntry : denseRankStatementCollection.entrySet()) {
                String key = denseRankStatementCollectionEntry.getKey();
                if (key == null) {
                    throw new IllegalStateException("null key");
                }
                DenseRankStatement value = denseRankStatementCollectionEntry.getValue();
                if (value == null) {
                    throw new IllegalStateException("null DenseRankStatement for key " + key);
                }
                this.orderBy.put(key, value.getOrderByExpr());
            }
        }
        return this.orderBy;
    }

    public String getPreQueryWhereClause() {
        return null;
    }

    public Map<String, DataProcessor> getDataProcesorMap() {
        return null;
    }

    protected String getPrepareCacheTable() {
        return "cache" + this.getDatabaseViewName();
    }

    protected String getPreQuery() {
        return "";
    }

    @Override
    protected boolean useCache() {
        return true;
    }

    public static class DenseRankStatement {
        private String tableColumnName;
        private String limitParamName;
        private String tempTableName;
        private String additionalCondition;
        private String cacheTableAdditionalCondition;
        private Set<String> additionalColumns;
        private Collection<String> additionalParseByElements;
        private Collection<String> additionalOrderByElements;
        private Map<String, String> additionalGroupDependencies;
        private String orderByExpr;

        private DenseRankStatement(String tableColumnName, String limitParamName, String additionalCondition, String tempTableName, String cacheTableAdditionalCondition, Collection<String> additionalParseByElements, Collection<String> additionalOrderByElements, Map<String, String> additionalGroupDependencies, Set<String> additionalColumns, String orderByExpression) {
            if (tableColumnName == null) {
                throw new IllegalArgumentException("tableColumnName must not be null");
            }
            if (limitParamName == null) {
                throw new IllegalArgumentException("paramName must not be null");
            }
            this.additionalCondition = additionalCondition;
            this.tableColumnName = tableColumnName;
            this.tempTableName = tempTableName;
            this.additionalParseByElements = additionalParseByElements;
            this.additionalOrderByElements = additionalOrderByElements;
            this.additionalGroupDependencies = additionalGroupDependencies;
            this.limitParamName = limitParamName;
            this.additionalColumns = additionalColumns;
            this.cacheTableAdditionalCondition = cacheTableAdditionalCondition;
            this.orderByExpr = orderByExpression;
        }

        public String getTempTableName() {
            return this.tempTableName;
        }

        public String getTableColumnName() {
            return this.tableColumnName;
        }

        public String getOrderByExpr() {
            return this.orderByExpr != null && !this.orderByExpr.isEmpty() ? this.orderByExpr : this.tableColumnName;
        }

        public String getAsElement() {
            String rowNr = String.valueOf(this.tableColumnName) + "RowNr";
            if (rowNr.contains(",")) {
                rowNr = rowNr.replace(",", "");
            }
            return rowNr;
        }

        public String getLimitParamName() {
            return this.limitParamName;
        }

        public String getAdditionalCondition() {
            return this.additionalCondition;
        }

        public String getCacheTableAdditionalCondition() {
            return this.cacheTableAdditionalCondition;
        }

        public Collection<String> getAdditionalParseByElements() {
            return this.additionalParseByElements;
        }

        public Collection<String> getAdditionalOrderByElements() {
            return this.additionalOrderByElements;
        }

        public Map<String, String> getAdditionalGroupDependencies() {
            return this.additionalGroupDependencies;
        }

        public Set<String> getAdditionalColumns() {
            return this.additionalColumns;
        }

        public String toString() {
            return "(tableColumnName=" + this.tableColumnName + ", additionalParseByElements=" + this.additionalParseByElements + ")";
        }

        public static class Builder {
            private String tableColumnName;
            private String limitParamName;
            private String tempTableName;
            private String additionalCondition;
            private String cacheTableAdditionalCondition;
            private Set<String> additionalColumns;
            private Collection<String> additionalParseByElements;
            private Collection<String> additionalOrderByElements;
            private Map<String, String> additionalGroupDependencies;
            private String orderByExpr;

            public Builder tableColumnName(String tableColumnName) {
                this.tableColumnName = tableColumnName;
                return this;
            }

            public Builder limitParamName(String limitParamName) {
                this.limitParamName = limitParamName;
                return this;
            }

            public Builder tempTableName(String tempTableName) {
                this.tempTableName = tempTableName;
                return this;
            }

            public Builder additionalCondition(String additionalCondition) {
                this.additionalCondition = additionalCondition;
                return this;
            }

            public Builder additionalCacheTableCondition(String additionalCacheTableCondition) {
                this.cacheTableAdditionalCondition = additionalCacheTableCondition;
                return this;
            }

            public Builder additionalColumns(Set<String> additionalColumns) {
                this.additionalColumns = additionalColumns;
                return this;
            }

            public Builder additionalParseByElements(Collection<String> additionalParseByElements) {
                this.additionalParseByElements = additionalParseByElements;
                return this;
            }

            public Builder additionalOrderByElements(Collection<String> additionalOrderByElements) {
                this.additionalOrderByElements = additionalOrderByElements;
                return this;
            }

            public Builder additionalGroupDependencies(Map<String, String> additionalGroupDependencies) {
                this.additionalGroupDependencies = additionalGroupDependencies;
                return this;
            }

            public DenseRankStatement create() {
                return new DenseRankStatement(this.tableColumnName, this.limitParamName, this.additionalCondition, this.tempTableName, this.cacheTableAdditionalCondition, this.additionalParseByElements, this.additionalOrderByElements, this.additionalGroupDependencies, this.additionalColumns, this.orderByExpr);
            }

            public Builder orderByExpr(String expr) {
                this.orderByExpr = expr;
                return this;
            }
        }
    }
}

