/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.queries;

import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.ezsource.connection.ServerType;
import java.util.List;

public class ProgramWithVariableQueryBuilder
extends AbstractQueryBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static ProgramWithVariableQueryBuilder qb;

    public static ProgramWithVariableQueryBuilder getInstance() {
        if (qb == null) {
            qb = new ProgramWithVariableQueryBuilder();
        }
        return qb;
    }

    @Override
    protected String makeSPContent(UsageDescriptorAdapter descriptor, List<FilterEntry> entries, ServerType dbEngine) {
        StringBuilder sqlStrBuilder = new StringBuilder();
        String from_where = "    FROM        (Select distinct p.ProgramId, p.ProgramName\n        FROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p  inner join Variables ON Variables.ProgIDReference = p.ProgramID\n        WHERE (ProgramTypeID = @PrgTypeID)\n        AND (p.OccurID <> 0)\n        AND (@Program = ''%'' OR ProgramName " + UsageDescriptorAdapter.PROGRAM_LIKE_OR_IN_MARKER + ") \n" + "        AND (@VarName = ''%'' OR VarName " + UsageDescriptorAdapter.VARIABLE_LIKE_OR_IN_MARKER + ")\n" + "        ) AS duplicateElim\n" + "    ORDER BY ProgramName";
        if (descriptor.isEnableLimits()) {
            sqlStrBuilder.append("@PrgTypeID INT, @PrgLimit INT, @Program VARCHAR(255), @VarName VARCHAR(64)\nAS SELECT top(@PrgLimit) ProgramID, ProgramName \n" + from_where);
        } else {
            sqlStrBuilder.append("@PrgTypeID INT, @PrgLimit INT, @Program VARCHAR(255), @VarName VARCHAR(64)\nAS SELECT ProgramID, ProgramName \n" + from_where);
        }
        return this.replaceLikeOrIn(entries, sqlStrBuilder.toString());
    }
}

