/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.queries;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.ColumnType;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.ezsource.connection.ServerType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramIdsIntersectionQueryBuilder
extends AbstractQueryBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramIdsIntersectionQueryBuilder.class);
    private static final String COMMA_STRING = ", ";
    private static final String SEMICOLON_STRING = ";";
    public static final String UNLIMITED = "query_unlimited";
    private static ProgramIdsIntersectionQueryBuilder qb;

    public static ProgramIdsIntersectionQueryBuilder getInstance() {
        if (qb == null) {
            qb = new ProgramIdsIntersectionQueryBuilder();
        }
        return qb;
    }

    @Override
    protected String makeSPContent(UsageDescriptorAdapter descriptor, List<FilterEntry> entries, ServerType dbEngine) {
        String name;
        String name2;
        StringBuilder sqlStrBuilder = new StringBuilder();
        Map<String, String> spParam = descriptor.getStoredProcedureParam();
        Map<String, String> spWhereClause = descriptor.getStoredProcedureWhereClause();
        Map<String, String> spSelectFinal = descriptor.getStoredProcedureDetailsSelect();
        Map<String, String> spOrderBy = descriptor.getStoredProcedureOrderBy();
        Map<String, String> spSelectPrgIds = ((BasicProgramDescriptor)descriptor).getStoredProcedureSelectProgramIDs();
        Map<String, ColumnInfo[]> tempTables = ((BasicProgramDescriptor)descriptor).getStoreProceduresTempTables();
        Map<String, String> additionalTempTables = ((BasicProgramDescriptor)descriptor).getStoreProceduresAditionalTempTable();
        boolean appendComma = false;
        StringBuilder paramString = new StringBuilder();
        StringBuilder paramDeclString = new StringBuilder();
        for (FilterEntry e : entries) {
            name2 = e.get("filterEntryName");
            if (!e.isEntryInUse()) continue;
            if (appendComma) {
                paramString.append(COMMA_STRING);
            }
            String paramName = spParam.get(name2);
            if (dbEngine.equals((Object)ServerType.SqlServer)) {
                this.paramDeclaration(paramDeclString, paramName.trim());
            }
            if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
                paramName = paramName.replace("@_", "IN p_");
            }
            paramString.append(paramName);
            appendComma = true;
        }
        this.addingSP_BEGIN_stmt(dbEngine, sqlStrBuilder, paramString, paramDeclString);
        this.temporaryTablesDeclaration(dbEngine, sqlStrBuilder, tempTables, additionalTempTables);
        for (FilterEntry e : entries) {
            name2 = e.get("filterEntryName");
            Object whereClause = spWhereClause.get(name2);
            if (!e.isEntryInUse() || whereClause == null) continue;
            whereClause = this.replaceMarkersOnInsertIntoTablesStmts(dbEngine, (String)whereClause, null);
            sqlStrBuilder.append("\n" + (String)whereClause);
        }
        appendComma = false;
        String select = null;
        int i = 0;
        for (FilterEntry e : entries) {
            String name3;
            String partialSelect;
            if (!e.isEntryInUse() || (partialSelect = spSelectPrgIds.get(name3 = e.get("filterEntryName"))) == null) continue;
            if (ResultElementType.PROGRAM.name().equals(name3)) {
                if (descriptor.isEnableLimits()) {
                    select = spSelectPrgIds.get(name3);
                    continue;
                }
                select = spSelectPrgIds.get(UNLIMITED.concat(name3));
                continue;
            }
            partialSelect = partialSelect.replaceFirst("ENTRY", "ENTRY" + ++i);
            if (appendComma) {
                partialSelect = COMMA_STRING + partialSelect;
            }
            select = select.replace("@@@@@EZLEGACY@@@@", String.valueOf(partialSelect) + "\n" + "@@@@@EZLEGACY@@@@");
            appendComma = true;
        }
        if (select != null) {
            if (i == 1) {
                select = select.replace(select.substring(select.indexOf("@@@@@EZLEGACY@@@@"), select.lastIndexOf("\n")), "");
            } else if (select.indexOf("AND ENTRY" + i) > 0) {
                select = select.replace(select.substring(select.indexOf("AND ENTRY" + i), select.lastIndexOf("\n")), "");
            }
            if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
                select = select.replace("SELECT_OR_INSERT_INTO", "\n INSERT INTO ");
                select = select.replace("SELECT_MARKER", "\n SELECT ProgramID ");
                select = String.valueOf(select) + "; \n COMMIT; \n";
            } else {
                select = select.replace("SELECT_OR_INSERT_INTO", "\n SELECT ProgramID INTO  ");
                select = select.replace("SELECT_MARKER", "");
            }
            select = select.replace("@@@@@EZLEGACY@@@@", "");
        }
        if (i == 0) {
            L.error("no information required(only program information)");
        } else {
            sqlStrBuilder.append(select);
        }
        sqlStrBuilder.append("\n");
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            sqlStrBuilder.append("BEGIN \n\n DECLARE crs CURSOR WITH RETURN FOR");
        }
        boolean appendUNION = false;
        StringBuilder tempStrBuilder = new StringBuilder();
        String programClause = null;
        FilterEntry programEntry = null;
        for (FilterEntry e : entries) {
            name = e.get("filterEntryName");
            String clause = spSelectFinal.get(name);
            if (clause == null || !e.isEntryInUse()) continue;
            if (name.equals(ResultElementType.PROGRAM.name())) {
                programClause = clause.replaceFirst("@@@@@EZLEGACY@@@@", this.addAllColumnNames(e, descriptor).replaceAll("\n", "\n     ")).replaceAll("\n ", "\n");
                programEntry = e;
                continue;
            }
            if (appendUNION && e.isEntryInUse()) {
                tempStrBuilder.append("\n UNION ");
            }
            tempStrBuilder.append("\n SELECT \n     p.ProgramId, \n     ");
            tempStrBuilder.append(this.addColumnNames(e, programEntry, descriptor, dbEngine).replaceAll("\n", "\n     "));
            tempStrBuilder.append(clause);
            appendUNION = true;
        }
        if (programClause != null) {
            programClause = programClause.replace("@@@@@EZLEGACY@@@@", tempStrBuilder.toString().replaceAll("\n ", "\n            "));
            sqlStrBuilder.append(programClause);
        }
        appendComma = false;
        sqlStrBuilder.append("\nORDER BY ");
        for (FilterEntry e : entries) {
            name = e.get("filterEntryName");
            if (!e.isEntryInUse() || ResultElementType.ASSEMBLER_ENTRY.name().equals(name) || spOrderBy.get(name) == null) continue;
            if (appendComma) {
                sqlStrBuilder.append(COMMA_STRING);
            }
            sqlStrBuilder.append(spOrderBy.get(name));
            appendComma = true;
        }
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            sqlStrBuilder.append(";\nOPEN crs;");
            sqlStrBuilder.append("\nEND;");
            sqlStrBuilder.append("\nEND;");
        }
        sqlStrBuilder.append("\nEND");
        L.trace("stored procedure: " + sqlStrBuilder);
        String queryTemplate = sqlStrBuilder.toString();
        queryTemplate = this.replaceLikeOrIn(entries, queryTemplate);
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            queryTemplate = queryTemplate.replaceAll("''", "'");
            queryTemplate = queryTemplate.replaceAll("@", "p_");
            queryTemplate = queryTemplate.replaceAll("#", "SESSION.");
        }
        return queryTemplate;
    }

    private void temporaryTablesDeclaration(ServerType dbEngine, StringBuilder sqlStrBuilder, Map<String, ColumnInfo[]> tempTables, Map<String, String> additionalTempTables) {
        if (tempTables != null && dbEngine.equals((Object)ServerType.Db2Z)) {
            String droptempTablesStmt = this.dropDB2TemporaryTables(tempTables.keySet());
            sqlStrBuilder.append(droptempTablesStmt);
        }
        if (tempTables != null && (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2))) {
            sqlStrBuilder.append("\n BEGIN \n");
            String createTempTablesStmt = this.createDB2TemporaryTables(dbEngine, tempTables);
            sqlStrBuilder.append(createTempTablesStmt);
        }
        if (additionalTempTables != null) {
            for (String table : additionalTempTables.keySet()) {
                String additionalTempTable = additionalTempTables.get(table);
                additionalTempTable = this.replaceMarkersOnInsertIntoTablesStmts(dbEngine, additionalTempTable, tempTables.get(table));
                sqlStrBuilder.append(additionalTempTable);
            }
        }
    }

    private String replaceMarkersOnInsertIntoTablesStmts(ServerType dbEngine, String stmt, ColumnInfo[] cols) {
        if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
            String params = "";
            if (cols != null && cols.length > 0) {
                int i = cols.length;
                ColumnInfo[] columnInfoArray = cols;
                int n = cols.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnInfo ci = columnInfoArray[n2];
                    params = String.valueOf(params) + ci.getName();
                    if (--i > 0) {
                        params = String.valueOf(params) + ",";
                    }
                    ++n2;
                }
            } else {
                params = "*";
            }
            stmt = stmt.replace("SELECT_OR_INSERT_INTO", "\n INSERT INTO ");
            stmt = stmt.replace("SELECT_MARKER", "\n SELECT " + params);
            stmt = stmt.replace("@@@@@EZLEGACY@@@@", "; \n COMMIT; \n");
        } else {
            stmt = stmt.replace("SELECT_OR_INSERT_INTO", "\n SELECT * INTO  ");
            stmt = stmt.replace("@@@@@EZLEGACY@@@@", "\n");
            stmt = stmt.replace("SELECT_MARKER", "");
        }
        return stmt;
    }

    private void addingSP_BEGIN_stmt(ServerType dbEngine, StringBuilder sqlStrBuilder, StringBuilder paramString, StringBuilder paramDeclString) {
        switch (dbEngine) {
            case Db2: 
            case Db2Z: {
                String SP_Query_BEGIN_DB2Z = "\n (\n" + paramString + "\n )" + "\n DYNAMIC RESULT SETS 1 \n" + "\n CALLED ON NULL INPUT " + "\n LANGUAGE SQL \n" + "\n ss: BEGIN \n";
                sqlStrBuilder.append(SP_Query_BEGIN_DB2Z);
                break;
            }
            default: {
                String SP_Query_BEGIN = paramString + "\nAS " + paramDeclString.toString().trim() + "\nBEGIN " + "\nset nocount on \n";
                sqlStrBuilder.append(SP_Query_BEGIN);
            }
        }
    }

    private void paramDeclaration(StringBuilder paramDeclString, String paramName) {
        if (paramName.contains(COMMA_STRING)) {
            String[] params;
            String[] stringArray = params = paramName.split(COMMA_STRING);
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                param = param.trim();
                String paraDeclMember = param.replace("@_", "@");
                paramDeclString.append("\ndeclare " + paraDeclMember + " = " + param.substring(0, param.indexOf(" ")));
                ++n2;
            }
        } else {
            String paraDeclMember = paramName.replace("@_", "@");
            paramDeclString.append("\ndeclare " + paraDeclMember + " = " + paramName.substring(0, paramName.indexOf(" ")));
        }
    }

    private String addAllColumnNames(FilterEntry e, UsageDescriptorAdapter descriptor) {
        StringBuilder colNamesStrBuilder = new StringBuilder();
        RowHeaderInfo header = descriptor.getRowHeaderInfo();
        boolean appendComma = false;
        String str = ", \n";
        for (ColumnInfo ci : header.getColumnInfo()) {
            String col;
            if (ci == null) continue;
            if (appendComma) {
                colNamesStrBuilder.append(str);
            }
            if ((col = e.get(ci.getName())) == "") {
                col = "null";
            }
            appendComma = true;
            if (col.equalsIgnoreCase("null")) {
                colNamesStrBuilder.append(ci.getName());
                continue;
            }
            colNamesStrBuilder.append(col);
            colNamesStrBuilder.append(" AS ");
            colNamesStrBuilder.append(ci.getName());
        }
        if (colNamesStrBuilder.lastIndexOf(str) == colNamesStrBuilder.length() - str.length()) {
            return colNamesStrBuilder.substring(0, colNamesStrBuilder.lastIndexOf(str));
        }
        return colNamesStrBuilder.toString();
    }

    private String addColumnNames(FilterEntry e, FilterEntry toExcludeEntry, UsageDescriptorAdapter descriptor, ServerType dbEngine) {
        StringBuilder colNamesStrBuilder = new StringBuilder();
        RowHeaderInfo header = descriptor.getRowHeaderInfo();
        String castNull = "CAST(NULL AS ";
        boolean appendComma = false;
        String str = ", \n";
        for (ColumnInfo ci : header.getColumnInfo()) {
            String typeAsStr;
            String col;
            if (ci == null || toExcludeEntry != null && !toExcludeEntry.get(ci.getName()).isEmpty()) continue;
            if (appendComma) {
                colNamesStrBuilder.append(str);
            }
            if ((col = e.get(ci.getName())) == "") {
                col = "null";
            }
            if (col.toUpperCase().contains("NULL") && (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2))) {
                typeAsStr = ci.getType().equals((Object)ColumnType.String) ? "VARCHAR(256)" : ci.getType().toString();
                col = col.toUpperCase();
                col = col.replace("NULL", String.valueOf(castNull) + typeAsStr + ")");
            }
            appendComma = true;
            if (col.equalsIgnoreCase("null")) {
                if (dbEngine.equals((Object)ServerType.Db2Z) || dbEngine.equals((Object)ServerType.Db2)) {
                    typeAsStr = ci.getType().equals((Object)ColumnType.String) ? "VARCHAR(256)" : ci.getType().toString();
                    col = String.valueOf(castNull) + typeAsStr + ") AS ";
                    colNamesStrBuilder.append(col);
                } else {
                    colNamesStrBuilder.append("null AS ");
                }
                colNamesStrBuilder.append(ci.getName());
                continue;
            }
            colNamesStrBuilder.append(col);
            colNamesStrBuilder.append(" AS ");
            colNamesStrBuilder.append(ci.getName());
        }
        if (colNamesStrBuilder.lastIndexOf(str) == colNamesStrBuilder.length() - str.length()) {
            return colNamesStrBuilder.substring(0, colNamesStrBuilder.lastIndexOf(str));
        }
        return colNamesStrBuilder.toString();
    }
}

