/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.queries;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.ColumnType;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractQueryBuilder.class);
    public static final String MARKER = "@@@@@EZLEGACY@@@@";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String CREATE_PROCEDURE_TEMPLATE = "IF ( OBJECT_ID('@@@@@EZLEGACY@@@@') IS NULL) \nEXEC( 'CREATE PROCEDURE [@@@@@EZLEGACY@@@@] ";
    private static final String CREATE_PROCEDURE_TEMPLATE_DB2Z = "CREATE PROCEDURE @@@@@EZLEGACY@@@@ ";
    public static final String TEMPORARY_TABLE_NAME = "#temporary";
    public static final String LIKE_OR_IN_MARKER = "LIKE_OR_IN";
    public static final String LIKE_OR_IN_MARKER_SECOND = "LIKE_OR_IN_SECOND";
    public static final String INSERT_MARKER = "SELECT_OR_INSERT_INTO";
    public static final String SELECT_MARKER = "SELECT_MARKER";
    public static final String TEMP_SQL_SERVER_PREFIX = "#";
    public static final String TEMP_DB2Z_PREFIX = "SESSION.";
    protected static final String DECLARE_CURSOR = "\n DECLARE crs CURSOR WITH RETURN FOR";
    public static final char DEFAULT_ESCAPE_DB_CHAR = '\\';
    protected static final String SP_Query_END = "\nEND";
    protected static final String SP_Open_Cursor = ";\nOPEN crs;";

    public static String[] getLIKE_OR_IN(ServerType dbEngine) {
        String tblName = Utils.getTempTableName((ServerType)dbEngine, (String)"string_param_temp_x");
        return new String[]{"LIKE ", "IN (Select * from " + tblName + ")"};
    }

    protected AbstractQueryBuilder() {
    }

    public Pair<String, String> makeSP(UsageDescriptorAdapter descriptor, ProjectInfo pInfo, List<FilterEntry> entries) {
        ServerType dbEngine = ServerType.findByValue((int)((Integer)pInfo.getInfo().get("dbEngine")));
        String spContent = this.makeSPContent(descriptor, entries, dbEngine);
        String spName = String.valueOf(descriptor.getProcedurePrefix()) + this.generateHashCode(spContent);
        String spText = null;
        String s = null;
        switch (dbEngine) {
            case SqlServer: {
                s = CREATE_PROCEDURE_TEMPLATE.replaceAll(MARKER, spName);
                break;
            }
            case Db2: 
            case Db2Z: {
                s = CREATE_PROCEDURE_TEMPLATE_DB2Z.replaceAll(MARKER, spName);
                break;
            }
            default: {
                L.info("nothing at CreateProcedure for dbEngine={}", (Object)dbEngine);
            }
        }
        StringBuilder sqlStrBuilder = new StringBuilder(s);
        sqlStrBuilder.replace(0, sqlStrBuilder.length(), s);
        sqlStrBuilder.append(spContent);
        if (dbEngine.equals((Object)ServerType.SqlServer)) {
            sqlStrBuilder.append("') ");
        }
        spText = sqlStrBuilder.toString();
        return new Pair((Object)spName, (Object)spText);
    }

    public static String getEscapeDBClause(char escapeDBChar) {
        return " ESCAPE ''" + Utils.escapeAdapt((char)escapeDBChar) + "''";
    }

    protected String replaceLikeOrIn(List<FilterEntry> entries, String queryTemplate) {
        String escapeClause = AbstractQueryBuilder.getEscapeDBClause('\\');
        for (FilterEntry e : entries) {
            String name = e.get("filterEntryName");
            if (!e.isEntryInUse()) continue;
            String toReplace = FilterData.getResElemTypeMarker(name, new String[0]);
            String like_or_in = e.get(LIKE_OR_IN_MARKER) != null ? e.get(LIKE_OR_IN_MARKER) : "";
            queryTemplate = queryTemplate.replaceAll(toReplace, like_or_in.toUpperCase().startsWith("LIKE") ? String.valueOf(like_or_in) + escapeClause : like_or_in);
            toReplace = FilterData.getResElemTypeMarker(name, LIKE_OR_IN_MARKER_SECOND);
            like_or_in = e.get(LIKE_OR_IN_MARKER_SECOND) != null ? e.get(LIKE_OR_IN_MARKER_SECOND) : "";
            queryTemplate = queryTemplate.replaceAll(toReplace, like_or_in.toUpperCase().startsWith("LIKE") ? String.valueOf(like_or_in) + escapeClause : like_or_in);
        }
        return queryTemplate;
    }

    private String generateHashCode(String spContent) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] array;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] byArray = array = md.digest(spContent.getBytes());
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(this.byteToHex(b));
                ++n2;
            }
        }
        catch (NoSuchAlgorithmException e) {
            L.error("error when try to obtain MD5 instance" + e);
            throw new RuntimeException("" + e);
        }
        return sb.toString();
    }

    protected abstract String makeSPContent(UsageDescriptorAdapter var1, List<FilterEntry> var2, ServerType var3);

    private String byteToHex(byte b) {
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public String getFilterValueProcessor() {
        return null;
    }

    protected String createDB2TemporaryTables(ServerType dbEngine, Map<String, ColumnInfo[]> tempTables) {
        String tempHeader = "";
        for (String tableName : tempTables.keySet()) {
            ColumnInfo[] args = tempTables.get(tableName);
            if (args == null) continue;
            tempHeader = String.valueOf(tempHeader) + "\n DECLARE GLOBAL TEMPORARY TABLE " + tableName + "( ";
            int i = args.length;
            ColumnInfo[] columnInfoArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo arg = columnInfoArray[n2];
                tempHeader = String.valueOf(tempHeader) + "\n" + arg.getName();
                tempHeader = arg.getType().equals((Object)ColumnType.String) ? String.valueOf(tempHeader) + " VARCHAR(256)" : String.valueOf(tempHeader) + "\t" + arg.getType().toString().toUpperCase();
                if (--i > 0) {
                    tempHeader = String.valueOf(tempHeader) + ",";
                }
                ++n2;
            }
            if (dbEngine.equals((Object)ServerType.Db2Z)) {
                tempHeader = String.valueOf(tempHeader) + "\n )  ON COMMIT PRESERVE ROWS NOT LOGGED ;\n";
                continue;
            }
            if (!dbEngine.equals((Object)ServerType.Db2)) continue;
            tempHeader = String.valueOf(tempHeader) + "\n )  WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ;\n";
        }
        return tempHeader;
    }

    protected String dropDB2TemporaryTables(Set<String> tempTables) {
        String dropStmt = "\n BEGIN\n DECLARE CONTINUE HANDLER FOR SQLSTATE '42704'\n BEGIN END;\n COMMIT;";
        int i = tempTables.size();
        for (String tmptable : tempTables) {
            dropStmt = String.valueOf(dropStmt) + "\n DROP TABLE " + tmptable;
            if (i > 0) {
                dropStmt = String.valueOf(dropStmt) + ";";
            }
            --i;
        }
        dropStmt = String.valueOf(dropStmt) + "\n END; \n";
        return dropStmt;
    }

    protected static String createTempTable(String tempTableName, String tempTableColList, String fromTableName, String whereCond, ServerType dbEngine) {
        String createStmt = "";
        String whereClause = whereCond != null && !whereCond.isEmpty() ? " WHERE " + whereCond : "";
        CharSequence[] cols = null;
        switch (dbEngine) {
            case SqlServer: {
                createStmt = "SELECT " + tempTableColList + " INTO " + tempTableName + " FROM " + fromTableName + whereClause + "\n";
                break;
            }
            case Db2Z: {
                createStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTableName + " AS ( SELECT " + tempTableColList + " FROM " + fromTableName + ") " + "\n DEFINITION ONLY\n USING TYPE DEFAULTS\n " + " ON COMMIT PRESERVE ROWS NOT LOGGED " + ";\n\n";
                cols = tempTableColList.split(",");
                int i = 0;
                while (i < cols.length) {
                    cols[i] = "UPPER(" + cols[i] + ")";
                    ++i;
                }
                createStmt = String.valueOf(createStmt) + " INSERT INTO " + tempTableName + " SELECT " + String.join((CharSequence)",", cols) + " FROM " + fromTableName + whereClause + ";\n";
                break;
            }
            case Db2: {
                createStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTableName + " AS ( SELECT " + tempTableColList + " FROM " + fromTableName + ") " + "\n DEFINITION ONLY\n INCLUDING COLUMN DEFAULTS\n " + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED " + ";\n\n";
                cols = tempTableColList.split(",");
                int i = 0;
                while (i < cols.length) {
                    cols[i] = "UPPER(" + cols[i] + ")";
                    ++i;
                }
                createStmt = String.valueOf(createStmt) + " INSERT INTO " + tempTableName + " SELECT " + String.join((CharSequence)",", cols) + " FROM " + fromTableName + whereClause + ";\n";
                break;
            }
            default: {
                L.info("nothing at creating temp table for dbEngine={}", (Object)dbEngine);
            }
        }
        return createStmt;
    }

    protected static String toDBPlatformTemporaryPrefix(String statement, String prefix, ServerType dbEngine) {
        if (statement == null) {
            return null;
        }
        String newStmt = new String(statement);
        switch (dbEngine) {
            case SqlServer: {
                newStmt.replaceAll(prefix, TEMP_SQL_SERVER_PREFIX);
                break;
            }
            case Db2: 
            case Db2Z: {
                newStmt = newStmt.replaceAll(prefix, TEMP_DB2Z_PREFIX);
                break;
            }
            default: {
                L.info("nothing at toDBPlatformTemporaryPrefix() for dbEngine={}", (Object)dbEngine);
            }
        }
        return newStmt;
    }
}

