/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.programs.BasicProgramTreeProvider;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.VariableUsageNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramVarTreeProvider
extends BasicProgramTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Logger L = LoggerFactory.getLogger(ProgramVarTreeProvider.class);

    public ProgramVarTreeProvider(BasicProgramDescriptor descriptor) {
        super(descriptor);
    }

    protected ResultElement processVariable(Map<String, ResultElement> variablesMap, Row r, ResultElement parent, String name, ProjectInfo projectInfo) {
        Integer varID;
        String projectName = projectInfo.getName();
        String varKey = Utils.getKeyForVariable(projectName, varID = (Integer)r.getColumnValue(DatabaseMetadata.VAR_ID.getName()));
        ResultElement resultElement = variablesMap.get(varKey);
        if (resultElement == null) {
            Integer varLevel = (Integer)r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName());
            Integer headFather = (Integer)r.getColumnValue(DatabaseMetadata.VAR_Father.getName());
            ResultElement varParent = variablesMap.get(Utils.getKeyForVariable(projectName, headFather));
            if (varParent != null && headFather != 0) {
                parent = varParent;
            }
            parent = this.addVarSectionType(variablesMap, r, parent, projectInfo);
            resultElement = new ResultElement(name, ResultElementType.VARIABLE, parent);
            variablesMap.put(varKey, resultElement);
            resultElement.addProperty(DatabaseMetadata.VAR_iLevel.getName(), varLevel);
            resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), varID);
            String key = varID.toString().concat(name);
            parent.addChild(key, resultElement);
            this.addElementInfo(resultElement, r);
            Utils.completeProjectInfo(resultElement, projectInfo);
        }
        return resultElement;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean hasLevelCategory(ResultElementType levelElementType) {
        return levelElementType.equals((Object)ResultElementType.STMT_TYPE) || levelElementType.equals((Object)ResultElementType.VARIABLE);
    }

    @Override
    protected void addElementInfo(ResultElement resultElement, Row r) {
        if (resultElement.getProperty("FILE") != null || resultElement.getProperty("ProjectInfo") != null) {
            return;
        }
        ResultElementType type = resultElement.getType();
        if (ResultElementType.PROGRAM.equals((Object)type)) {
            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
            resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
            resultElement.addProperty("Program Type Id", this.programTypeId);
            if (r.hasColumn(DatabaseMetadata.PRG_ANCESTOR.getName())) {
                resultElement.addProperty("Ancestor Name", r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
            }
            String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
            resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
            String programName = (String)r.getColumnValue(DatabaseMetadata.PRG_NAME.getName());
            Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
            Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
            Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
            Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
            String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(this.programTypeId));
            ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (ResultElementType.STMT_SOURCE_INFO.equals((Object)type)) {
            resultElement.addProperty("Program Type Id", this.programTypeId);
            String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
            resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
            String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(this.programTypeId));
            String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
            resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
            resultElement.addProperty("Stmt Start Row", startRow);
            Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), stmtPath, startRow, startCol);
        } else if (ResultElementType.PROJECT_INFO.equals((Object)type)) {
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (ResultElementType.VARIABLE.equals((Object)type)) {
            String varPath = (String)r.getColumnValue(DatabaseMetadata.VAR_PATH_STR.getName());
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName());
            Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_COL.getName());
            Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_END_ROW.getName());
            Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.VAR_END_COL.getName());
            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
            resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
            resultElement.addProperty("Program Type Id", this.programTypeId);
            String prgName = (String)r.getColumnValue(DatabaseMetadata.PRG_NAME.getName());
            resultElement.addProperty("Program name", prgName);
            Integer varIsCopy = (Integer)r.getColumnValue(DatabaseMetadata.VAR_IS_COPY.getName());
            resultElement.addProperty("VarIsInclude", varIsCopy != 0);
            resultElement.addProperty(DatabaseMetadata.PRG_TYPE_ID.getName(), r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_ID.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_IsField.getName(), r.getColumnValue(DatabaseMetadata.VAR_IsField.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_IsFiller.getName(), r.getColumnValue(DatabaseMetadata.VAR_IsFiller.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_PIC.getName(), r.getColumnValue(DatabaseMetadata.VAR_PIC.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_START_ROW.getName(), r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_ANCESTOR.getName(), r.getColumnValue(DatabaseMetadata.VAR_ANCESTOR.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_PRG_REF_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_PRG_REF_ID.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_TYPE_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_TYPE_ID.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_Father.getName(), r.getColumnValue(DatabaseMetadata.VAR_Father.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_IS_COPY.getName(), varIsCopy);
            VariableUsageNode prgNodeQueue = new VariableUsageNode(resultElement.getName(), r.getColumnValue(DatabaseMetadata.VAR_PIC.getName()), r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName()), r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName()), r.getColumnValue(DatabaseMetadata.VAR_Ancestor_Name.getName()), r.getColumnValue(DatabaseMetadata.VAR_Father_Name.getName()), r.getColumnValue(DatabaseMetadata.VAR_IsFiller.getName()));
            resultElement.addProperty("Node_Mainframe", prgNodeQueue);
            if (r.hasColumn(DatabaseMetadata.VAR_VISIBILITY.getName())) {
                Integer globalVal = (Integer)r.getColumnValue(DatabaseMetadata.VAR_VISIBILITY.getName());
                boolean isGlobal = globalVal != null && globalVal == 1;
                prgNodeQueue.setGlobal(isGlobal);
            }
            if (this.hasSectionType()) {
                resultElement.addProperty(DatabaseMetadata.VAR_SECTION_TYPE.getName(), r.getColumnValue(DatabaseMetadata.VAR_SECTION_TYPE.getName()));
            }
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), varPath, startRow, startCol, endRow, endCol);
        }
    }

    @Override
    protected void addSpecificElementInfo(ResultElement resultElement, Row r) {
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    protected ResultElement addVarSectionType(Map<String, ResultElement> variablesMap, Row r, ResultElement parent, ProjectInfo projectInfo) {
        ResultElement resultElement;
        String sectionType = (String)r.getColumnValue(DatabaseMetadata.VAR_SECTION_TYPE.getName());
        Integer cfr_ignored_0 = (Integer)r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName());
        if (!this.hasSectionType() || parent.getType().equals((Object)ResultElementType.VARIABLE)) {
            resultElement = parent;
        } else if (this.hasSectionType() && sectionType == null) {
            this.L.warn("NULL section type for variable " + (String)r.getColumnValue(DatabaseMetadata.VAR_NAME.getName()));
            resultElement = parent;
        } else {
            if (parent.getChildren() == null || (resultElement = (ResultElement)((Object)parent.getChildren().get(sectionType))) == null) {
                resultElement = new ResultElement(sectionType, ResultElementType.VARIABLE_SECTION_TYPE, parent);
                this.addElementInfo(resultElement, r);
            }
            resultElement.addProperty(DatabaseMetadata.PRG_TYPE_ID.getName(), r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_ID.getName()));
            resultElement.addProperty(DatabaseMetadata.VAR_SECTION_TYPE.getName(), r.getColumnValue(DatabaseMetadata.VAR_SECTION_TYPE.getName()));
            parent.addChild(sectionType, resultElement);
        }
        return resultElement;
    }

    protected boolean hasSectionType() {
        return 1 == this.programTypeId;
    }

    protected class MyCallback
    extends AbstractProcessRowCallback {
        Map<String, ResultElement> variablesMap;
        private boolean displayStmt;

        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.variablesMap = new HashMap<String, ResultElement>();
            this.displayStmt = true;
        }

        public void setDisplayStmt(boolean displayStmt) {
            this.displayStmt = displayStmt;
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (ProgramVarTreeProvider.this.isElementValidForCreation(name, levelElementType, r)) {
                        String key = name;
                        if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                            String projectName = projectInfo.getName();
                            Integer prgID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                            key = Utils.getKeyForVariable(key, Utils.getKeyForVariable(projectName, prgID));
                        }
                        if (ProgramVarTreeProvider.this.hasLevelCategory(levelElementType)) {
                            String categoryName = null;
                            if (levelElementType.equals((Object)ResultElementType.STMT_TYPE)) {
                                Integer bRead = (Integer)r.getColumnValue(DatabaseMetadata.STMT_bREAD.getName());
                                categoryName = Utils.readOrWriteStmt(bRead);
                            }
                            if (!levelElementType.equals((Object)ResultElementType.VARIABLE)) {
                                parent = Utils.getCategory(levelElementType, parent, categoryName);
                            }
                        }
                        ResultElement resultElement = null;
                        if (levelElementType.equals((Object)ResultElementType.VARIABLE)) {
                            resultElement = ProgramVarTreeProvider.this.processVariable(this.variablesMap, r, parent, name, projectInfo);
                        } else {
                            resultElement = parent.getChild(key);
                            if (resultElement == null) {
                                resultElement = new ResultElement(name, levelElementType, parent);
                                ProgramVarTreeProvider.this.addElementInfo(resultElement, r);
                                parent.addChild(key, resultElement);
                                Utils.completeProjectInfo(resultElement, projectInfo);
                            }
                        }
                        ProgramVarTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                    }
                } else if (this.displayStmt && levelIndex == this.levelsOrder.size() && r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName()) != null) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    ProgramVarTreeProvider.this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

