/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.programs.BasicProgramFilter;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.Map;

public abstract class ProgramVarFilter
extends BasicProgramFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected final int programTypeId;

    public ProgramVarFilter(Map<ResultElementType, StringBuilder> defaultPatterns, int programTypeId) {
        super(defaultPatterns, null);
        this.canSkipFilterEntry = false;
        this.programTypeId = programTypeId;
        this.addFilterEntries(defaultPatterns, 10);
    }

    @Override
    protected int getProgramTypeId() {
        return this.programTypeId;
    }

    @Override
    protected void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns, Integer defaultLimit) {
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(10, null, 0, this.getProgramLimitPrefStoreKey(), 0);
        FilterEntry e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e.put("incontext", MATCHING_ALL_FILTERS_BELOW);
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        this.addFilterEntryInfoProgram(e);
        e = this.makeFilterEntry(ResultElementType.VARIABLE, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@VarName");
        e.setValidator(3, limitValidator);
        this.addFilterEntryInfoVariable(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, defaultLimit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        this.addColumnsForStmt(e);
        this.entries.add(e);
    }

    protected void addFilterEntryInfoVariable(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), "src2.StartRow");
        e.put(DatabaseMetadata.STMT_START_COL.getName(), "src2.StartCol");
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), "src2.PathStr");
        e.put(DatabaseMetadata.VAR_ID.getName(), "Variables.VarID");
        e.put(DatabaseMetadata.VAR_NAME.getName(), "Variables.VarName");
        e.put(DatabaseMetadata.VAR_iLevel.getName(), "Variables.iLevel");
        e.put(DatabaseMetadata.VAR_PIC.getName(), "Variables.PIC");
        e.put(DatabaseMetadata.VAR_IsField.getName(), "Variables.IsField");
        e.put(DatabaseMetadata.VAR_IsFiller.getName(), "Variables.IsFiller");
        e.put(DatabaseMetadata.VAR_TYPE_ID.getName(), "Variables.type");
        e.put(DatabaseMetadata.VAR_PRG_REF_ID.getName(), "Variables.ProgIDReference");
        e.put(DatabaseMetadata.VAR_TYPE_DESCRIPTION.getName(), "VarTypes.Description");
        e.put(DatabaseMetadata.VAR_Father.getName(), "Variables.Father");
        e.put(DatabaseMetadata.VAR_ANCESTOR.getName(), "Variables.Ancestor");
        e.put(DatabaseMetadata.VAR_Father_Name.getName(), "father.VarName");
        e.put(DatabaseMetadata.VAR_Ancestor_Name.getName(), "ancestor.VarName");
        e.put(DatabaseMetadata.VAR_IS_COPY.getName(), "Variables.IsCopy");
        if (this.hasSectionType()) {
            e.put(DatabaseMetadata.VAR_SECTION_TYPE.getName(), "SectionTypes.Description");
        }
        e.put(DatabaseMetadata.VAR_START_ROW.getName(), "Occurrences_Var.StartRow");
        e.put(DatabaseMetadata.VAR_START_COL.getName(), "Occurrences_Var.StartCol");
        e.put(DatabaseMetadata.VAR_END_ROW.getName(), "Occurrences_Var.EndRow");
        e.put(DatabaseMetadata.VAR_END_COL.getName(), "Occurrences_Var.EndCol");
        e.put(DatabaseMetadata.VAR_PATH_STR.getName(), "Paths_Var.PathStr");
        e.put(DatabaseMetadata.STMT_bREAD.getName(), "src2.bRead");
        e.put(DatabaseMetadata.STMT_DESC.getName(), "src2.Description");
    }

    protected boolean hasSectionType() {
        return 1 == this.programTypeId;
    }

    @Override
    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
        if (ResultElementType.VARIABLE.equals((Object)type) || ResultElementType.STMT_TYPE.equals((Object)type) || ResultElementType.SCL_VARIABLE.equals((Object)type) || ResultElementType.INCLUDE.equals((Object)type)) {
            e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
            e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
            e.put("incontext", "  ");
        }
    }

    @Override
    protected void addFilterEntryInfoSpecificUsageElem(FilterEntry e) {
    }

    @Override
    protected void addFilterEntryInfoInclude(FilterEntry e) {
    }
}

