/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.cobol.State;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.programs.ProgramVarTreeProvider;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ProgramVarDescriptor
extends BasicProgramDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, String> spParam;
    private Map<String, String> spSelectProgramIds;
    private Map<String, String> spWhereClause;
    protected Map<String, String> spDetails;
    private Map<String, String> spOrderBy;

    public ProgramVarDescriptor(AbstractAnalysis analysis) {
        super(analysis);
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new ProgramVarTreeProvider(this);
    }

    @Override
    protected void initializeCSVSuffixes() {
        this.csvFileSuffixMap = new HashMap();
        ArrayList<ResultElementType> list = new ArrayList<ResultElementType>();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.VARIABLE);
        list.add(ResultElementType.STMT_TYPE);
        this.csvFileSuffixMap.put(ResultElementType.VARIABLE, new Pair((Object)"", list));
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.COBOL_VARIABLE_HEADER_INFO;
        return res;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (this.spParam == null) {
            this.spParam = new HashMap<String, String>();
            this.spParam.put(ResultElementType.VARIABLE.name(), " @_VarName VARCHAR(64)");
            this.spParam.put(ResultElementType.PROGRAM.name(), "@_PrgTypeID INT, @_PrgLimit INT, @_Program VARCHAR(255)");
            this.spParam.put(ResultElementType.STMT_TYPE.name(), "@_StatementType VARCHAR(64) ");
        }
        return this.spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureSelectProgramIDs() {
        this.spSelectProgramIds = new HashMap<String, String>();
        String from_where = "@@@@@EZLEGACY@@@@\n  WHERE ENTRY1.ProgramId = ENTRY2.ProgramId AND ENTRY2.ProgramId = ENTRY3.ProgramID\n  ORDER BY ENTRY1.ProgramName";
        this.spSelectProgramIds.put(ResultElementType.PROGRAM.name(), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\nSELECT ENTRY1.ProgramID, row_number() over(ORDER BY ENTRY1.ProgramName) as row_num \nfrom " + from_where + "\n ) q where row_num <= @PrgLimit");
        this.spSelectProgramIds.put("query_unlimited".concat(ResultElementType.PROGRAM.name()), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\n select ENTRY1.ProgramId \nfrom " + from_where + "\n ) q");
        this.spSelectProgramIds.put(ResultElementType.VARIABLE.name(), "\n (select distinct ProgramID, ProgramName from #varUsage) as ENTRY");
        return this.spSelectProgramIds;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (this.spWhereClause == null) {
            this.spWhereClause = new HashMap<String, String>();
            this.spWhereClause.put(ResultElementType.VARIABLE.name(), "SELECT_OR_INSERT_INTO #varUsageSELECT_MARKER\n  FROM ( SELECT ProgramID, ProgramName, ProgramTypeID, p.OccurId AS OccurId\n         FROM (SELECT AliasName as ProgramName, p1.ProgramID, ProgramTypeID, OccurId FROM Programs p1 \n \t\t\t\t\tINNER JOIN ProgramAliases p2 ON p1.ProgramId = P2.ProgramId and p2.AliasType = 0 ) p inner join Variables ON Variables.ProgIDReference = p.ProgramID \nLEFT OUTER JOIN (select Description, ResourceID from (Select StatementType, resourceID, occurid FROM StatementReference sr WHERE  sr.ResourceType = 4\r\n\n\t\t\t\t\t\t\t\t\tUNION Select StatementType, sr1.ResourceId, OccurID FROM StatementReference sr1 INNER JOIN ProcedureCallParameters pcp ON pcp.IDKey = sr1.ResourceID AND pcp.ResourceType = 4 \n\t\t\t\t\tWHERE sr1.ResourceType = 208) t1 LEFT OUTER JOIN Statements ON Statements.StatementType = t1.StatementType ) t ON t.ResourceID = Variables.VarID\n             WHERE (p.ProgramTypeID = @PrgTypeID)\n                 AND (p.OccurID <> 0)\n                 AND (UPPER(p.ProgramName) " + PROGRAM_LIKE_OR_IN_MARKER + ") " + "\n                 AND (UPPER(VarName) " + VARIABLE_LIKE_OR_IN_MARKER + "\n                     OR (Variables.VarID IS NULL AND @VarName = ''%''))" + "\n                 AND (UPPER(t.Description) " + STATEMENT_LIKE_OR_IN_MARKER + "\n                     OR (t.Description IS NULL AND @StatementType = ''%''))" + ") as v1" + "@@@@@EZLEGACY@@@@");
        }
        return this.spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureDetailsSelect() {
        if (this.spDetails == null) {
            this.spDetails = new HashMap<String, String>();
            this.spDetails.put(ResultElementType.PROGRAM.name(), "\n SELECT @@@@@EZLEGACY@@@@\n FROM (SELECT OccurId, p1.ProgramId, AliasName as ProgramName, ProgramTypeId, Ancestor \n\t\t\t\tFROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramID and AliasType = 0\n\t\t\t\tWHERE p1.ProgramID in (select * from #tempids)) p\n     INNER JOIN Occurrences AS Occurrences_Prg ON Occurrences_Prg.OccurID = p.OccurID\n     INNER JOIN Paths AS Paths_Prg ON Paths_Prg.PathID = Occurrences_Prg.PathID\n     LEFT JOIN (\n         SELECT * FROM ( @@@@@EZLEGACY@@@@\n             ) AS det\n         ) as m ON m.ProgramId = p.programid ");
            this.spDetails.put(ResultElementType.VARIABLE.name(), "\n FROM Variables\n INNER JOIN Occurrences AS Occurrences_Var ON Variables.OccurID = Occurrences_Var.OccurID\n INNER JOIN Paths AS Paths_Var ON Occurrences_Var.PathID = Paths_Var.PathID\n INNER JOIN Programs p ON Variables.ProgIDReference = p.ProgramID \n INNER JOIN Variables AS father ON father.VarID = Variables.Father\n INNER JOIN Variables AS ancestor ON ancestor.VarID = Variables.Ancestor\n LEFT JOIN VarTypes ON Variables.Type = VarTypes.VarType\n LEFT JOIN SectionTypes ON Variables.SectionType = SectionTypes.SecID\n LEFT OUTER JOIN (   SELECT    src1.ResourceID, src1.StartRow, src1.StartCol, src1.bRead, \n Statements.Description, Paths_Stmt.PathStr, Statements.StatementType\n                  FROM    (\n\t\t\t\t\t\tSELECT sr.ResourceID, sr.StartRow, sr.StartCol, sr.bRead,  sr.OccurID\n\t\t\t\t\t\tFROM StatementReference sr\n\t\t\t\t\t\tWHERE  sr.ResourceType = 4\n\t\t\t\t\t\tUNION\n\t\t\t\t\t\tSELECT pcp.ResourceId, sr1.StartRow, sr1.StartCol, sr1.bRead, sr1.OccurID\n\t\t\t\t\t\tFROM  StatementReference sr1\n\t\t\t\t\t\t\t INNER JOIN ProcedureCallParameters pcp ON pcp.IDKey = sr1.ResourceID AND pcp.ResourceType = 4\n\t\t\t\t\t\tWHERE sr1.ResourceType = 208\n\t\t\t\t\t  )src1\n\t\t\t\t\t\t  INNER JOIN OccurrencesStmt ON src1.OccurID = OccurrencesStmt.OccurID\n\t\t\t\t\t\t  INNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType\n\t\t\t\t\t\t  INNER JOIN Paths AS Paths_Stmt ON OccurrencesStmt.PathID = Paths_Stmt.PathID\n             ) src2 ON src2.ResourceID = Variables.VarID\n     where (@VarName = ''%''  OR UPPER(Variables.VarName) " + VARIABLE_LIKE_OR_IN_MARKER + ")" + "\n     AND (@StatementType = ''%''  OR UPPER(src2.Description) " + STATEMENT_LIKE_OR_IN_MARKER + ")" + "\n\t\tAND p.ProgramId in (select * from #tempids)");
        }
        return this.spDetails;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (this.spOrderBy == null) {
            this.spOrderBy = new HashMap<String, String>();
            this.spOrderBy.put(ResultElementType.VARIABLE.name(), DatabaseMetadata.VAR_ID.getName());
            this.spOrderBy.put(ResultElementType.PROGRAM.name(), DatabaseMetadata.PRG_NAME.getName());
        }
        return this.spOrderBy;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.VARIABLE, DatabaseMetadata.VAR_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        HashMap<String, List<ColumnInfo>> csvHeader = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.STMT_TYPE.name(), list);
                list.add(DatabaseMetadata.STMT_DESC);
                list.add(DatabaseMetadata.STMT_bREAD);
                list.add(DatabaseMetadata.STMT_PATH_STR);
                list.add(DatabaseMetadata.STMT_START_ROW);
                list.add(DatabaseMetadata.STMT_START_COL);
                list.add(DatabaseMetadata.STMT_END_ROW);
                list.add(DatabaseMetadata.STMT_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.PROGRAM.name(), list);
                list.add(DatabaseMetadata.PRG_ID);
                list.add(DatabaseMetadata.PRG_NAME);
                list.add(DatabaseMetadata.PRG_TYPE_ID);
                list.add(DatabaseMetadata.PRG_PATH);
                list = new ArrayList();
                this.put(ResultElementType.VARIABLE.name(), list);
                list.add(DatabaseMetadata.VAR_ID);
                list.add(DatabaseMetadata.VAR_NAME);
                if (ProgramVarDescriptor.this.hasSectionType()) {
                    list.add(DatabaseMetadata.VAR_SECTION_TYPE);
                }
                list.add(DatabaseMetadata.VAR_TYPE_ID);
                list.add(DatabaseMetadata.VAR_TYPE_DESCRIPTION);
                list.add(DatabaseMetadata.VAR_IsField);
                list.add(DatabaseMetadata.VAR_IsFiller);
                list.add(DatabaseMetadata.VAR_PATH_STR);
                list.add(DatabaseMetadata.VAR_START_ROW);
                list.add(DatabaseMetadata.VAR_START_COL);
                list.add(DatabaseMetadata.VAR_END_ROW);
                list.add(DatabaseMetadata.VAR_END_COL);
                ArrayList arrayList = new ArrayList();
            }
        };
        return csvHeader;
    }

    protected boolean hasSectionType() {
        return 1 == this.getProgramTypeId();
    }

    @Override
    public ResultElementType getSpecificElementType() {
        return null;
    }

    protected abstract int getProgramTypeId();

    @Override
    public int getDefaultExpandLevel() {
        int level = 2;
        if (this.hasManyProjects()) {
            level = 3;
        }
        return level;
    }

    @Override
    public Map<String, ColumnInfo[]> getStoreProceduresTempTables() {
        HashMap<String, ColumnInfo[]> tempTables = new HashMap<String, ColumnInfo[]>();
        tempTables.put("#varUsage", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME, DatabaseMetadata.PRG_TYPE_ID, DatabaseMetadata.PRG_OCCUR_ID});
        tempTables.put("#tempids", new ColumnInfo[]{DatabaseMetadata.PRG_ID});
        return tempTables;
    }
}

