/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.BasicProgramTreeProvider;
import com.ez.analysis.mainframe.usage.programs.ProgramDescriptor;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.cobol.callgraph.nodes.ParagraphNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import java.util.HashSet;
import java.util.Set;

public class ProgramTreeProvider
extends BasicProgramTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ProgramTreeProvider(ProgramDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected boolean hasLevelCategory(ResultElementType levelElementType) {
        return levelElementType.equals((Object)ResultElementType.STMT_TYPE) || levelElementType.equals((Object)ResultElementType.INCLUDE) || levelElementType.equals((Object)((ProgramDescriptor)this.descriptor).getSpecificElementType());
    }

    @Override
    protected void addElementInfo(ResultElement resultElement, Row r) {
        if (resultElement.getProperty("FILE") != null || resultElement.getProperty("ProjectInfo") != null) {
            return;
        }
        ResultElementType type = resultElement.getType();
        if (ResultElementType.PROGRAM.equals((Object)type)) {
            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
            resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
            if (r.hasColumn(DatabaseMetadata.PRG_ANCESTOR.getName())) {
                resultElement.addProperty("Ancestor Name", r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
            }
            resultElement.addProperty("Program Type Id", this.programTypeId);
            String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
            String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
            resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
            Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
            Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
            Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
            Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
            String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(this.programTypeId));
            ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (ResultElementType.STMT_SOURCE_INFO.equals((Object)type)) {
            resultElement.addProperty("Program Type Id", this.programTypeId);
            String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
            String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
            Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
            String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
            resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, prgType));
            resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
            resultElement.addProperty("Stmt Start Row", startRow);
            Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
            Utils.setFileAttribute(resultElement, String.valueOf(programTypeId), stmtPath, startRow, startCol);
        } else if (ResultElementType.PROJECT_INFO.equals((Object)type)) {
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (((ProgramDescriptor)this.descriptor).getSpecificElementType().equals((Object)type)) {
            this.addSpecificElementInfo(resultElement, r);
        } else if (ResultElementType.INCLUDE.equals((Object)type)) {
            String inclPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.INCLUDE_PATH.getName()));
            resultElement.addProperty("include is not on disk", inclPath.equals(""));
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_START_ROW.getName());
            Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_START_COL.getName());
            Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_END_ROW.getName());
            Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_END_COL.getName());
            resultElement.addProperty("Program Type Id", this.programTypeId);
            resultElement.addProperty(DatabaseMetadata.INCLUDE_RESOURCE_PATH_ID.getName(), r.getColumnValue(DatabaseMetadata.INCLUDE_RESOURCE_PATH_ID.getName()));
            MainframeSourceNode prgNode = new MainframeSourceNode(ResultElementType.INCLUDE.getDisplayName(), inclPath);
            resultElement.addProperty("Node_Mainframe", prgNode);
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), inclPath, startRow, startCol, endRow, endCol);
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        }
    }

    @Override
    protected void addSpecificElementInfo(ResultElement resultElement, Row r) {
        resultElement.addProperty("Program Type Id", this.programTypeId);
        String paraName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PARA_NAME.getName()));
        Integer ordinalNumber = (Integer)r.getColumnValue(DatabaseMetadata.PARA_ORDINAL.getName());
        Integer isExitParagraph = (Integer)r.getColumnValue(DatabaseMetadata.PARA_ISEXITPARA.getName());
        String paraPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PARA_PATH.getName()));
        Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.PARA_START_ROW.getName());
        Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.PARA_START_COL.getName());
        Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.PARA_END_ROW.getName());
        Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.PARA_END_COL.getName());
        Integer referencesNumber = (Integer)r.getColumnValue(DatabaseMetadata.PARA_REFNO.getName());
        Integer isProgramExit = (Integer)r.getColumnValue(DatabaseMetadata.PARA_ISPRGEXIT.getName());
        Integer statementsNumber = (Integer)r.getColumnValue(DatabaseMetadata.PARA_STMTNO.getName());
        Integer paragraphFallThroughtType = (Integer)r.getColumnValue(DatabaseMetadata.PARA_FALLTHROUGHT.getName());
        Integer linesNumber = (Integer)r.getColumnValue(DatabaseMetadata.PARA_LINESNO.getName());
        ParagraphNode paraNode = new ParagraphNode(paraName, String.valueOf(ordinalNumber), String.valueOf(isExitParagraph), String.valueOf(referencesNumber), String.valueOf(isProgramExit), String.valueOf(paragraphFallThroughtType), String.valueOf(statementsNumber), String.valueOf(linesNumber));
        paraNode.setParagraphTypeLbl(((ProgramDescriptor)this.descriptor).getSpecificElementType().name());
        resultElement.addProperty("Node_Mainframe", paraNode);
        Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), paraPath, startRow, startCol, endRow, endCol);
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }
}

