/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.programs.BasicProgramFilter;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.Map;

public abstract class ProgramFilter
extends BasicProgramFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ProgramFilter(Map<ResultElementType, StringBuilder> defaultPatterns, ResultElementType specificElementType) {
        super(defaultPatterns, specificElementType);
        this.addFilterEntries(defaultPatterns, 10);
    }

    @Override
    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
        if (this.specificElementType.equals((Object)type) || ResultElementType.INCLUDE.equals((Object)type)) {
            e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
            e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
            e.put("incontext", "  ");
        }
    }

    @Override
    protected void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns, Integer defaultLimit) {
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(10, null, 0, this.getProgramLimitPrefStoreKey(), 0);
        FilterEntry e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e.put("incontext", MATCHING_ALL_FILTERS_BELOW);
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        this.addFilterEntryInfoProgram(e);
        e = this.makeFilterEntry(this.specificElementType, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@ParaName");
        e.setValidator(3, limitValidator);
        this.addFilterEntryInfoSpecificUsageElem(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.INCLUDE, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@InclName");
        e.setValidator(3, limitValidator);
        this.addFilterEntryInfoInclude(e);
        this.entries.add(e);
    }

    @Override
    protected void addFilterEntryInfoSpecificUsageElem(FilterEntry e) {
        e.put(DatabaseMetadata.PARA_START_ROW.getName(), "Occurrences_Para.StartRow");
        e.put(DatabaseMetadata.PARA_START_COL.getName(), "Occurrences_Para.StartCol");
        e.put(DatabaseMetadata.PARA_END_ROW.getName(), "Occurrences_Para.EndRow");
        e.put(DatabaseMetadata.PARA_END_COL.getName(), "Occurrences_Para.EndCol");
        e.put(DatabaseMetadata.PARA_PATH.getName(), "Paths_Para.PathStr");
        e.put(DatabaseMetadata.PARA_ID.getName(), "Paragraphs.ParaID");
        e.put(DatabaseMetadata.PARA_NAME.getName(), "Paragraphs.ParaName");
        e.put(DatabaseMetadata.PARA_ORDINAL.getName(), "Paragraphs.OrdinalNum");
        e.put(DatabaseMetadata.PARA_FALLTHROUGHT.getName(), "paragraphs.parafallthroughtype");
        e.put(DatabaseMetadata.PARA_ISEXITPARA.getName(), "paragraphs.IsExitPara");
        e.put(DatabaseMetadata.PARA_REFNO.getName(), "paragraphs.ReferenceCount");
        e.put(DatabaseMetadata.PARA_ISPRGEXIT.getName(), "paragraphs.isProgExit");
        e.put(DatabaseMetadata.PARA_STMTNO.getName(), "paragraphs.NumOfStatements");
        e.put(DatabaseMetadata.PARA_LINESNO.getName(), "paragraphs.NumOfLines");
    }

    @Override
    protected void addFilterEntryInfoInclude(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), "OccurrencesStmt.StartRow");
        e.put(DatabaseMetadata.STMT_START_COL.getName(), "OccurrencesStmt.StartCol");
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), "OccurrencesStmt.EndRow");
        e.put(DatabaseMetadata.STMT_END_COL.getName(), "OccurrencesStmt.EndCol");
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), "Paths_Stmt.PathStr");
        e.put(DatabaseMetadata.INCLUDE_NAME.getName(), "Resources.Name");
        e.put(DatabaseMetadata.INCLUDE_START_ROW.getName(), "Occurrences_Incl.StartRow");
        e.put(DatabaseMetadata.INCLUDE_START_COL.getName(), "Occurrences_Incl.StartCol");
        e.put(DatabaseMetadata.INCLUDE_END_ROW.getName(), "Occurrences_Incl.EndRow");
        e.put(DatabaseMetadata.INCLUDE_END_COL.getName(), "Occurrences_Incl.EndCol");
        e.put(DatabaseMetadata.INCLUDE_RESOURCE_PATH_ID.getName(), "Occurrences_Incl.PathID");
        e.put(DatabaseMetadata.INCLUDE_PATH.getName(), "CASE Paths_Incl.PathStr\tWHEN Resources.Name THEN NULL ELSE Paths_Incl.PathStr END");
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
        e.put(DatabaseMetadata.STMT_bREAD.getName(), DatabaseMetadata.STMT_bREAD.getName());
    }
}

