/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.cobol.State;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.programs.ProgramTreeProvider;
import com.ez.internal.utils.MapFilter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ProgramDescriptor
extends BasicProgramDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, String> spDetails;
    private Map<String, String> spOrderBy;
    private Map<String, String> spParam;
    private Map<String, String> spSelectProgramIds;
    private Map<String, String> spWhereClause;

    public ProgramDescriptor(AbstractAnalysis analysis) {
        super(analysis);
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new ProgramTreeProvider(this);
    }

    @Override
    protected void initializeCSVSuffixes() {
        this.csvFileSuffixMap = new HashMap();
        ArrayList<ResultElementType> list = new ArrayList<ResultElementType>();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.INCLUDE);
        this.csvFileSuffixMap.put(ResultElementType.INCLUDE, new Pair((Object)" - Includes", list));
        list = new ArrayList();
        list.add(ResultElementType.PROGRAM);
        ResultElementType tabSpecificElementType = this.getSpecificElementType();
        list.add(tabSpecificElementType);
        this.csvFileSuffixMap.put(tabSpecificElementType, new Pair((Object)" - ".concat(tabSpecificElementType.getDisplayName()).concat("s"), list));
    }

    @Override
    protected void initializeCsvExportDescriptor() {
        HashMap<ResultElementType, MapFilter<ColumnInfo, Object>> csvFilterMap = new HashMap<ResultElementType, MapFilter<ColumnInfo, Object>>();
        MapFilter includeFilter = MapFilter.AndMapFilter.createFilter((MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.INCLUDE_NAME), (MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.INCLUDE_PATH));
        csvFilterMap.put(ResultElementType.INCLUDE, includeFilter);
        MapFilter specificElementTypeFilter = MapFilter.AndMapFilter.createFilter((MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.PARA_NAME), (MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.PARA_PATH));
        csvFilterMap.put(this.getSpecificElementType(), specificElementTypeFilter);
        this.csvExportDescriptor = new CsvExportDescriptor(csvFilterMap, null);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.COBOL_HEADER_INFO;
        return res;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (this.spParam == null || !this.spParam.containsKey(this.getSpecificElementType().name())) {
            this.spParam = new HashMap<String, String>();
            this.spParam.put(ResultElementType.PROGRAM.name(), "@_PrgTypeID INT, @_PrgLimit INT, @_Program VARCHAR(255)");
            this.spParam.put(this.getSpecificElementType().name(), " @_ParaName VARCHAR(64)");
            this.spParam.put(ResultElementType.INCLUDE.name(), " @_InclName VARCHAR(64)");
        }
        return this.spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureSelectProgramIDs() {
        this.spSelectProgramIds = new HashMap<String, String>();
        String from_where = "@@@@@EZLEGACY@@@@\n  WHERE ENTRY1.ProgramId = ENTRY2.ProgramId AND ENTRY2.ProgramId = ENTRY3.ProgramID\n  ORDER BY ENTRY1.ProgramName";
        this.spSelectProgramIds.put(ResultElementType.PROGRAM.name(), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\nSELECT ENTRY1.ProgramID, row_number() over(ORDER BY ENTRY1.ProgramID) as row_num \nfrom " + from_where + "\n ) q where row_num <= @PrgLimit");
        this.spSelectProgramIds.put("query_unlimited".concat(ResultElementType.PROGRAM.name()), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\n select ENTRY1.ProgramId \nfrom " + from_where + "\n ) q");
        this.spSelectProgramIds.put(this.getSpecificElementType().name(), "\n (select distinct ProgramID, ProgramName from #temppara \n union select ProgramID, ProgramName from #nopara\n ) as ENTRY");
        this.spSelectProgramIds.put(ResultElementType.INCLUDE.name(), "\n (select distinct programid, ProgramName from #tempincl \n  union select ProgramID, ProgramName from #noincl\n ) as ENTRY");
        return this.spSelectProgramIds;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (this.spWhereClause == null || !this.spWhereClause.containsKey(this.getSpecificElementType().name())) {
            this.spWhereClause = new HashMap<String, String>();
            String PARAGRAPH_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(this.getSpecificElementType(), new String[0]);
            this.spWhereClause.put(this.getSpecificElementType().name(), "SELECT_OR_INSERT_INTO #temppara SELECT_MARKER\n from (\n SELECT distinct p.ProgramName, p.ProgramID\n\t\t\tFROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID \n\t\t\t\t\tFROM Programs p1 \n\t\t\t\t\tINNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 and p1.ProgramTypeID = @PrgTypeID and p1.OccurID <> 0\n\t\t\t\t\tWHERE (UPPER(AliasName) " + PROGRAM_LIKE_OR_IN_MARKER + ")" + "\n\t\t\t\t\t) p " + "\n\t\t\tINNER JOIN Paragraphs ON p.ProgramID = Paragraphs.ProgramID" + "\n \t\tWHERE (UPPER(ParaName) " + PARAGRAPH_LIKE_OR_IN_MARKER + ")" + "\n ) as tq1 " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + " #nopara " + "SELECT_MARKER" + "\n \t\tFROM (select distinct p.programid, ProgramName from " + "\n\t\t\t\t(SELECT ProgramTypeID, OccurID, tp.ProgramId, AliasName as ProgramName " + "\n\t\t\t\t\tFROM Programs tp inner join ProgramAliases tpa on tp.ProgramId = tpa.Programid and tpa.AliasType = 0 and tp.ProgramTypeID = @PrgTypeID and tp.OccurID <> 0" + "\n\t\t\t\t\tWHERE (UPPER(AliasName) " + PROGRAM_LIKE_OR_IN_MARKER + ") " + "\n\t\t\t\t) p " + "\n\t\t\t\tLEFT JOIN Paragraphs ON p.ProgramID = Paragraphs.ProgramID " + "\n\t\t\t\tWHERE Paragraphs.ParaID IS NULL " + "\n\t\t\t\t\tAND @ParaName = ''%'' " + "\n ) as para" + "@@@@@EZLEGACY@@@@");
            this.spWhereClause.put(ResultElementType.INCLUDE.name(), "SELECT_OR_INSERT_INTO #tempinclALL SELECT_MARKER\nfrom (\n\t\tSELECT distinct p.ProgramName, p.ProgramID, Resources.Name as ResourceName\n\t\t\tFROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 \n\t\t\t\t\t\tINNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 and p1.ProgramTypeID = @PrgTypeID and  p1.OccurID <> 0\n\t\t\t\t\t\tWHERE (UPPER(AliasName) " + PROGRAM_LIKE_OR_IN_MARKER + ") " + "\n\t\t\t\t  ) p " + "\n\t\t\t\t\t\tINNER JOIN OccurrencesStmt ON p.ProgramID = OccurrencesStmt.ProgID" + "\n\t\t\t\t\t\tINNER JOIN StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID" + "\n\t\t\t\t\t\tINNER JOIN Resources ON StatementReference.ResourceID = Resources.ResourceID" + "\n\t\t\t\tWHERE (StatementReference.ResourceType IN (13,60,67,99,57))" + "\n) as tqALL" + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + " #tempincl " + "SELECT_MARKER" + "\n\t\t\tfrom (SELECT distinct ProgramName, ProgramID" + "\n\t\t\t\t\tFROM #tempinclALL" + "\n\t\t\t\t\tWHERE (UPPER(ResourceName) " + INCLUDE_LIKE_OR_IN_MARKER + ") " + "\n ) as tq3" + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + " #noincl " + "SELECT_MARKER" + "\n\t\t\tFROM (select ProgramID, ProgramName " + "\n\t\t\t\t  from (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID " + "\n \t\t\t\t\t\tFROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 and p1.ProgramTypeID = @PrgTypeID and p1.OccurID <> 0" + "\n\t\t\t\t\t\tWHERE (UPPER(AliasName) " + PROGRAM_LIKE_OR_IN_MARKER + ") " + "\n\t\t\t\t\t\t) p " + "\n\t\t\t\t\tWHERE Programid not in (" + "\n\t\t\t\t\t\tselect distinct ProgramID from  #tempinclALL)" + "\n\t\t\t\t\tAND (@InclName = ''%'') " + "\n ) as incl" + "@@@@@EZLEGACY@@@@");
        }
        return this.spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureDetailsSelect() {
        if (this.spDetails == null || !this.spDetails.containsKey(this.getSpecificElementType().name())) {
            this.spDetails = new HashMap<String, String>();
            this.spDetails.put(ResultElementType.PROGRAM.name(), "\n SELECT @@@@@EZLEGACY@@@@ FROM  (SELECT OccurId, p1.ProgramId, AliasName as ProgramName, ProgramTypeId, Ancestor from Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramID and AliasType = 0) p\n INNER JOIN Occurrences AS Occurrences_Prg ON Occurrences_Prg.OccurID = p.OccurID\n INNER JOIN Paths AS Paths_Prg ON Paths_Prg.PathID = Occurrences_Prg.PathID\n left join (\n select * from ( @@@@@EZLEGACY@@@@ ) AS det\n ) as m ON m.ProgramId = p.programid \n WHERE p.ProgramID in (select * from #tempids) ");
            this.spDetails.put(ResultElementType.INCLUDE.name(), "\n \t\tFROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p \n \t\t\tINNER JOIN OccurrencesStmt ON p.ProgramID = OccurrencesStmt.ProgID\n \t\t\tINNER JOIN StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID\n\t\t\tINNER JOIN Statements ON StatementReference.StatementType = Statements.StatementType\n \t\t\tINNER JOIN Resources ON StatementReference.ResourceID = Resources.ResourceID\n \t\t\tINNER JOIN Occurrences AS Occurrences_Incl ON Resources.OccurID = Occurrences_Incl.OccurID\n \t\t\tINNER JOIN Paths AS Paths_Incl ON Occurrences_Incl.PathID = Paths_Incl.PathID\n \t\t\tINNER JOIN Paths AS Paths_Stmt ON OccurrencesStmt.PathID = Paths_Stmt.PathID\n\t\t\tWHERE (StatementReference.ResourceType IN (13,60,67,99,57))\n  \t\tand p.ProgramID in (select * from #tempids)");
            this.spDetails.put(this.getSpecificElementType().name(), "\n FROM (SELECT AliasName as ProgramName, OccurID, ProgramTypeID, p1.ProgramID FROM Programs p1 INNER JOIN ProgramAliases p2 ON p1.ProgramId = p2.ProgramId and p2.AliasType = 0 ) p \n INNER JOIN Paragraphs ON p.ProgramID = Paragraphs.ProgramID\n INNER JOIN Occurrences AS Occurrences_Para ON Paragraphs.OccurID = Occurrences_Para.OccurID\n INNER JOIN Paths AS Paths_Para ON Occurrences_Para.PathID = Paths_Para.PathID\n where p.ProgramID in (select * from #tempids)");
        }
        return this.spDetails;
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        HashMap<String, List<ColumnInfo>> csvHeader = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.STMT_TYPE.name(), list);
                list.add(DatabaseMetadata.STMT_DESC);
                list.add(DatabaseMetadata.STMT_START_ROW);
                list.add(DatabaseMetadata.STMT_START_COL);
                list.add(DatabaseMetadata.STMT_END_ROW);
                list.add(DatabaseMetadata.STMT_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.PROGRAM.name(), list);
                list.add(DatabaseMetadata.PRG_ID);
                list.add(DatabaseMetadata.PRG_NAME);
                list.add(DatabaseMetadata.PRG_TYPE_ID);
                list.add(DatabaseMetadata.PRG_PATH);
                list = new ArrayList();
                this.put(ProgramDescriptor.this.getSpecificElementType().name(), list);
                list.add(DatabaseMetadata.PARA_ORDINAL);
                list.add(DatabaseMetadata.PARA_NAME);
                list.add(DatabaseMetadata.PARA_FALLTHROUGHT);
                list.add(DatabaseMetadata.PARA_REFNO);
                list.add(DatabaseMetadata.PARA_ISEXITPARA);
                list.add(DatabaseMetadata.PARA_LINESNO);
                list.add(DatabaseMetadata.PARA_STMTNO);
                list.add(DatabaseMetadata.PARA_PATH);
                list.add(DatabaseMetadata.PARA_START_ROW);
                list.add(DatabaseMetadata.PARA_START_COL);
                list.add(DatabaseMetadata.PARA_END_ROW);
                list.add(DatabaseMetadata.PARA_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.INCLUDE.name(), list);
                list.add(DatabaseMetadata.INCLUDE_NAME);
                list.add(DatabaseMetadata.INCLUDE_PATH);
            }
        };
        return csvHeader;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (this.spOrderBy == null || !this.spOrderBy.containsKey(this.getSpecificElementType().name())) {
            this.spOrderBy = new HashMap<String, String>();
            this.spOrderBy.put(ResultElementType.PROGRAM.name(), "ProgramName");
            this.spOrderBy.put(this.getSpecificElementType().name(), "ParaName");
            this.spOrderBy.put(ResultElementType.INCLUDE.name(), "IncludeName");
        }
        return this.spOrderBy;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(this.getSpecificElementType(), DatabaseMetadata.PARA_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.INCLUDE, DatabaseMetadata.INCLUDE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public int getDefaultExpandLevel() {
        int level = 3;
        if (this.hasManyProjects()) {
            level = 4;
        }
        return level;
    }

    @Override
    public Map<String, ColumnInfo[]> getStoreProceduresTempTables() {
        HashMap<String, ColumnInfo[]> tempTables = new HashMap<String, ColumnInfo[]>();
        tempTables.put("#temppara", new ColumnInfo[]{DatabaseMetadata.PRG_NAME, DatabaseMetadata.PRG_ID});
        tempTables.put("#nopara", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#tempinclALL", new ColumnInfo[]{DatabaseMetadata.PRG_NAME, DatabaseMetadata.PRG_ID, DatabaseMetadata.RESOURCE_NAME});
        tempTables.put("#tempincl", new ColumnInfo[]{DatabaseMetadata.PRG_NAME, DatabaseMetadata.PRG_ID});
        tempTables.put("#noincl", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#tempids", new ColumnInfo[]{DatabaseMetadata.PRG_ID});
        return tempTables;
    }
}

