/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.programs;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.BasicProgramDescriptor;
import com.ez.analysis.mainframe.usage.programs.BasicProgramFilter;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class BasicProgramTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected final int programTypeId;

    public BasicProgramTreeProvider(BasicProgramDescriptor descriptor) {
        this.descriptor = descriptor;
        BasicProgramFilter filter = (BasicProgramFilter)descriptor.getState().getData().get("FilterData");
        this.programTypeId = filter.getProgramTypeId();
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        ProgramCallback callback = new ProgramCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    protected boolean isElementValidForCreation(String elementName, ResultElementType levelElementType, Row r) {
        return !elementName.isEmpty();
    }

    protected abstract boolean hasLevelCategory(ResultElementType var1);

    protected abstract void addElementInfo(ResultElement var1, Row var2);

    @Override
    protected List<ResultElementType> getLevelsOrder() {
        if (!this.elementTypes.contains(ResultElementType.STMT_TYPE)) {
            this.elementTypes.add(ResultElementType.STMT_TYPE);
        }
        return this.elementTypes;
    }

    protected abstract void addSpecificElementInfo(ResultElement var1, Row var2);

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    protected class ProgramCallback
    extends AbstractProcessRowCallback {
        Map<String, ResultElement> variablesMap;
        private boolean displayStmt;

        public ProgramCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.variablesMap = new HashMap<String, ResultElement>();
            this.displayStmt = true;
        }

        public void setDisplayStmt(boolean displayStmt) {
            this.displayStmt = displayStmt;
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (BasicProgramTreeProvider.this.isElementValidForCreation(name, levelElementType, r)) {
                        String key = name;
                        if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                            String projectName = projectInfo.getName();
                            Integer prgID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                            key = String.valueOf(key) + "|" + projectName + "|" + prgID;
                        }
                        if (BasicProgramTreeProvider.this.hasLevelCategory(levelElementType)) {
                            String categoryName = null;
                            if (levelElementType.equals((Object)ResultElementType.STMT_TYPE)) {
                                Integer bRead = (Integer)r.getColumnValue(DatabaseMetadata.STMT_bREAD.getName());
                                categoryName = Utils.readOrWriteStmt(bRead);
                            }
                            parent = Utils.getCategory(levelElementType, parent, categoryName);
                        }
                        ResultElement resultElement = null;
                        if (!levelElementType.equals((Object)ResultElementType.VARIABLE) && (resultElement = parent.getChild(key)) == null) {
                            resultElement = new ResultElement(name, levelElementType, parent);
                            BasicProgramTreeProvider.this.addElementInfo(resultElement, r);
                            parent.addChild(key, resultElement);
                            Utils.completeProjectInfo(resultElement, projectInfo);
                        }
                        BasicProgramTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                    }
                } else if (this.displayStmt && levelIndex == this.levelsOrder.size() && r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName()) != null) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    BasicProgramTreeProvider.this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

