/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.procInJob;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcInJobTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LoggerFactory.getLogger(ProcInJobTreeProvider.class);

    public ProcInJobTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        ArrayList<ResultElementType> levelsOrderWithDataset = new ArrayList<ResultElementType>(levelsOrder);
        levelsOrderWithDataset.add(ResultElementType.JCL_STEP);
        levelsOrderWithDataset.add(ResultElementType.DDNAME);
        levelsOrderWithDataset.add(ResultElementType.DATASET);
        MyCallback callback = new MyCallback(root, levelsOrderWithDataset, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
        if (this.descriptor.mustRunAdditionalSP()) {
            RecordsetProvider stepProvider = this.descriptor.getRecordsetProvider("StepInProcedure");
            ArrayList<ResultElementType> addLevelOrders = new ArrayList<ResultElementType>();
            if (levelsOrder.contains(ResultElementType.PROJECT_INFO)) {
                addLevelOrders.add(ResultElementType.PROJECT_INFO);
            }
            addLevelOrders.add(ResultElementType.JCL_PROCEDURE);
            addLevelOrders.add(ResultElementType.JCL_STEP);
            addLevelOrders.add(ResultElementType.DDNAME);
            addLevelOrders.add(ResultElementType.DATASET);
            ProcStepsCallback stepCallback = new ProcStepsCallback(root, addLevelOrders, elemTypeToElemNameColumnsMap);
            stepProvider.load(stepCallback, monitor);
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    private void setJCLStepPath(ResultElement resultElement, Row r) {
        String stepPath = (String)r.getColumnValue(DatabaseMetadata.STEP_PATH.getName());
        Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STEP_START_ROW.getName());
        Utils.setFileAttribute(resultElement, "22", stepPath, startRow);
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case JCL_JOB: {
                String jobName = (String)r.getColumnValue(DatabaseMetadata.JOB_NAME.getName());
                resultElement.addProperty(DatabaseMetadata.JOB_NAME.getName(), jobName);
                String memberName = (String)r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName());
                resultElement.addProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName(), memberName);
                Integer jobId = (Integer)r.getColumnValue(DatabaseMetadata.JOB_ID.getName());
                resultElement.addProperty(DatabaseMetadata.JOB_ID.getName(), jobId);
                String ca7JobName = (String)r.getColumnValue(DatabaseMetadata.CA7_JOB_NAME.getName());
                resultElement.addProperty(DatabaseMetadata.CA7_JOB_NAME.getName(), ca7JobName);
                Integer ca7jobId = (Integer)r.getColumnValue(DatabaseMetadata.CA7_JOB_ID.getName());
                resultElement.addProperty(DatabaseMetadata.CA7_JOB_ID.getName(), ca7jobId);
                String path = (String)r.getColumnValue(DatabaseMetadata.JOB_PATH.getName());
                Utils.setFileAttribute(resultElement, "22", path, new Integer[0]);
                resultElement.addProperty("Node_Mainframe", new MainframeSourceNode(ResultElementType.JCL_JOB.getDisplayName(), path));
                break;
            }
            case JCL_PROCEDURE: {
                String procName = (String)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP.getName());
                resultElement.addProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName(), procName);
                String procPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_PATH.getName()));
                String type = ResultElementType.JCL_PROCEDURE.getDisplayName();
                Integer procStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_START_ROW.getName());
                Integer procStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_START_COL.getName());
                Integer procEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_END_ROW.getName());
                Integer procEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_END_COL.getName());
                MainframeSourceNode prgNode = new MainframeSourceNode(type, procPath);
                resultElement.addProperty("Node_Mainframe", prgNode);
                Utils.setFileAttribute(resultElement, "22", procPath, procStartRow, procStartCol, procEndRow, procEndCol);
                break;
            }
            case DDNAME: {
                DatasetUtils.setDDPath(resultElement, r);
                String cfr_ignored_0 = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                DatasetUtils.setPropertiesInfoForDD(resultElement, r);
                break;
            }
            case DATASET: {
                String dataset = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_NAME.getName()));
                resultElement.addProperty(DatabaseMetadata.DATASET_NAME.getName(), dataset);
                Integer dsId = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_ID.getName());
                resultElement.addProperty(DatabaseMetadata.DATASET_ID.getName(), dsId);
                String datasetMemberName = (String)r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
                if (datasetMemberName != null) {
                    resultElement.addProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), datasetMemberName);
                }
                String ddname = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                resultElement.addProperty(DatabaseMetadata.DD_NAME.getName(), ddname);
                Integer dsGenerationnNo = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
                if (dsGenerationnNo != null) {
                    resultElement.addProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), dsGenerationnNo);
                    resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)dsGenerationnNo, ResultElementType.DATASET.getDisplayName()));
                } else {
                    resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)"", ResultElementType.DATASET.getDisplayName()));
                }
                DatasetUtils.setDDPath(resultElement, r);
                break;
            }
            case JCL_STEP: {
                this.setJCLStepPath(resultElement, r);
                String stepName = (String)r.getColumnValue(DatabaseMetadata.STEP_NAME.getName());
                resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(stepName, ResultElementType.JCL_STEP.getDisplayName()));
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
            }
        }
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            parent = this.process(r, parent, projectInfo);
            return true;
        }

        public ResultElement process(Row r, ResultElement parent, ProjectInfo projectInfo) {
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElement resultElement;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.DDNAME) && name.isEmpty()) break;
                    if (levelElementType.equals((Object)ResultElementType.DATASET) && name.isEmpty()) {
                        String spoolClassName = (String)r.getColumnValue(DatabaseMetadata.SPOOL_DATASET_CLASS.getName());
                        if (spoolClassName == null) break;
                        name = DatasetUtils.computeDatasetName(r, name);
                    }
                    String key = name;
                    if (ResultElementType.DATASET.equals((Object)levelElementType)) {
                        key = DatasetUtils.getFullDSName(r, name);
                    }
                    if (levelElementType.equals((Object)ResultElementType.JCL_JOB)) {
                        ResultElement categoryResultElement;
                        String jobMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName()));
                        key = name.concat(jobMemberName);
                        parent = categoryResultElement = Utils.getCategory(levelElementType, parent, null);
                    }
                    if ((resultElement = parent.getChild(key)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        ProcInJobTreeProvider.this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    ProcInJobTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                }
                ++levelIndex;
            }
            return parent;
        }
    }

    class ProcStepsCallback
    extends AbstractProcessRowCallback {
        public ProcStepsCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex < this.levelsOrder.size()) {
                ResultElement resultElement;
                ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                if (levelElementType.equals((Object)ResultElementType.DDNAME) && name.isEmpty()) break;
                if (levelElementType.equals((Object)ResultElementType.DATASET) && name.isEmpty()) {
                    String spoolClassName = (String)r.getColumnValue(DatabaseMetadata.SPOOL_DATASET_CLASS.getName());
                    if (spoolClassName == null) break;
                    name = DatasetUtils.computeDatasetName(r, name);
                }
                String key = name;
                if (ResultElementType.DATASET.equals((Object)levelElementType)) {
                    key = DatasetUtils.getFullDSName(r, name);
                }
                if (levelElementType.equals((Object)ResultElementType.JCL_STEP)) {
                    ResultElement categoryResultElement;
                    parent = categoryResultElement = Utils.getCategory(levelElementType, parent, null);
                }
                if ((resultElement = parent.getChild(key)) == null) {
                    resultElement = new ResultElement(name, levelElementType, parent);
                    ProcInJobTreeProvider.this.addElementInfo(resultElement, r);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    parent.addChild(key, resultElement);
                }
                parent = resultElement;
                ++levelIndex;
            }
            return true;
        }
    }
}

