/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.procInJob;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.DatasetJobFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.procInJob.ProcInJobFilter;
import com.ez.analysis.mainframe.usage.procInJob.ProcInJobTreeProvider;
import com.ez.analysis.mainframe.usage.procInJob.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.queries.StoredProcDetail;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.JobWithMemberLabelProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcInJobDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProcInJobDescriptor.class);
    public static final String PROC_IN_JOB_USAGE = "com.ez.analysis.mainframe.usage.proc.job";
    public static final String STEP_IN_PROCEDURE_KEY = "StepInProcedure";
    public static final String JCL_PROC_PARAMETER_NAME = "@ProcName";
    private static final String PROC_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.JCL_PROCEDURE, new String[0]);
    private static final String PROC_IN_JOB_USAGE_FILTERS_FILE_NAME = "ProcedureInJobUsageFilters.properties";
    private static final Map<String, List<ColumnInfo>> PROC_IN_JOB_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.JCL_PROCEDURE.name(), list);
            list.add(DatabaseMetadata.PROC_EXEC_IN_STEP);
            list.add(DatabaseMetadata.PROC_EXEC_IN_STEP_PATH);
            list = new ArrayList();
            this.put(ResultElementType.JCL_JOB.name(), list);
            list.add(DatabaseMetadata.JOB_ID);
            list.add(DatabaseMetadata.JOB_NAME);
            list.add(DatabaseMetadata.JOB_MEMBER_NAME);
            list.add(DatabaseMetadata.JOB_PATH);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    private static Map<String, String> spOrderBy;

    public ProcInJobDescriptor(AbstractAnalysis analysis) {
        super(analysis.getType());
        this.id = PROC_IN_JOB_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Map<String, StoredProcDetail> getAdditionalSpMap() {
        boolean displayTemptDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        HashMap<String, StoredProcDetail> localSPMap = new HashMap<String, StoredProcDetail>(displayTemptDatasets){
            {
                this.put(ProcInJobDescriptor.STEP_IN_PROCEDURE_KEY, new StoredProcDetail("EZViewer_Usage_StepsInProc_Selective", DatabaseMetadata.PROC_EXEC_IN_STEP_ID, DatabaseMetadata.STEP_IN_JOB_HEADER_INFO, (List<Pair<ResultElementType, Integer>>)new ArrayList<Pair<ResultElementType, Integer>>(bl){
                    {
                        this.add(new Pair((Object)ResultElementType.FAKE_NON_FILTER_SP_PARAM, (Object)(bl ? 1 : 0)));
                    }
                }));
            }
        };
        return localSPMap;
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new ProcInJobTreeProvider(this);
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new ProcInJobFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_ProcInJob";
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.PROC_IN_JOB_HEADER_INFO;
    }

    @Override
    public String getFileName() {
        return PROC_IN_JOB_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return PROC_IN_JOB_CSV_HEADER;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.JCL_PROCEDURE.name(), " @ProcLimit INT, @ProcName VARCHAR(64)");
            spParam.put(ResultElementType.JCL_JOB.name(), "  @DisplayTempDatasets INT, @JCLLimit INT, @JCLName VARCHAR(64)");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.JCL_PROCEDURE.name(), " (@ProcName = ''%'' or UPPER(ProcName) " + PROC_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.JCL_JOB.name(), " (@JCLName = ''%'' or UPPER(JobName) " + JOB_LIKE_OR_IN_MARKER + ") AND ((@DisplayTempDatasets=0 AND (IsTemp<>1 OR IsTemp IS NULL)) OR (@DisplayTempDatasets=1)) ");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.JCL_PROCEDURE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.PROC_EXEC_IN_STEP.getName()).limitParamName(" @ProcLimit ").create());
                this.put(ResultElementType.JCL_JOB.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.JOB_NAME.getName()).limitParamName(" @JCLLimit ").create());
            }
        };
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (spOrderBy == null) {
            spOrderBy = new HashMap<String, String>();
            spOrderBy.put(ResultElementType.JCL_PROCEDURE.name(), "ProcName");
            spOrderBy.put(ResultElementType.JCL_JOB.name(), "JobName");
        }
        return spOrderBy;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "ProcInJob";
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_PROCEDURE, DatabaseMetadata.PROC_EXEC_IN_STEP.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_JOB, DatabaseMetadata.JOB_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDNAME, DatabaseMetadata.DD_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DATASET, DatabaseMetadata.DATASET_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_STEP, DatabaseMetadata.STEP_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public boolean hasReorderResultsAction() {
        return false;
    }

    @Override
    public IBaseLabelProvider getResultsLabelProvider(ImageRegistry imgRegistry) {
        return new JobWithMemberLabelProvider(imgRegistry);
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.JCL_JOB.name(), new DatasetJobFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

