/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.pgmInJob;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class PgmInJobTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public PgmInJobTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    String dsName;
                    String dsIsTemp;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    boolean displayTemptDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
                    if (!displayTemptDatasets && levelElementType.equals((Object)ResultElementType.DDNAME) && "1".equals(dsIsTemp = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_ISTEMP.getName()))) || levelElementType.equals((Object)ResultElementType.DDNAME) && name.isEmpty() && (dsName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_NAME.getName()))).isEmpty() && DatasetUtils.computeDatasetName(r, dsName) == null) break;
                    if (levelElementType.equals((Object)ResultElementType.DATASET) && name.isEmpty()) {
                        String spoolClassName = (String)r.getColumnValue(DatabaseMetadata.SPOOL_DATASET_CLASS.getName());
                        if (spoolClassName == null) break;
                        name = DatasetUtils.computeDatasetName(r, name);
                    }
                    String key = name;
                    if (ResultElementType.DATASET.equals((Object)levelElementType)) {
                        key = DatasetUtils.getFullDSName(r, name);
                    } else if (ResultElementType.JCL_JOB.equals((Object)levelElementType)) {
                        String jobMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName()));
                        key = name.concat(jobMemberName);
                    } else if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                        if (id != null) {
                            key = id.toString().concat("__").concat(name);
                        }
                        parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                    }
                    ResultElement resultElement = parent.getChild(key);
                    if (resultElement == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    this.addElementInfo(resultElement, r);
                    PgmInJobTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case PROGRAM: {
                    String ancestorName;
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    if (programTypeId == null) {
                        programTypeId = ProgramUtils.getFakeProgTypeID(resultElement.getName());
                    }
                    resultElement.addProperty("Program Type Id", programTypeId);
                    String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                    String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                    String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                    ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                    if (!programPath.isEmpty()) {
                        Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                        Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                        Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                        Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                        Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                    }
                    if ((ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()))) == null || ancestorName.isEmpty()) break;
                    resultElement.addProperty("Ancestor Name", ancestorName);
                    Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                    resultElement.addProperty("Ancestor Id", ancestorId);
                    break;
                }
                case DATASET: {
                    String dataset = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.DATASET_NAME.getName(), dataset);
                    String datasetMemberName = (String)r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), datasetMemberName);
                    String ddname = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.DD_NAME.getName(), ddname);
                    Integer dsId = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.DATASET_ID.getName(), dsId);
                    Integer dsGenerationnNo = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
                    if (dsGenerationnNo != null) {
                        resultElement.addProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), dsGenerationnNo);
                        resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)dsGenerationnNo, ResultElementType.DATASET.getDisplayName()));
                    } else {
                        resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)"", ResultElementType.DATASET.getDisplayName()));
                    }
                    DatasetUtils.setDDPath(resultElement, r);
                    break;
                }
                case JCL_JOB: {
                    String jobName = (String)r.getColumnValue(DatabaseMetadata.JOB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_NAME.getName(), jobName);
                    String memberName = (String)r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName(), memberName);
                    Integer ca7jobId = (Integer)r.getColumnValue(DatabaseMetadata.CA7_JOB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.CA7_JOB_ID.getName(), ca7jobId);
                    String ca7jobName = (String)r.getColumnValue(DatabaseMetadata.CA7_JOB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.CA7_JOB_NAME.getName(), ca7jobName);
                    Integer jobId = (Integer)r.getColumnValue(DatabaseMetadata.JOB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_ID.getName(), jobId);
                    String jobPath = (String)r.getColumnValue(DatabaseMetadata.JOB_PATH.getName());
                    Utils.setFileAttribute(resultElement, "22", jobPath, new Integer[0]);
                    resultElement.addProperty("Node_Mainframe", new MainframeSourceNode(ResultElementType.JCL_JOB.getDisplayName(), jobPath));
                    break;
                }
                case JCL_STEP: {
                    String stepPath = (String)r.getColumnValue(DatabaseMetadata.STEP_PATH.getName());
                    Integer jobStartRow = (Integer)r.getColumnValue(DatabaseMetadata.STEP_START_ROW.getName());
                    String stepName = (String)r.getColumnValue(DatabaseMetadata.STEP_NAME.getName());
                    Utils.setFileAttribute(resultElement, "22", stepPath, jobStartRow);
                    resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(stepName, ResultElementType.JCL_STEP.getDisplayName()));
                    break;
                }
                case DDNAME: {
                    DatasetUtils.setDDPath(resultElement, r);
                    DatasetUtils.setPropertiesInfoForDD(resultElement, r);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

