/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.pgmInJob;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class PgmInJobFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public PgmInJobFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        this.canSkipFilterEntry = false;
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "PgmUsageInJobsProgramLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("must search aliases", Boolean.toString(true));
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamName", "@Program");
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "PgmUsageInJobsJobLimit", 0);
        e = this.makeFilterEntry(ResultElementType.JCL_JOB, defaultPatterns, limit);
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamName", "@JCLName");
        e.put(DatabaseMetadata.JOB_ID.getName(), DatabaseMetadata.JOB_ID.getName());
        e.put(DatabaseMetadata.JOB_NAME.getName(), DatabaseMetadata.JOB_NAME.getName());
        e.put(DatabaseMetadata.JOB_MEMBER_NAME.getName(), DatabaseMetadata.JOB_MEMBER_NAME.getName());
        e.put(DatabaseMetadata.CA7_JOB_NAME.getName(), DatabaseMetadata.CA7_JOB_NAME.getName());
        e.put(DatabaseMetadata.CA7_JOB_ID.getName(), DatabaseMetadata.CA7_JOB_ID.getName());
        e.put(DatabaseMetadata.JOB_PATH.getName(), DatabaseMetadata.JOB_PATH.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "PgmUsageInJobsStepLimit", 0);
        e = this.makeFilterEntry(ResultElementType.JCL_STEP, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@StepName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.STEP_NAME.getName(), DatabaseMetadata.STEP_NAME.getName());
        e.put(DatabaseMetadata.STEP_START_ROW.getName(), DatabaseMetadata.STEP_START_ROW.getName());
        e.put(DatabaseMetadata.STEP_PATH.getName(), DatabaseMetadata.STEP_PATH.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "PgmUsageInJobsDDNameLimit", 0);
        e = this.makeFilterEntry(ResultElementType.DDNAME, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@DDName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.DD_NAME.getName(), DatabaseMetadata.DD_NAME.getName());
        e.put(DatabaseMetadata.DD_PATH.getName(), DatabaseMetadata.DD_PATH.getName());
        e.put(DatabaseMetadata.DD_START_ROW.getName(), DatabaseMetadata.DD_START_ROW.getName());
        e.put(DatabaseMetadata.DD_STATUS.getName(), DatabaseMetadata.DD_STATUS.getName());
        e.put(DatabaseMetadata.DD_NORMAL_DISPOSITION.getName(), DatabaseMetadata.DD_NORMAL_DISPOSITION.getName());
        e.put(DatabaseMetadata.DD_ISDUMMY.getName(), DatabaseMetadata.DD_ISDUMMY.getName());
        e.put(DatabaseMetadata.DD_OVERRIDE_DDID.getName(), DatabaseMetadata.DD_OVERRIDE_DDID.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "PgmUsageInJobsDatasetLimit", 0);
        e = this.makeFilterEntry(ResultElementType.DATASET, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@DSName");
        e.put("DynamicProcParamNameSecond", "@DSMemberName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.DATASET_NAME.getName(), DatabaseMetadata.DATASET_NAME.getName());
        e.put(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), DatabaseMetadata.DATASET_MEMBER_NAME.getName());
        e.put(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
        e.put(DatabaseMetadata.DATASET_ID.getName(), DatabaseMetadata.DATASET_ID.getName());
        e.put(DatabaseMetadata.SPOOL_DATASET_CLASS.getName(), DatabaseMetadata.SPOOL_DATASET_CLASS.getName());
        e.put(DatabaseMetadata.DATASET_ISTEMP.getName(), DatabaseMetadata.DATASET_ISTEMP.getName());
        this.entries.add(e);
    }
}

