/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.pgmInJob;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.DatasetFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.pgmInJob.PgmInJobFilter;
import com.ez.analysis.mainframe.usage.pgmInJob.PgmInJobTreeProvider;
import com.ez.analysis.mainframe.usage.pgmInJob.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.JobWithMemberLabelProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgmInJobDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PgmInJobDescriptor.class);
    private static final String PROGRAM_PARAM_NAME = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@PrgLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_PARAM_NAME = "@Ancestor";
    private static final String JCL_PARAM_NAME = "@JCLName";
    private static final String JCL_PARAM_LIMIT = "@JCLLimit";
    private static final String JCL_COLUMN = DatabaseMetadata.JOB_NAME.getName();
    private static final String STEP_PARAM_NAME = "@StepName";
    private static final String STEP_PARAM_LIMIT = "@StepLimit";
    private static final String STEP_COLUMN = DatabaseMetadata.STEP_NAME.getName();
    private static final String DD_PARAM_NAME = "@DDName";
    private static final String DD_PARAM_LIMIT = "@DDLimit";
    private static final String DD_COLUMN = DatabaseMetadata.DD_NAME.getName();
    private static final String DISPLAY_TEMP_DATASETS_PARAM_NAME = "@DisplayTempDatasets";
    private static final String DATASET_PARAM_NAME = "@DSName";
    private static final String DATASET_PARAM_LIMIT = "@DSLimit";
    private static final String DATASET_COLUMN = DatabaseMetadata.DATASET_NAME.getName();
    private static final String DATASET_MEMBER_PARAM_NAME = "@DSMemberName";
    private static final String DATASET_MEMBER_COLUMN = DatabaseMetadata.DATASET_MEMBER_NAME.getName();
    private static final String DATASET_GENERATION_NUMBER_COLUMN = DatabaseMetadata.DATASET_GENERATION_NUMBER.getName();
    public static final String MAINFRAME_PGM_IN_JOB_USAGE = "com.ez.analysis.mainframe.usage.pgm.job";
    private static final String PGM_IN_JOB_USAGE_FILTERS_FILE_NAME = "PgmInJobUsageFilters.properties";
    private static final Map<String, List<ColumnInfo>> PGM_IN_JOB_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
            list = new ArrayList();
            this.put(ResultElementType.JCL_JOB.name(), list);
            list.add(DatabaseMetadata.JOB_ID);
            list.add(DatabaseMetadata.JOB_NAME);
            list.add(DatabaseMetadata.JOB_MEMBER_NAME);
            list.add(DatabaseMetadata.JOB_PATH);
            list = new ArrayList();
            this.put(ResultElementType.JCL_STEP.name(), list);
            list.add(DatabaseMetadata.STEP_NAME);
            list.add(DatabaseMetadata.STEP_PATH);
            list.add(DatabaseMetadata.STEP_START_ROW);
            list = new ArrayList();
            this.put(ResultElementType.DDNAME.name(), list);
            list.add(DatabaseMetadata.DD_NAME);
            list.add(DatabaseMetadata.DD_PATH);
            list.add(DatabaseMetadata.DD_START_ROW);
            list.add(DatabaseMetadata.DD_STATUS);
            list.add(DatabaseMetadata.DD_NORMAL_DISPOSITION);
            list.add(DatabaseMetadata.DD_ISDUMMY);
            list.add(DatabaseMetadata.DD_OVERRIDE_DDID);
            list = new ArrayList();
            this.put(ResultElementType.DATASET.name(), list);
            list.addAll(DatasetUtils.getCsvColumns());
            list.add(DatabaseMetadata.SPOOL_DATASET_CLASS);
        }
    };
    private Map<String, String> spParam;
    private Map<String, String> spWhereClause;
    private Map<String, String> spOrderBy;

    public PgmInJobDescriptor(AbstractAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_PGM_IN_JOB_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new PgmInJobTreeProvider(this);
    }

    @Override
    protected void initializeCsvExportDescriptor() {
        HashMap<ColumnInfo, CsvExportDescriptor.CsvHandler> handlerMap = new HashMap<ColumnInfo, CsvExportDescriptor.CsvHandler>();
        handlerMap.put(DatabaseMetadata.DATASET_NAME, DatasetUtils.getDatasetNameCsvHandler());
        this.csvExportDescriptor = new CsvExportDescriptor(null, handlerMap);
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new PgmInJobFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_PgmInJob";
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.PGM_IN_JOB_HEADER_INFO;
    }

    @Override
    public String getFileName() {
        return PGM_IN_JOB_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return PGM_IN_JOB_CSV_HEADER;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (this.spParam == null) {
            this.spParam = new HashMap<String, String>();
            this.spParam.put(ResultElementType.PROGRAM.name(), "@PrgLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            this.spParam.put(ResultElementType.JCL_JOB.name(), "@JCLLimit INT, @JCLName VARCHAR(64)");
            this.spParam.put(ResultElementType.JCL_STEP.name(), "@StepLimit INT, @StepName VARCHAR(64) ");
            this.spParam.put(ResultElementType.DDNAME.name(), "@DDLimit INT, @DDName VARCHAR(64) ");
            this.spParam.put(ResultElementType.DATASET.name(), "@DisplayTempDatasets INT, @DSLimit INT, @DSName VARCHAR(64), @DSMemberName VARCHAR(64)");
        }
        return this.spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (this.spWhereClause == null) {
            this.spWhereClause = new HashMap<String, String>();
            this.spWhereClause.put(ResultElementType.PROGRAM.name(), " ((@Program = ''%'' or UPPER(ProgramName) " + PROGRAM_LIKE_OR_IN_MARKER + ") AND ((Ancestor is null AND " + ANCESTOR_PARAM_NAME + " =''%'') or (" + ANCESTOR_PARAM_NAME + " = ''%'' or UPPER(Ancestor) " + ANCESTOR_LIKE_OR_IN_MARKER + ")))");
            this.spWhereClause.put(ResultElementType.JCL_JOB.name(), " (@JCLName = ''%'' or UPPER(JobName) " + JOB_LIKE_OR_IN_MARKER + ")");
            this.spWhereClause.put(ResultElementType.JCL_STEP.name(), " (@StepName = ''%'' or UPPER(StepName) " + STEP_LIKE_OR_IN_MARKER + ")");
            this.spWhereClause.put(ResultElementType.DDNAME.name(), " ((DDName is null AND @DDName =''%'') or (@DDName = ''%'' or UPPER(DDName) " + DD_LIKE_OR_IN_MARKER + "))");
        }
        String dsTempCondition = this.isEnableLimits() ? " or not exists( select t.jobId from " + this.getPrepareCacheTable() + " as t where \r\n" + "\t\tt.JobName = " + "DENSE_RANK_TABLE" + ".JobName and t.ProgramName = " + "DENSE_RANK_TABLE" + ".ProgramName and t.StepName = " + "DENSE_RANK_TABLE" + ".StepName\r\n" + "\t\t\tand (t.IsTemp <> 1 or ltrim(t.DataSetMemberName) = ''''))" : "";
        this.spWhereClause.put(ResultElementType.DATASET.name(), " ((DataSetName is null AND @DSName =''%'' AND (DataSetMemberName is null OR ltrim(DataSetMemberName) = '''') AND @DSMemberName =''%'') OR (((@DisplayTempDatasets=0 AND (IsTemp<>1" + dsTempCondition + ")) \n OR (" + DISPLAY_TEMP_DATASETS_PARAM_NAME + "=1))" + " AND (" + DATASET_PARAM_NAME + " = ''%'' or UPPER(DataSetName) " + DS_LIKE_OR_IN_MARKER + ")" + " AND (" + DATASET_MEMBER_PARAM_NAME + " = ''%'' or UPPER(DataSetMemberName) " + DS_MEMBER_LIKE_OR_IN_MARKER + ")))");
        return this.spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(PgmInJobDescriptor.PROGRAM_PARAM_LIMIT).create());
                this.put(ResultElementType.JCL_JOB.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(JCL_COLUMN).limitParamName(PgmInJobDescriptor.JCL_PARAM_LIMIT).create());
                this.put(ResultElementType.JCL_STEP.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STEP_COLUMN).limitParamName(PgmInJobDescriptor.STEP_PARAM_LIMIT).create());
                this.put(ResultElementType.DDNAME.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DD_COLUMN).limitParamName(PgmInJobDescriptor.DD_PARAM_LIMIT).create());
                this.put(ResultElementType.DATASET.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DATASET_COLUMN).additionalOrderByElements(new HashSet<String>(Arrays.asList(DATASET_MEMBER_COLUMN, DATASET_GENERATION_NUMBER_COLUMN))).limitParamName(PgmInJobDescriptor.DATASET_PARAM_LIMIT).create());
            }
        };
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (this.spOrderBy == null) {
            this.spOrderBy = new HashMap<String, String>();
            this.spOrderBy.put(ResultElementType.PROGRAM.name(), "ProgramName");
            this.spOrderBy.put(ResultElementType.JCL_JOB.name(), "JobName");
            this.spOrderBy.put(ResultElementType.JCL_STEP.name(), "StepName");
            this.spOrderBy.put(ResultElementType.DDNAME.name(), "DDName");
            this.spOrderBy.put(ResultElementType.DATASET.name(), "DataSetName");
        }
        return this.spOrderBy;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "PgmInJob";
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_JOB, JCL_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_STEP, STEP_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.DDNAME, DD_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.DATASET, DATASET_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public boolean hasReorderResultsAction() {
        return false;
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        getFilterEntryParameterGeneratorMap.put(ResultElementType.DATASET.name(), new DatasetFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }

    @Override
    public IBaseLabelProvider getResultsLabelProvider(ImageRegistry imgRegistry) {
        return new JobWithMemberLabelProvider(imgRegistry);
    }
}

