/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.model.validation;

import com.ez.analysis.mainframe.usage.model.validation.IntRangeValidator;
import com.ez.analysis.mainframe.usage.preferences.PreferencesUtils;
import org.eclipse.jface.preference.IPreferenceStore;

public class IntRangePreferenceValidator
extends IntRangeValidator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String lowestKey;
    private String highestKey;

    public IntRangePreferenceValidator(Integer defaultValue, String lowestKey, Integer lowestValue, String highestKey, Integer highestValue) {
        super(defaultValue, lowestValue, highestValue);
        this.lowestKey = lowestKey;
        this.highestKey = highestKey;
    }

    @Override
    protected Integer getLow() {
        Integer low = super.getLow();
        IPreferenceStore store = PreferencesUtils.getPreferenceStore();
        if (this.lowestKey != null) {
            low = store.getInt(this.lowestKey);
            Integer dv = (Integer)this.getDefault();
            if (dv < low) {
                low = dv;
            }
        }
        return low;
    }

    @Override
    protected Integer getHigh() {
        Integer high = super.getHigh();
        IPreferenceStore store = PreferencesUtils.getPreferenceStore();
        if (this.highestKey != null) {
            high = store.getInt(this.highestKey);
            Integer dv = (Integer)this.getDefault();
            if (dv > high) {
                high = dv;
            }
        }
        return high;
    }
}

