/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.model;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.results.comparator.VariableSectionTypeComparator;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class ResultElement
extends AbstractResultElement {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PROGRAM_TYPE_ID_KEY = "Program Type Id";
    public static final String ANCESTOR_NAME_KEY = "Ancestor Name";
    public static final String ANCESTOR_ID_KEY = "Ancestor Id";
    public static final String RESOURCE_TYPE = "Resource Type";
    public static final String IS_IDMSX_KEY = "Is IDMSX Key";
    public static final String STMT_PATH_KEY = "Stmt Path";
    public static final String STMT_START_ROW_KEY = "Stmt Start Row";
    public static final String DBI_ACCESS = "Stmt DBI Access";
    public static final String PROGRAM_NAME_KEY = "Program name";
    public static final String ADABAS_NOT_AVAILABLE = "adabasNotAvailable";
    public static final String IMSDB_ELEMENT = "element of IMS/DB";
    public static final String IMSDB_LOGICAL_SEGMENT_NAME = "Logical segment name";
    public static final String IMSDB_LOGICAL_SEGMENT_DB_NAME = "Logincal segment DB name";
    public static final String STMT_OCCUR_ID_KEY = "STMT_OCCUR_ID_KEY";
    public static final String VAR_IS_INCLUDE = "VarIsInclude";
    public static final String PATHS_TO_SOURCE_FILE = "FILE";

    public ResultElement(String name, ResultElementType type, ResultElement parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
    }

    public ResultElement getChild(String name) {
        return (ResultElement)(this.children != null ? (AbstractResultElement)this.children.get(name) : null);
    }

    public String getDisplayName() {
        String ret = this.name;
        if (this.type != null && this.type.equals((Object)ResultElementType.STMT_SOURCE_INFO)) {
            Integer startRow;
            String stmtPath = (String)this.getProperty(DatabaseMetadata.STMT_PATH_STR.getName());
            if (stmtPath != null && !stmtPath.isEmpty() && stmtPath.lastIndexOf("\\") > 0) {
                this.name = stmtPath.substring(stmtPath.lastIndexOf("\\") + 1);
                int extensionPosition = this.name.toLowerCase().lastIndexOf(".txt");
                if (extensionPosition > 0) {
                    this.name = this.name.substring(0, extensionPosition);
                }
            }
            ret = (startRow = (Integer)this.properties.get(STMT_START_ROW_KEY)) != null ? Messages.getString(ResultElement.class, "display.name.line", new String[]{this.name.toUpperCase(), startRow.toString()}) : this.name.toUpperCase();
        }
        if (this.type != null && this.type.equals((Object)ResultElementType.PROGRAM)) {
            Integer programTypeId = (Integer)this.properties.get(PROGRAM_TYPE_ID_KEY);
            switch (programTypeId) {
                case 15: 
                case 16: {
                    String ancestorName = (String)this.properties.get(ANCESTOR_NAME_KEY);
                    ret = String.valueOf(Utils.getPrgType((String)programTypeId.toString())) + " - " + ancestorName + ":" + this.name;
                }
            }
        }
        if (ResultElementType.VARIABLE.equals((Object)this.type)) {
            Integer level = (Integer)this.getProperty(DatabaseMetadata.VAR_iLevel.getName());
            if (level != null) {
                ret = String.valueOf(String.format("%02d", level)) + " " + this.name;
            }
            if (this.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(1) && ((Boolean)this.properties.get(VAR_IS_INCLUDE)).booleanValue()) {
                int extensionPosition;
                String includeOfCobolVarPath = null;
                Iterator iteratorOverTextSelectionsInFile = ((HashSet)this.properties.get(PATHS_TO_SOURCE_FILE)).iterator();
                if (iteratorOverTextSelectionsInFile.hasNext()) {
                    TextSelectionInFile anyResult = (TextSelectionInFile)iteratorOverTextSelectionsInFile.next();
                    includeOfCobolVarPath = anyResult.getFileName();
                }
                String fileName = null;
                if (includeOfCobolVarPath != null && !includeOfCobolVarPath.isEmpty() && includeOfCobolVarPath.lastIndexOf("\\") > 0 && (extensionPosition = (fileName = includeOfCobolVarPath.substring(includeOfCobolVarPath.lastIndexOf("\\") + 1)).toLowerCase().lastIndexOf(".txt")) > 0) {
                    fileName = fileName.substring(0, extensionPosition);
                }
                if (fileName != null && !fileName.isEmpty()) {
                    ret = String.valueOf(ret) + " (" + fileName + ")";
                }
            }
        }
        if (ResultElementType.DATASET.equals((Object)this.type)) {
            Object generationNo = this.getProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
            Object datasetMemberName = this.getProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
            ret = DatasetUtils.getFullDSName(ret, generationNo != null ? Integer.valueOf(generationNo.toString()) : null, datasetMemberName != null ? datasetMemberName.toString() : null);
        }
        if (ResultElementType.DDCL_PROPERTY_SOURCE_INFO.equals((Object)this.type)) {
            String alias = (String)this.getProperty(DatabaseMetadata.DDCL_ALIAS.getName());
            String propertyPath = (String)this.getProperty(DatabaseMetadata.DDCL_FILE_PATH.getName());
            if (propertyPath != null && !propertyPath.isEmpty() && propertyPath.lastIndexOf("\\") > 0) {
                this.name = propertyPath.substring(propertyPath.lastIndexOf("\\") + 1);
                int extensionPosition = this.name.toLowerCase().lastIndexOf(".txt");
                if (extensionPosition > 0) {
                    this.name = this.name.substring(0, extensionPosition);
                }
            }
            Integer startRow = (Integer)this.getProperty(DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName());
            ret = Messages.getString(ResultElement.class, "display.name.line", new String[]{this.name.toUpperCase(), startRow.toString()});
            ret = alias != null ? String.valueOf(alias) + " - " + ret : ret;
        }
        return ret;
    }

    public ResultElement getParent() {
        return (ResultElement)((Object)(this.parent != null && "root".equals(this.parent.getName()) ? null : this.parent));
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public void addChild(String nameKey, ResultElement child) {
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        if (child != null) {
            this.children.put(nameKey, child);
        }
    }

    public Object hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public int compareTo(AbstractResultElement o) {
        int ret = 0;
        if (o instanceof ResultElement) {
            if (this.type.equals((Object)ResultElementType.LIMIT_REACHED)) {
                return -1;
            }
            if (o.getType().equals((Object)ResultElementType.LIMIT_REACHED)) {
                return 1;
            }
            ResultElement other = (ResultElement)o;
            if (this.type.equals((Object)ResultElementType.VARIABLE) && other.type.equals((Object)ResultElementType.VARIABLE)) {
                if (this.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(1)) {
                    ret = this.commpareCobolVariableToCobolVariable(other);
                }
            } else if (this.type.equals((Object)ResultElementType.VARIABLE_SECTION_TYPE) && other.type.equals((Object)ResultElementType.VARIABLE_SECTION_TYPE) && this.getProperty(DatabaseMetadata.PRG_TYPE_ID.getName()).equals(1)) {
                ret = this.commpareCobolVariableSectionTypeToCobolVariableSectionType(other);
            }
            if (this.type.equals((Object)ResultElementType.IMSDB_SEGMENT) && other.type.equals((Object)ResultElementType.IMSDB_FIELD)) {
                ret = this.type.getDisplayName().compareTo(other.type.getDisplayName());
            }
            if (ret == 0) {
                if (this.type.equals((Object)ResultElementType.STMT_SOURCE_INFO)) {
                    ret = this.getName().compareToIgnoreCase(other.getName());
                    if (ret == 0) {
                        Integer startRow1 = (Integer)this.properties.get(STMT_START_ROW_KEY);
                        Integer startRow2 = (Integer)other.properties.get(STMT_START_ROW_KEY);
                        ret = startRow1.compareTo(startRow2);
                    }
                } else {
                    ret = this.getDisplayName().compareToIgnoreCase(other.getDisplayName());
                }
            }
        }
        return ret;
    }

    private int commpareCobolVariableToCobolVariable(ResultElement other) {
        SortingProperty[] sortingProperties = new SortingProperty[]{new SortingProperty(DatabaseMetadata.VAR_ID.getName())};
        return this.compareToByProperties(other, sortingProperties);
    }

    private int commpareCobolVariableSectionTypeToCobolVariableSectionType(ResultElement other) {
        SortingProperty[] sortingProperties = new SortingProperty[]{new SortingProperty(DatabaseMetadata.VAR_SECTION_TYPE.getName(), ResultElement.getVariableSectionTypeComparator())};
        return this.compareToByProperties(other, sortingProperties);
    }

    private int compareToByProperties(ResultElement other, SortingProperty[] sortingProperties) {
        int retVal = 0;
        SortingProperty[] sortingPropertyArray = sortingProperties;
        int n = sortingProperties.length;
        int n2 = 0;
        while (n2 < n) {
            SortingProperty sortingPropery = sortingPropertyArray[n2];
            Object thisProperty = this.getProperty(sortingPropery.getPropertyName());
            Object otherProperty = other.getProperty(sortingPropery.getPropertyName());
            if (thisProperty == null || otherProperty == null) {
                System.out.print("");
            } else {
                if (!thisProperty.getClass().equals(otherProperty.getClass())) {
                    throw new IllegalStateException("unexpected state: properties are expected to be of the same type");
                }
                if (sortingPropery.getComparator() != null) {
                    retVal = sortingPropery.getComparator().compare(thisProperty, otherProperty);
                } else if (thisProperty instanceof Number) {
                    retVal = Double.valueOf(((Number)thisProperty).doubleValue()).compareTo(((Number)otherProperty).doubleValue());
                } else if (thisProperty instanceof String) {
                    retVal = ((String)thisProperty).compareTo((String)otherProperty);
                } else if (thisProperty instanceof Boolean) {
                    retVal = ((Boolean)thisProperty).compareTo((Boolean)otherProperty);
                } else {
                    throw new IllegalStateException("unexpected state: " + thisProperty.getClass() + " compare");
                }
            }
            if (retVal != 0) break;
            ++n2;
        }
        return retVal;
    }

    public String toString() {
        return String.valueOf(ResultElement.class.getSimpleName()) + " [name=" + this.name + ", type=" + this.type + "]";
    }

    private static Comparator<Object> getVariableSectionTypeComparator() {
        return new VariableSectionTypeComparator();
    }

    private static class SortingProperty {
        private final String propertyName;
        private final Comparator<Object> comparator;

        public SortingProperty(String propertyName) {
            this(propertyName, null);
        }

        public SortingProperty(String propertyName, Comparator<Object> comparator) {
            this.propertyName = propertyName;
            this.comparator = comparator;
        }

        public Comparator<Object> getComparator() {
            return this.comparator;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

