/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.model;

import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IdentityValidator;
import com.ez.analysis.mainframe.usage.model.validation.Validator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.HashMap;
import java.util.Map;

public class FilterEntry {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String CAN_MODIFY_KEY = "canModify";
    public static final String TEST_AT_FILTER_ACTION = "testAtFilterAction";
    public static final String NAME = "filterEntryName";
    public static final String ENTRY_IS_COMBO = "entry has button and a drop-down list of values";
    public static final String ENTRY_COMBO_VALUE = "value from combo";
    public static final String ENTRY_IS_DIALOG_TEXT = "entry is a text field and opens a dialog for the list of values";
    public static final String ENTRY_DIALOG_TEXT_VALUE = "value from a dialog of a text";
    public static final String PARAMETER_NAME_KEY = "DynamicProcParamName";
    public static final String PARAMETER_NAME_SECOND_KEY = "DynamicProcParamNameSecond";
    public static final String TEMP_TABLE_VALUES_KEY = "TempTableValues";
    public static final String TEMP_TABLE_VALUES_SECOND_KEY = "TempTableValuesSecond";
    public static final String TEMP_TABLE_NAME_KEY = "TempTableName";
    public static final String TEMP_TABLE_NAME_SECOND_KEY = "TempTableNameSecond";
    public static final String SEARCH_ALIASES = "must search aliases";
    public static final String FIXED_POSITION_IN_TABLE = "Fixed.position";
    protected GroupFilterEntry groupFilterEntry;
    private Map<String, String> data;
    public static final String ATTR_USE = Messages.getString(FilterEntry.class, "use.attribute.name");
    public static final String ATTR_NAME = Messages.getString(FilterEntry.class, "name.attribute.name");
    public static final String ATTR_FILTER = Messages.getString(FilterEntry.class, "filter.attribute.name");
    public static final String ATTR_LIMIT = Messages.getString(FilterEntry.class, "limit.attribute.name");
    public static final int USE = 0;
    public static final int DISPLAY_NAME = 1;
    public static final int FILTER = 2;
    public static final int LIMIT = 3;
    public static final String[] ENTRY_ATTRIBUTES = new String[4];
    public Validator[] entryValidators;

    static {
        FilterEntry.ENTRY_ATTRIBUTES[0] = ATTR_USE;
        FilterEntry.ENTRY_ATTRIBUTES[1] = ATTR_NAME;
        FilterEntry.ENTRY_ATTRIBUTES[2] = ATTR_FILTER;
        FilterEntry.ENTRY_ATTRIBUTES[3] = ATTR_LIMIT;
    }

    public FilterEntry(ResultElementType type, String defaultPattern, Integer defaultLimit) {
        IdentityValidator id = new IdentityValidator();
        this.entryValidators = new Validator[ENTRY_ATTRIBUTES.length];
        int i = 0;
        while (i < ENTRY_ATTRIBUTES.length) {
            this.entryValidators[i] = id;
            ++i;
        }
        this.data = new HashMap<String, String>();
        this.data.put(ENTRY_ATTRIBUTES[0], Boolean.toString(true));
        String paramName = type.name();
        String paramDisplayName = type.getDisplayName();
        this.data.put(ENTRY_ATTRIBUTES[1], paramDisplayName);
        this.data.put(ENTRY_ATTRIBUTES[2], defaultPattern == null ? "" : defaultPattern);
        if (defaultLimit != null) {
            this.data.put(ENTRY_ATTRIBUTES[3], defaultLimit.toString());
        } else {
            this.data.put(ENTRY_ATTRIBUTES[3], null);
        }
        this.data.put(NAME, paramName);
    }

    public String get(String key) {
        String r = this.data.get(key);
        if (r == null) {
            r = "";
        }
        return r;
    }

    public void put(String key, String val) {
        this.data.put(key, val);
    }

    public String getValidAttribute(int index) {
        String value = this.data.get(ENTRY_ATTRIBUTES[index]);
        return this.getValidValue(index, value);
    }

    public String getValidValue(int index, String valRep) {
        Object valueFor = this.entryValidators[index].getValueFor(valRep);
        return valueFor != null ? valueFor.toString() : null;
    }

    public int getPropertyIndex(String propertyName) {
        int result = -1;
        int i = 0;
        while (i < ENTRY_ATTRIBUTES.length) {
            if (ENTRY_ATTRIBUTES[i].equals(propertyName)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public void setValidator(int category, Validator newValidator) {
        this.entryValidators[category] = newValidator;
    }

    public String toString() {
        return this.toDisplay(true);
    }

    public String toDisplay(boolean enableLimits) {
        StringBuilder sBuilder = new StringBuilder();
        String filterCategoryName = this.data.get(ENTRY_ATTRIBUTES[1]);
        sBuilder.append(filterCategoryName);
        sBuilder.append("(");
        int i = 2;
        while (i < ENTRY_ATTRIBUTES.length) {
            if (this.canModify(i) && (!ATTR_LIMIT.equals(ENTRY_ATTRIBUTES[i]) || enableLimits)) {
                String filterAttributeValue = this.data.get(ENTRY_ATTRIBUTES[i]);
                if (filterAttributeValue != null && filterAttributeValue.length() > 0) {
                    if (filterAttributeValue.length() > 20) {
                        filterAttributeValue = filterAttributeValue.substring(0, 17).concat("...");
                    }
                    sBuilder.append(filterAttributeValue);
                } else {
                    sBuilder.append("*");
                }
                sBuilder.append("; ");
            }
            ++i;
        }
        sBuilder.delete(sBuilder.length() - 2, sBuilder.length());
        sBuilder.append(")");
        return sBuilder.toString();
    }

    public boolean isEntryInUse() {
        return Boolean.toString(true).equals(this.getValidAttribute(0));
    }

    public boolean canModify(int idx) {
        if (idx >= 0) {
            String canModify = this.get(CAN_MODIFY_KEY.concat(ENTRY_ATTRIBUTES[idx]));
            return canModify.equals("") || Boolean.getBoolean(canModify);
        }
        return false;
    }

    public boolean canModify(String propertyName) {
        return this.canModify(this.getPropertyIndex(propertyName));
    }

    public boolean testAtFilterAction(int idx) {
        if (idx >= 0) {
            String canModify = this.get(TEST_AT_FILTER_ACTION.concat(ENTRY_ATTRIBUTES[idx]));
            return canModify.equals("") || Boolean.getBoolean(canModify);
        }
        return false;
    }

    public boolean testAtFilterAction(String propertyName) {
        return this.testAtFilterAction(this.getPropertyIndex(propertyName));
    }

    public GroupFilterEntry getGroupFilterEntry() {
        return this.groupFilterEntry;
    }

    public boolean isComboEntry() {
        String isCombo = this.get(ENTRY_IS_COMBO);
        return isCombo != null && Boolean.TRUE.toString().equals(isCombo);
    }

    public boolean isDialogTextEntry() {
        String isDialogText = this.get(ENTRY_IS_DIALOG_TEXT);
        return isDialogText != null && Boolean.TRUE.toString().equals(isDialogText);
    }

    public String getComboValue() {
        return this.get(ENTRY_COMBO_VALUE);
    }

    public String getDialogTextValue() {
        String ret = this.get(ENTRY_DIALOG_TEXT_VALUE);
        if (StmtDialogTextCellEditor.DEFAULT_ALLSTMT.equals(ret)) {
            ret = "";
        }
        return ret;
    }

    public boolean mustSolveAliases() {
        return Boolean.toString(true).equals(this.get(SEARCH_ALIASES));
    }

    public boolean useTempTable() {
        return this.mustSolveAliases();
    }
}

