/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.jobInfo;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcCallback
extends AbstractProcessRowCallback {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LoggerFactory.getLogger(ProcCallback.class);

    public ProcCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
        super(root, levelsOrder, elemTypeToElemNameColumnsMap);
    }

    @Override
    public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
        ResultElement parent = this.root;
        ProjectInfo projectInfo = r.getProjectInfo();
        int levelIndex = 0;
        while (levelIndex < this.levelsOrder.size()) {
            String name;
            ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
            String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
            String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
            if (levelElementType == ResultElementType.JCL_PROCEDURE) {
                ResultElement categoryResultElement;
                parent = categoryResultElement = Utils.getCategory(levelElementType, parent, null);
            } else if (ResultElementType.JCL_JOB.equals((Object)levelElementType)) {
                String jobMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName()));
                name = key = name.concat(jobMemberName);
            }
            ResultElement resultElement = parent.getChild(key);
            if (resultElement == null) {
                resultElement = new ResultElement(key, levelElementType, parent);
                this.addElementInfo(resultElement, r);
                Utils.completeProjectInfo(resultElement, projectInfo);
                parent.addChild(key, resultElement);
            }
            parent = resultElement;
            ++levelIndex;
        }
        return true;
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case JCL_PROCEDURE: {
                String procName = (String)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP.getName());
                resultElement.addProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName(), procName);
                String procPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_PATH.getName()));
                String type = ResultElementType.JCL_PROCEDURE.getDisplayName();
                Integer procStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_START_ROW.getName());
                Integer procStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_START_COL.getName());
                Integer procEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_END_ROW.getName());
                Integer procEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PROC_EXEC_IN_STEP_END_COL.getName());
                MainframeSourceNode prgNode = new MainframeSourceNode(type, procPath);
                resultElement.addProperty("Node_Mainframe", prgNode);
                Utils.setFileAttribute(resultElement, "22", procPath, procStartRow, procStartCol, procEndRow, procEndCol);
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
            }
        }
    }
}

