/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.jobInfo;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PgmCallback
extends AbstractProcessRowCallback {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LoggerFactory.getLogger(PgmCallback.class);

    public PgmCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
        super(root, levelsOrder, elemTypeToElemNameColumnsMap);
    }

    @Override
    public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
        ResultElement parent = this.root;
        ProjectInfo projectInfo = r.getProjectInfo();
        int levelIndex = 0;
        while (levelIndex < this.levelsOrder.size()) {
            String name;
            ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
            String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
            String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
            if (levelElementType == ResultElementType.PROGRAM) {
                ResultElement categoryResultElement;
                String pgmCategoryKey = ResultElementType.PGM_CATEGORY.name();
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                if (id != null) {
                    key = id.toString().concat("__").concat(name);
                }
                if ((categoryResultElement = parent.getChild(pgmCategoryKey)) == null) {
                    String pgmCategoryDisplayName = ResultElementType.PGM_CATEGORY.getDisplayName();
                    categoryResultElement = new ResultElement(pgmCategoryDisplayName, ResultElementType.PGM_CATEGORY, parent);
                    parent.addChild(pgmCategoryKey, categoryResultElement);
                }
                parent = categoryResultElement;
                parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
            } else if (ResultElementType.JCL_JOB.equals((Object)levelElementType)) {
                String jobMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName()));
                name = key = name.concat(jobMemberName);
            }
            ResultElement resultElement = parent.getChild(key);
            if (resultElement == null) {
                resultElement = new ResultElement(name, levelElementType, parent);
                this.addElementInfo(resultElement, r);
                Utils.completeProjectInfo(resultElement, projectInfo);
                parent.addChild(key, resultElement);
            }
            parent = resultElement;
            ++levelIndex;
        }
        return true;
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case PROGRAM: {
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                if (programTypeId == null) {
                    programTypeId = ProgramUtils.getFakeProgTypeID(resultElement.getName());
                }
                resultElement.addProperty("Program Type Id", programTypeId);
                String programName = (String)r.getColumnValue(DatabaseMetadata.PRG_NAME.getName());
                String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                if (!programPath.isEmpty()) {
                    ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                } else {
                    ProgramUtils.setPropertiesViewer(resultElement, programName, "", programType);
                }
                String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                if (ancestorName == null || ancestorName.isEmpty()) break;
                resultElement.addProperty("Ancestor Name", ancestorName);
                Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                resultElement.addProperty("Ancestor Id", ancestorId);
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
            }
        }
    }
}

