/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.jobInfo;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.jobInfo.PgmCallback;
import com.ez.analysis.mainframe.usage.jobInfo.ProcCallback;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class JobDSTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public JobDSTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        ArrayList<ResultElementType> levelsOrderWithDataset = new ArrayList<ResultElementType>(levelsOrder);
        levelsOrderWithDataset.add(ResultElementType.DATASET);
        MyCallback callback = new MyCallback(root, levelsOrderWithDataset, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
        if (this.descriptor.mustRunAdditionalSP()) {
            RecordsetProvider pgmProvider = this.descriptor.getRecordsetProvider("PgmInJob");
            ArrayList<ResultElementType> levelsOrderWithPrg = new ArrayList<ResultElementType>(levelsOrder);
            levelsOrderWithPrg.add(ResultElementType.PROGRAM);
            PgmCallback pgmCallback = new PgmCallback(root, levelsOrderWithPrg, elemTypeToElemNameColumnsMap);
            pgmProvider.load(pgmCallback, monitor);
            RecordsetProvider procProvider = this.descriptor.getRecordsetProvider("ProcedureInJob");
            ArrayList<ResultElementType> levelsOrderWithPrc = new ArrayList<ResultElementType>(levelsOrder);
            levelsOrderWithPrc.add(ResultElementType.JCL_PROCEDURE);
            ProcCallback procCallback = new ProcCallback(root, levelsOrderWithPrc, elemTypeToElemNameColumnsMap);
            procProvider.load(procCallback, monitor);
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex < this.levelsOrder.size()) {
                String name;
                ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                if (ResultElementType.JCL_JOB.equals((Object)levelElementType)) {
                    String jobMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName()));
                    key = name.concat(jobMemberName);
                } else if (levelElementType.equals((Object)ResultElementType.DATASET)) {
                    ResultElement categoryResultElement;
                    if (name.isEmpty()) break;
                    parent = categoryResultElement = Utils.getCategory(levelElementType, parent, null);
                    String datasetMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName()));
                    key = name.concat(datasetMemberName);
                }
                ResultElement resultElement = parent.getChild(key);
                if (resultElement == null) {
                    resultElement = new ResultElement(name, levelElementType, parent);
                    this.addElementInfo(resultElement, r);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    parent.addChild(key, resultElement);
                }
                JobDSTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                parent = resultElement;
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case JCL_JOB: {
                    String jobName = (String)r.getColumnValue(DatabaseMetadata.JOB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_NAME.getName(), jobName);
                    String memberName = (String)r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName(), memberName);
                    Integer jobId = (Integer)r.getColumnValue(DatabaseMetadata.JOB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_ID.getName(), jobId);
                    String ca7jobName = (String)r.getColumnValue(DatabaseMetadata.CA7_JOB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.CA7_JOB_NAME.getName(), ca7jobName);
                    Integer ca7JobId = (Integer)r.getColumnValue(DatabaseMetadata.CA7_JOB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.CA7_JOB_ID.getName(), ca7JobId);
                    String path = (String)r.getColumnValue(DatabaseMetadata.JOB_PATH.getName());
                    Utils.setFileAttribute(resultElement, "22", path, new Integer[0]);
                    resultElement.addProperty("Node_Mainframe", new MainframeSourceNode(ResultElementType.JCL_JOB.getDisplayName(), path));
                    break;
                }
                case DATASET: {
                    Integer dsGenerationnNo;
                    String dataset = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.DATASET_NAME.getName(), dataset);
                    Integer dsId = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.DATASET_ID.getName(), dsId);
                    String ddName = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.DD_NAME.getName(), ddName);
                    String datasetMemberName = "";
                    if (r.hasColumn(DatabaseMetadata.DATASET_MEMBER_NAME.getName())) {
                        datasetMemberName = (String)r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
                        resultElement.addProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), datasetMemberName);
                    }
                    if ((dsGenerationnNo = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName())) != null) {
                        resultElement.addProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), dsGenerationnNo);
                        resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)dsGenerationnNo, ResultElementType.DATASET.getDisplayName()));
                        break;
                    }
                    resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)"", ResultElementType.DATASET.getDisplayName()));
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

