/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.include;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.include.InclVarCallback;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class IncludeTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected List<ResultElementType> elementTypes = null;

    public IncludeTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
        if (this.descriptor.mustRunAdditionalSP()) {
            RecordsetProvider varProvider = this.descriptor.getRecordsetProvider("VariableFromInclude");
            InclVarCallback varCallback = new InclVarCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
            varProvider.load(varCallback, monitor);
        }
    }

    protected void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case PROGRAM: {
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                if (ancestorName != null && !ancestorName.isEmpty()) {
                    resultElement.addProperty("Ancestor Name", ancestorName);
                    Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                    resultElement.addProperty("Ancestor Id", ancestorId);
                }
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case INCLUDE: {
                String resourceName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.INCLUDE_NAME.getName()));
                resultElement.addProperty(DatabaseMetadata.INCLUDE_NAME.getName(), resourceName);
                String inclPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.INCLUDE_PATH.getName()));
                resultElement.addProperty("include is not on disk", inclPath.equals(""));
                Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_START_ROW.getName());
                Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_START_COL.getName());
                Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_END_ROW.getName());
                Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.INCLUDE_END_COL.getName());
                resultElement.addProperty(DatabaseMetadata.INCLUDE_RESOURCE_PATH_ID.getName(), r.getColumnValue(DatabaseMetadata.INCLUDE_PATH_ID.getName()));
                MainframeSourceNode prgNode = new MainframeSourceNode(ResultElementType.INCLUDE.getDisplayName(), inclPath);
                resultElement.addProperty("Node_Mainframe", prgNode);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                Utils.setFileAttribute(resultElement, String.valueOf(programTypeId), inclPath, startRow, startCol, endRow, endCol);
                resultElement.addProperty("Program Type Id", programTypeId);
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case STMT_SOURCE_INFO: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                Integer resourceTypeID = (Integer)r.getColumnValue(DatabaseMetadata.RESOURCE_TYPE.getName());
                resultElement.addProperty(DatabaseMetadata.RESOURCE_TYPE.getName(), resourceTypeID);
                String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
                String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_TYPE_NAME.getName());
                resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                resultElement.addProperty("Stmt Start Row", startRow);
                Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
            }
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    if (!ResultElementType.VARIABLE.equals((Object)levelElementType)) {
                        ResultElement resultElement;
                        String name;
                        String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                        if (elemNameColumn == null) {
                            throw new IllegalArgumentException("No column for ressource " + levelElementType);
                        }
                        String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                        if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                            parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                            if (id != null) {
                                key = Utils.getKeyForVariable(name, Utils.getKeyForVariable(projectInfo.getName(), id));
                            }
                        }
                        if ((resultElement = parent.getChild(key)) == null) {
                            resultElement = new ResultElement(name, levelElementType, parent);
                            IncludeTreeProvider.this.addElementInfo(resultElement, r);
                            Utils.completeProjectInfo(resultElement, projectInfo);
                            parent.addChild(key, resultElement);
                        }
                        IncludeTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                    }
                } else if (levelIndex == this.levelsOrder.size()) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.PROGRAM);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    resultElement.addProperty("STMT_OCCUR_ID_KEY", r.getColumnValue(DatabaseMetadata.STMT_OCCUR_ID.getName()));
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    IncludeTreeProvider.this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

